+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2018-12-04T13:01:00-05:00"
lastmod = "2018-12-04T13:20:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946076500/sqAliceCoote_SiobhanStagg_CENDRILLON_LyricOperaofChicago_CamB-77_c.jpg.jpg"
primary_image_credit = "Alice Coote and Siobhan Stagg in Cendrillon, Lyric Opera of Chicago, 2018. Photo: Lyric Opera of Chicago."
publishDate = "2018-12-04T13:20:00-05:00"
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/alice-coote.md","scene/people/siobhan-stagg.md"]
short_description = "At this point, Alice Coote is virtually synonymous with this production of Cendrillon, having sung the role of Prince Charming in London, Barcelona, and New York in recent seasons. She brings a beautiful, rich tone and an affable touch to Prince Charming&#039;s moping. Stagg and Coote&#039;s duets are especially rapturous, with their beautifully-matched instruments making Act III&#039;s long-anticipated reunion all the more sublime."
slug = "actual-magic-in-chicago-lyrics-cendrillon"
title = "Actual magic in Chicago Lyric&#039;s Cendrillon"
+++

Sandwiched between performances of the very serious [(and very good) *Il trovatore*](/history-making-cast-in-chicagos-il-trovatore/), Massenet's [*Cendrillon*](https://www.lyricopera.org/concertstickets/calendar/2018-2019/cendrillon-opera-tickets) is a much-needed counterweight to the Lyric Opera of Chicago's rather drama-packed 2018-2019 season.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946112201/SiobhanStagg_CENDRILLON_LyricOperaofChicago_LYR181128_242_c.jpg.jpg)
<figcaption>Siobhan Stagg as Cendrillon in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

This now-famous production of *Cendrillon* by Laurent Pelly, originated in Santa Fe over a decade ago, has since traveled through Europe, landing back stateside at the Metropolitan Opera just last spring. It is a visually splendid production played as a (quite literal) storybook-come-to life, (pages of the original *Cinderella* fairy tale are projected perpetually onto the set's walls.) This show demands a physicality and precise comic timing from the entire cast, many of them physically restricted in highly-architectural (and hilarious) costumes, also by Pelly. The end result: a true spectacle that is a delight from start to finish. 

Of course, at the heart of this story is Cinderella herself. Making her American debut, Australian soprano Siobhan Stagg is wonderful as our kind-hearted heroine. She is perfectly cast here, with a youthful, shimmery voice that is remarkable above all for its ease of tone, (no small feat at the Lyric, the second-largest opera house in North America.) Especially with all the zany characters in her orbit, the character Cinderella could be boring, but Stagg's considerable charms ensure we're rooting for her beginning to end. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946263130/SiobhanStagg_CENDRILLON_LyricOperaofChicago_CamB85_c.jpg.jpg)
<figcaption>Siobhan Stagg as Cendrillon in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Lyric Opera of Chicago.</figcaption>
</figure>

At this point, Alice Coote is virtually synonymous with this production of *Cendrillon*, having sung the role of Prince Charming in London, Barcelona, and New York in recent seasons. She brings a beautiful, rich tone and an affable touch to Prince Charming's moping. Stagg and Coote's duets are especially rapturous, with their beautifully-matched instruments making Act III's long-anticipated reunion all the more sublime.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946121776/AliceCoote_CENDRILLON_LyricOperaofChicago_LYR181128_255_c.jpg.jpg)
<figcaption>Alice Coote as Prince Charming in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

As the mercurial stepmother Mme. de la Haltière, I got the impression that Elizabeth Bishop wasn’t having as much fun as she could be. I craved a more imperious, full-throated wickedness! Another Aussie, rich-voiced bass-baritone Derek Welton, was surprisingly winsome as her ambivalent husband, the wishy-washy Pandolfe.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946132997/ElizabethBishop_EmilyPogorelc_KayleighDecker_CENDRILLON_LyricOperaofChicago_LYR181128_046_c.jpg.jpg)
<figcaption>Elizabeth Bishop, Emily Pogorel, and Kayleigh Decker in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Canadian coloratura Marie-Eve Munger makes her house debut as the Fairy Godmother, the capricious but ultimately compassionate Fairy. Munger is captivating as she sashays around, saucily clutching her magic wand and tossing off stratospheric coloratura as she directs the spirits to do her bidding. Her high-notes are clarion, though that brilliance is occasionally missed when the melodies dip below the ledger lines.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946141257/MarieEveMunger_CENDRILLON_LyricOperaofChicago_LYR181128_207_c.jpg.jpg)
<figcaption>Marie-Eve Munger as the Fairy Godmother in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Patrick G. and Shirley W. Ryan Opera Center members fill out the cast, with soprano Emily Pogorelc and Kayleigh Decker deserving special kudos for their comic turns as Noémie and Dorothée, the goofy step-sisters. In comprimario roles, fellow ROC singers Christopher Kenney (baritone), Josh Lovell (tenor), David Weigel (bass-baritone) give strong, (if brief), performances as effete courtiers, all looking smashing in their powdered wigs and be-ribboned coats. Alan Higgs (bass-baritone) is every inch the benevolent King.

Sir Andrew Davis conducts this très charmante score with obvious joy and great aplomb. The LOC chorus look and sound fabulous as the sundry aristocrats and servants that populate this magical kingdom. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543946295535/SiobhanStagg_CENDRILLON_LyricOperaofChicago_LYR181128_215_c.jpg.jpg)
<figcaption>Siobhan Stagg as Cendrillon in *Cendrillon*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

At two hours and forty-five minutes, *Cendrillon* might be a tad long for children of all ages, but it is a truly magical show and I heartily recommend it, (as does the eleven year-old who sat across the aisle from me). In any case, you have two more chances to see [*Cendrillon*](https://www.lyricopera.org/concertstickets/calendar/2018-2019/cendrillon-opera-tickets) this December, and the production will be back at Lyric Opera of Chicago for three performances in January as well.
