+++
author = ["authors/thomas-pierce.md"]
categories = "Review"
date = "2017-10-05T09:39:00-04:00"
lastmod = "2017-10-05T10:01:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507211715037/2017-10-05---square---purcells-arthur-002.jpg.jpg"
primary_image_credit = "The Academy of Ancient Music's King Arthur, Barbican Hall, October 3, 2017. Photo: Robert Workman."
publishDate = "2017-10-05T10:01:00-04:00"
related_articles = ["articles/in-review-suffragette.md","articles/dont-miss-id-please.md"]
related_companies = ["scene/companies/academy-of-ancient-music.md"]
short_description = "Some segments worked well, such as the famous freezing scene as a metaphor for the despair felt by the Remainers, or the ambiguity subverting the triumphalism of &quot;Saint George, the patron of our isle&quot;. But why the duet &quot;Two Daughters of Aged Stream are we&quot; should evoke a nightclub or the martial posturing of &quot;Come if you dare our trumpets sound&quot; should call to mind a train station will have to be explained to me."
slug = "aams-king-arthur-a-missed-brexit"
title = "AAM&#039;s King Arthur: a missed Brexit"
+++

Last year's Brexit vote continues to sharply divide the country, providing a rich bounty for artistic interpretation as a silver lining. The [Academy of Ancient Music](/scene/companies/academy-of-ancient-music/)'s production of *King Arthur* seems like an inspired choice in the current mood of mistrust and animosity. Henry Purcell's semi-opera was composed in the aftermath of the Glorious Revolution, an era of similar rupture and discord. The comparisons between post-Brexit and post-Glorious Revolution Britain are obvious, both 1691 and 2016 being marked by deep social and political divisions. Whether this allows the Stuart propaganda piece to successfully portray the complexity of last year's referendum is more questionable.

Having scrapped John Dryden's original text, director Daisy Evans retained Purcell's music to tell the story of Brexit Britain, with excerpts from poetry to focus on the theme of national identity. But this subversion of the work's original purpose ultimately failed to translate the nuances of fractured British society. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507211799245/2017-10-05---purcells-arthur-068.jpg.jpg)
<figcaption>The Academy of Ancient Music's *King Arthur*, Barbican Hall, October 3, 2017. Photo: Robert Workman.</figcaption>
</figure>

Split into a series of vignettes of contemporary British life, settings such as a street, a pub, a nightclub or a train station seemed clumsy and arbitrary when set to Purcell's music. Some segments worked well, such as the famous freezing scene as a metaphor for the despair felt by the Remainers, or the ambiguity subverting the triumphalism of "Saint George, the patron of our isle". But why the duet "Two Daughters of Aged Stream are we" should evoke a nightclub or the martial posturing of "Come if you dare our trumpets sound" should call to mind a train station will have to be explained to me. It was these mismatches which undermined the production as a whole.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507211826986/2017-10-05---purcells-arthur-043.jpg.jpg)
<figcaption>The Academy of Ancient Music's *King Arthur*, Barbican Hall, October 3, 2017. Photo: Robert Workman.</figcaption>
</figure>

Ray Fearon, RSC actor, as narrator was one of the production's major selling points, his face plastered on posters and programs. This was a strange choice as surely Purcell's music and the Academy of Ancient Music were the two main attractions for the audience. Fearon's oratorical prowess was diminished by the script he relied on throughout, giving his moments in the spotlight an amateurish, school-play feel. No matter how he confidently he projected, it was dismaying to see him scanning the sheet of paper for his next line. The selection of poetry contained both hits and misses, much like the rest of the production.

Shakespeare's St. Crispin's Day speech provided a moment of irony in its rousing patriotism while T.S. Eliot's *The Hollow Men* undermined the certainty of the air "Fairest Isle", ending the performance on a note of wary uncertainty. But for all its topicality Ali Smith's *All Across The Country* began the evening on a flat note, weighed down with such inane lines as "people called each other cunts" and "the media was insane".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507211836411/2017-10-05---purcells-arthur-033.jpg.jpg)
<figcaption>Ray Fearon, centre. The Academy of Ancient Music's *King Arthur*, Barbican Hall, October 3, 2017. Photo: Robert Workman.</figcaption>
</figure>

In contrast to the chaos of the staging the music was flawless. Expertly led by director and harpsichordist Richard Egarr the Academy of Ancient Music and the AAM Choir performed Purcell's score with spirited finesse, filling the Barbican Hall with infectious and stirring delight. The Brexit message might have missed the mark but at least there's always the beauty of Purcell to fall back on.
