+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-10-13T14:04:00-04:00"
lastmod = "2018-10-14T22:08:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539453362938/sq20181003-DSC04731.jpg.jpg"
primary_image_credit = "Anna Christie (Melanie Long) in Anna Christie, Encompass New Opera Theatre, 2018. Photo: Steven Pisano."
publishDate = "2018-10-13T15:53:00-04:00"
related_articles = ["articles/veggies-in-the-morning-and-melodies-throughout-the-day.md"]
short_description = "Director Nancy Rhodes describes it as &quot;crossover&quot; but it might be more appropriate to call it &quot;criss-cross over&quot;; the music never stops and the singers mostly sing, but sometimes halt to utter a comment, exclamation, or quick exchange of dialogue. The combination always feels just right, as the emotions and/or whimsy of the characters rise and fall."
slug = "a-world-premiere-anna-christie"
title = "A world premiere: Anna Christie"
+++

*Anna Christie*, presented by the Encompass New Opera Theatre does not, in fact, add anything to the world of what we know as opera. The world premiere of *Anna Christie* (an adaptation of Eugene O'Neill's famous play by the same name) is something special, though - a genre-defying combo of drama and music that doesn't fit into any established category (i.e., "a play with music"). Director Nancy Rhodes describes it as "crossover" but it might be more appropriate to call it "criss-cross over"; the music never stops and the singers mostly sing, but sometimes halt to utter a comment, exclamation, or quick exchange of dialogue. The combination always feels just right, as the emotions and/or whimsy of the characters rise and fall.

Making the evening more unusual is the fact that this *Anna Christie* is the creation of two nonagenarians, composer Edward Thomas (age 94) and the late librettist Joseph Masteroff (who passed away just before opening night at the age of 98). The run of the show is, in fact, dedicated to Mr. Masteroff, who was famous in the musical theatre world for writing the books for *Cabaret* and *She Loves Me*. Mr. Masteroff did a brilliant job of condensing the original five-act play and distilling its essence into two acts and two hours.

Mr. Thomas, who has composed everything from "Concerto for Clarinet and Orchestra" to album cuts for great voices like Julie Andrews, shows here that he knows and loves the theatre. He has written a handful of other pieces for the stage, including a musical about Mata Hari (with lyrics by Martin Charnin). *Anna Christie* is his third collaboration with Mr. Masteroff, including another adaptation of an O'Neill play (*Desire Under the Elms*).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539453653211/20181003-DSC04290.jpg.jpg)
<figcaption>Marthy Owen (Joy Hermalyn) and Chris Christopherson (Frank Basille); background is Larry the Bartender (Mike Piazza) in *Anna Christie*, Encompass New Opera Theatre, 2018. Photo: Steven Pisano.</figcaption>
</figure>

It's the wall-to-wall music of Mr. Thomas that is the star of the show. Poignant strains of harp, flute, and clarinet float over the haunting chords and motives, played by the strings and other members of the fourteen-piece ensemble (adroitly guest-conducted this night by Mark Shapiro filling in for conductor Julian Wachner, who leads all other performances). The effect is a combination of beauty and sadness, much like Anna Christie herself.

There are only a few brief duets and arias – the majority of the piece can only be described as recitative but Mr. Thomas proves that recitative can be melodious and that modern music doesn't have to create the distance of dissonance (two more genre-busting ideas). The emotional response it all creates is similar to what one feels from a great film score.

The movie version of *Anna Christie* is perhaps even more famous than the play. Starring Greta Garbo in her first post-silent film ("Garbo Talks!" screamed the posters), it contains one of film's most memorable lines: "Give me a whiskey. Ginger ale on the side. And don't be stingy, baby."  The play, film and this operatic version, all have the same plot. Set in 1919 at a New York City waterfront, it's the story of Anna (played here by soprano Melanie Long) who is described as "all in" – she's broke, homeless, exhausted and barely on the other side of  a life-threatening illness. With no one in her life and nowhere to go, she decides to visit Chris Christopherson (bass Frank Basile), the father she’s never met. She's hoping he'll let her stay so that she can "sit down and not move" for a while. He lives in an area teaming with sailors, however, and shipwrecked Mat Burke (baritone Jonathan Estabrooks) proves to be an inevitable source of passion and trouble that will give Anna no rest.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539453661027/20181003-DSC06881.jpg.jpg)
<figcaption>Chris Christopherson (Frank Basile), Anna Christie (Melanie Long) and Mat Burke (Jonathan Estabrooks) in *Anna Christie*, Encompass New Opera Theatre, 2018. Photo: Steven Pisano.</figcaption>
</figure>

Christopherson is filled with guilt and regret over his abandonment of Anna when she was a child, and blames not only himself but the pull of "that old devil sea." He looks back on his life and laments over the fact that he has never been able to stay on land long enough (or save enough money) to help raise his daughter. Having been a sailor all his life, he's not about to let a sailor into Anna's. Though Burke seems to be more sincere than most, Christopherson feels he must protect Anna, even to the point of murder.

There's no spoiler in telling you that Anna is a prostitute. We learn that right away from the comments of Marthy (in a brief but funny/endearing performance by Joy Hermalyn) and from Larry the Bartender (a non-singing role played by Mike Pirozzi, who looks and sounds exactly like the proprietor of "some dive.")  Like the plaintive flute in the score, the sad truth hangs over the whole affair and we know it will only be a matter of time until Anna will be forced to admit her whole story, not only to her father, but to the sailor she has come to love.

Mr. Basile as "Chris" possesses a deep, soulful Bass who – if you'll excuse the reference – serves as the anchor to the entire proceedings. A top-notch actor, Mr. Basile masterfully conveys the pain and regret of the old sailor, both inside and outside of the musical notes.

Echoing and complementing the ever-present wind instruments in the score, Ms. Long has a lovely, flute-like voice.  She is at first, flat – not in her singing, which is pitch-perfect – but in her detached, fatigued and emotionless portrayal of Anna. It's not clear what she's up to, but it all proves to be a great set-up for the big revelation scene in Act II, where we see the fire of agony which has been burning way down inside the cold furnace.

Mr. Thomas has given the title character the best musical moments. In the first act, Ms. Long expresses her fascination with the fog and sea in one of the evening's few stand-alone arias. And in the second act, Anna has two confrontational arias – one where she mocks Chris and his wish to own a "country house". "Houses in the country" are not what they seem to be, Anna begins, and she ends with a sarcastic description of what a wedding/marriage with Mat will be like. When Mat enters later, she finally confesses her love for him in the beautiful "I love you more than you know" but nevertheless must say goodbye – all just the groundwork for the riveting solo which follows, where she reveals the details of her past.

As Mat, Jonathan Estabrooks has vocal power, but is not quite there with some of the notes that tiptoe into the tenor range. Overall he's a bit overboard (pun intended), and has made the physical choice to be what one can only describe as "herky-jerky." Ultimately, though, he manages to be sympathetic, capturing the essence of the character, who is described as a man who is "just a kid."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539453668454/20181003-DSC05277.jpg.jpg)
<figcaption>Mat Burke (Jonathan Estabrooks) and Anna Christie (Melanie Long) in *Anna Christie*, Encompass New Opera Theatre, 2018. Photo: Steven Pisano.</figcaption>
</figure>

Director Rhodes is a veteran director who makes the most of the intimate stage and keeps the restless characters appropriately "on the move." There is an attempted rape in the first act that she has choreographed to harrowing effect.

Ms. Rhodes is also one of the co-founders of the Encompass New Opera Theatre, which has been presenting shows for over forty years. They present one fully-staged production with orchestra each season, and have concerts and staged readings throughout the year. 

*Anna Christie* runs through October 24th, at the Rose Nagelburg Theatre, inside the Baruch Performing Arts Center.
