+++
author = ["authors/thomas-pierce.md"]
categories = "Review"
date = "2017-09-19T20:38:00-04:00"
lastmod = "2017-09-20T21:34:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505956211348/2017-09-20---The-Mozartists-Ian-Page-and-Louise-Alder-curtain-call-c.-Fane-Henderson.jpg.jpg"
primary_image_credit = "The Mozartists, conductor Ian Page, and Louise Alder take a curtain call. Photo: Fane Henderson."
publishDate = "2017-09-20T21:34:00-04:00"
related_articles = ["articles/ian-page-mozart-imagination.md","articles/in-review-classical-operas-il-vologeso.md"]
related_companies = ["scene/companies/classical-opera.md"]
related_people = ["scene/people/louise-alder.md"]
short_description = "On the 18th of September a new musical group, The Mozartists, was launched at Wigmore Hall. The creation of Classical Opera conductor and Artistic Director Ian Page, it aims to cultivate the music of Mozart and his contemporaries, as suggested by the name. So with the blessing of the Soul of Music on the cupola above, The Mozartists gave a successful debut."
slug = "a-warm-introduction-the-mozartists-at-wigmore-hall"
title = "A warm introduction: The Mozartists at Wigmore Hall"
+++

On the 18th of September a new musical group, The Mozartists, was launched at Wigmore Hall. The creation of [Classical Opera](/scene/companies/classical-opera/) conductor and Artistic Director [Ian Page](/ian-page-mozart-imagination/), it aims to cultivate the music of Mozart and his contemporaries, as suggested by the name. So with the blessing of the *Soul of Music* on the cupola above, The Mozartists gave a successful debut. 

The first piece was Mozart's Sinfonia Concertante in E flat major (K. 364), the Allegro maestoso an elegant beginning to the evening and featuring the joyful lightness Mozart did so well. Passages of intensity burst upon us like the fluttering of a butterfly's wings, to be quickly succeeded by sections of calm. The violin soloists, Matthew Truscott and Alfonso Leal del Ojo, leapt off the orchestral sections with irresistible enthusiasm. But after such a jubilant start the Andante section failed to carry the energy. While it might be inevitable that a mournful section may drag following such an exultant Allegro, it's the orchestra's responsibility to engage the audience. The final Presto resumed the energy of the Allegro as could be expected by its name. Infectiously joyous, the rousing trumpet passages deserve special mention.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505956727125/2017-09-20---full---Louise-Alder-joins-The-Mozartists-and-Ian-Page-at-Wigmore-Hall-c.-Fane-Henderson.jpg.jpg)
<figcaption>Louise Alder joins The Mozartists and Ian Page at Wigmore Hall. Photo: Fane Henderson.</figcaption>
</figure>

We move on to Gluck’s *Il prologo*, written as an introduction to the 1767 performance of an opera by the obscure composer Traetta. Entitled "De’ sublimi augusti eroi", it starts with the recitative mandatory of all 18th century arias. Soprano Louise Alder carried off the triumphal theme well, her voice rippling out with confidence and appearing to be swept away with the piece herself. Alder possesses excellent technique, though at times her voice was tinged with a slight harshness. However she did seem to have some trouble with several of the high passages, her voice threatening to lose control. Alder seemed far more comfortable with the aria from Mozart's *Idomeneo*, "Padre, germani, addio", which she sang flawlessly and endowed with a suitably imploring quality. 

The evening concluded with a highly satisfying rendition of Mozart's Symphony in A Major (K. 201). The orchestra confidently burst into the Allegro moderato, playing well though there was a noticeably shrill quality to the string section. The Andante glided along, its sensuous theme shared amongst the instrumental groups. It was marred only by the clarinet jolting out of tune at the very end of the movement, unpleasantly stirring us who had been luxuriously immersed up until that point. The Menuetto had a surprising Baroque twist to it as if Mozart had been swept away with nostalgia, further reinforced by its ternary form. Nonetheless it was performed at a pleasing, galloping tempo. The final section, the Allegro con spirito, fulfilled expectations and was performed with a rushing, heady quality, bringing the concert to a fulfilling conclusion. 

For a first concert The Mozartists gave an admirable performance. Despite the occasional lapse both orchestra and soloists were in excellent form, and whether conductor Ian Page can lead to them to more sublime heights remains to be seen.
