+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-02-09T16:28:00-05:00"
lastmod = "2018-02-09T17:14:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546195551/media/2018/12/sq---Set_Poe_YoungRAdultM.jpg"
primary_image_credit = "Photo: © Matthew Septimus, Courtesy of The New School"
publishDate = "2018-02-09T17:14:00-05:00"
related_articles = ["articles/transparent-glass-the-composer-turns-80.md"]
short_description = "Mr. Hourie directed with a terse and foreboding air that dispelled any memories of the films. The sleek and minimal set, comprised of skeletal architectural elements and lace curtains facilitated the action. As scenographer Hourie filled picture frames suggesting decaying ancestral portraits with video of flames, ghosts and all manner of frightening imagery."
slug = "a-warhorse-for-operas-new-world"
title = "A Warhorse For Opera&#039;s New World?"

+++
Roderick is on the brink when he writes to his friend William, pleading with him to come for a visit. Roderick is an Usher and his life, along with that of his sister Madeline, is in mysterious and inexorable decline. William arrives at the decaying mansion exhausted from his journey and increasingly bewildered by the surroundings. It is with an eerie cadence that the Phillip Glass chamber opera, _The Fall of the House of Usher_, based on Edgar Allan Poe's classic tales, gets underway.

Richard Kessler, Dean of the Mannes School of Music and Executive Dean of the College of Performing Arts at the New School in New York City, which produced the work, considers _Usher_ "the sort of groundbreaking work that signals the direction in which the field of opera is headed." Thus this production of the seldom performed Glass work with a sharply honed libretto by Arthur Yorkins is as much a teaching tool to prepare students for opera's new world as it is a compelling, sophisticated and most welcome production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1546195967/media/2018/12/Young-RM.jpg)<figcaption>© Matthew Septimus, Courtesy of The New School.</figcaption> </figure>

_Usher_ follows the school's acclaimed 2017 production of Robert Ashley's _Dust_. Kessler and his associates are obviously champions of non-traditional operas, especially those that can be effectively produced in the confines of Stiefel Concert Hall a nicely equipped box that seats 50, give or take.

Those who know Poe's story only from its film versions - in which supernatural sensation overshadows its implications of incest, homosexuality and murder - will find that these rather more gripping elements amply compensate for the loss of the camp excesses of the films. What is Roderick's relationship with William and with Madeline? Is Madeline a demon and the house a malignant entity? Was Madeline buried alive? Poe suggests much, confirms little and even implies that the entire matter could be a hallucination.

Glass is not the first to fall for _Usher_. Debussy left his impressionistic version unfinished while Peter Hammill and Gordon Getty completed their straightforward compositions in the late eighties and early nineties (their works make a charming double bill). But Glass is ideally suited to deal with Poe's ambiguities amidst the doomed world inhabited by these somber yet tightly wound characters. His arpeggio style, pulsating syncopation and startling juxtapositions of tempo seem if not downright representational in _Usher_, then certainly completely at home. This could be the Philip Glass opera for people who don't like Philip Glass operas.

The much-admired conductor David Fulmer led the 12-member student orchestra that was attractively situated behind a lace curtain. Included were a guitarist, keyboardist, and contrabassist from the Mannes jazz program. With the Glass idiom at the fore, Fulmer's approach was firm yet fluid enough to elicit expressive playing, such as a plaintive flute solo that accompanied William's lament of the sunless atmosphere.

To maximize performance opportunities and resist vocal strain during five performances over three consecutive days, two baritones, two tenors and three sopranos shared the roles of William, Robert and Madeline. At the February 2 matinee, baritone Alex Greenzeig sang William, tenor Ganson Salmon, Roderick and soprano Maria Lacey, Madeline.

Unique to this production were the silent roles of young Roderick and Madeline dressed in white nightshirts and a somber Edgar Allan Poe. The young brother and sister played by Gabriel Torres and Payton Grgurovic provided ghostly context as they evoked happier if far from normal days. Mr. Poe, serving as a silent host and occasional scenery changer, was played with appropriate formality by Troy Hourie, the opera's director and digital scenographer.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518211629442/Madeline_William.jpg.jpg)
<figcaption>© Matthew Septimus, Courtesy of The New School.</figcaption>
</figure>

Alex Greenzeig possessed a lustrous tone, developing a sharp edge that grew steadily darker as William's bewilderment turned into fear. Throughout a tormented night and raging storm his acting was finely calibrated for the intimate setting.

Gaunt and instantly frightening as Roderick, the clarion tenor, Ganson Salmon moved like a wounded cat and maintained a fever-pitched ferocity as he faced his doom with agonizing grace and tenderness. Salmon's vocal commitment and physical agility contributed to an emotional core that revealed the human tragedy inherent in this tale.

Madeline is barely seen or heard in Poe's story. But the opera brings her, relatively speaking, to life. With only variations on the sound of "ah" to express herself, Maria Lacey uses this utterance to create an ethereal and unsettling character. Wailing and moaning, Miss Lacey vocalized her way between fearsome heights and rueful lows. She maintained a richly expressive and full-bodied voice throughout the opera.

Mr. Hourie directed with a terse and foreboding air that dispelled any memories of the films. The sleek and minimal set, comprised of skeletal architectural elements and lace curtains facilitated the action. As scenographer Hourie filled picture frames suggesting decaying ancestral portraits with video of flames, ghosts and all manner of frightening imagery. Particularly effective was the moment when Roderick and young Roderick thrashed about with a picture frame. The frame housed a video camera that captured their images within the frame itself. Mr. Hourie should note that even the most artfully executed digital images can be thwarted by sightlines and furniture when the audience is arranged in a U-shape.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1518211638666/Cast_Orchestra.jpg.jpg)
<figcaption>© Matthew Septimus, Courtesy of The New School.</figcaption>
</figure>

_Usher_ might have been better known outside bastions of contemporary opera had The Red Shoes director; Michael Powell lived to make the film that he had planned. Because of Powell's advanced age and to appease financers, Martin Scorsese agreed to serve as a backup director. However Powell died before a contract with Scorsese was formulated and the project never materialized. Glass would wind up scoring Scorsese's film _Kundun_, but that's another story.

So it has been up to regional companies like Chicago Opera Theatre and the Nashville Opera to keep _Usher_ alive. If Richard Kessler is correct when he says that "more and more composers are writing chamber operas and works conceived for intimate spaces" then _Usher_ could become a warhorse - the _Tosca_ or _Carmen_ of contemporary opera - that utilizes far-out elements like electronics, acoustic instruments and even amplification which here was employed ever so subtly and only for dramatic effect. If Kessler's vision holds true then graduates of the Mannes opera program will have an edge. Based on the quality of _Usher_ and of last year's _Dust_, opera's new world will be all the better for it.