+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2017-11-25T09:34:00-05:00"
lastmod = "2017-11-25T11:45:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511621528181/2017-11-24---square---3420_dermieter02_gross.jpg.jpg"
primary_image_credit = "Baritone Björn Bürger as Georg in Der Mieter, Oper Frankfurt, 2017. Photo: Barbara Aumüller."
publishDate = "2017-11-25T09:53:00-05:00"
related_articles = ["articles/xenophobia-fake-news-mental-health-peter-grimes.md","articles/tarrare-the-freak-i-just-want-to-be-full.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/bjorn-burger.md","scene/people/anja-petersen.md"]
short_description = "Every scene change had us on the edge of our seats, hearts pounding, craning our necks to catch a glimpse of what was next. And just when the tension couldn&#039;t possibly mount any higher, it kept rising for what seemed like another agonizing half-hour. It was completely draining and very, very good."
slug = "a-visceral-nightmarish-tourdeforce-der-mieter"
title = "A visceral, nightmarish tour-de-force: Der Mieter"
+++

"I'm not asking you to like me, I know that's impossible, because I'm not likeable, but at least do me the kindness of despising me enough to ignore me." - Roland Topor, *Le locataire chimérique*

If [Oper Frankfurt's recent production of *Peter Grimes*](/xenophobia-fake-news-mental-health-peter-grimes/) portrayed the external causes and symptoms of a man driven to suicide, [*Der Mieter* (*The Tenant*)](http://www.oper-frankfurt.de/en/season-calendar/der-mieter/) inflicts the experience on the audience head-on. This dark new work by Arnulf Hermann, with libretto by Handl Klaus based on Roland Topor's 1964 novel *Le locataire chimérique*, premiered at Oper Frankfurt this month with the full gamut of care and resources needed to really pull it off. If you suffer from anxiety or panic attacks, think twice about seeing it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511620100186/2017-11-24---3404_dermieter18_gross.jpg.jpg)
<figcaption>Baritone Björn Bürger as Georg in *Der Mieter*, Oper Frankfurt, 2017. Photo: Barbara Aumüller.</figcaption>
</figure>

*Der Mieter* is visceral like no other opera I have ever seen. A nightmarish score blended with ominous sound effects, video projections worthy of a stand-alone film, acrobatic rigging, a rotating platform, transforming set elements and blinding lighting amounted not to a tech overload, but to a subtle and gut-wrenching manipulation of the audience's mental state. Every scene change had us on the edge of our seats, hearts pounding, craning our necks to catch a glimpse of what was next. And just when the tension couldn't possibly mount any higher, it kept rising for what seemed like another agonizing half-hour. It was completely draining and very, very good.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511620151247/2017-11-24---3413_dermieter09_gross.jpg.jpg)
<figcaption>Anja Petersen (Johanna; standing upstage center) and the Philharmonia Chor Wien in *Der Mieter*, Oper Frankfurt, 2017. Photo: Barbara Aumüller.</figcaption>
</figure>

Baritone [Björn Bürger](/scene/people/bjorn-burger/) embodied Georg, the tenant in question, with frightening commitment. When the production said "jump", he said "how high" - the violent music, the close-up film elements, the vertiginous horizontal rigging that had his sweat visibly dripping onto the stage from four stories up. Along with [Anja Petersen](/scene/people/anja-petersen/) in the ghostly role of Johanna (the former tenant who died of suicide), the rest of the cast, and the Philharmonia Chor Wien, Bürger tackled the challenging score with confident aplomb. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511620201250/2017-11-24---3417_dermieter05_gross.jpg.jpg)
<figcaption>*Der Mieter*, Oper Frankfurt, 2017. Photo: Barbara Aumüller.</figcaption>
</figure>

*Der Mieter* featured so many storytelling elements in the costumes and sets that I am hard-pressed to convey it all. The chorus as quadruplicates of the three friends Georg has over, amplifying the noise he is imagining they are inflicting upon his neighbours. The chorus in wallpaper-print pyjamas taunting and drowning Georg as he feels the apartment walls closing in on him. The teetering, boxing ring-like, blindingly lit platform that starts as Georg's apartment and slowly becomes his nightmare space, shown to the audience from impossible angles. The mummified Johannas and the dresses and chairs that stretch to towering heights. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511620239638/2017-11-24---3411_dermieter11_gross.jpg.jpg)
<figcaption>On the platform L-R Björn Bürger (Georg), Michael Porter (Körner), Theo Lebow (Krell) and members of Oper Frankfurt; Philharmonia Chor Wien under the platform. *Der Mieter*, Oper Frankfurt, 2017. Photo: Barbara Aumüller.</figcaption>
</figure>

*Der Mieter* is a work for anyone who has ever felt like a nuisance, an inconvenience, and felt the need to disappear. Hermann and Klaus dedicate an entire act (if you can call the sections in this intermissionless, 1 hour and 50 minute work "acts") to the "Verwandlung", Georg's transformation from sane man to destroyed woman. Unlike the novel and film that inspired it, there is no ambiguity in this version about Georg's untimely end. Instead, it forms the core of the work, opera being the perfect medium to explore a loss of sanity. The score, wielded by Kazushi Ōno, is all about extremes. It ranges from impossibly distant to deafening, strident to hauntingly bassy. Even the role of Georg turns on a dime, using falsetto and lipsyncing as his voice is usurped by Johanna's piercing, haunting sighs echoed in unison by the winds.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511620296034/2017-11-24---3414_dermieter08_gross.jpg.jpg)
<figcaption>Baritone Björn Bürger as Georg in *Der Mieter*, Oper Frankfurt, 2017. Photo: Barbara Aumüller.</figcaption>
</figure>

[*Der Mieter*](http://www.oper-frankfurt.de/en/season-calendar/der-mieter/) dives into the difficult themes of anxiety and mental destruction in a way that is both informed and heart-stoppingly visceral. This new work is [on at Oper Frankfurt until December 7, 2017](http://www.oper-frankfurt.de/en/season-calendar/der-mieter/), with English as well as German surtitles. Not a holiday romp, see at your own risk.

