+++
author = ["authors/thomas-pierce.md"]
categories = "Review"
date = "2017-10-11T22:32:00-04:00"
lastmod = "2017-10-12T09:50:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507775775566/2017-10-11---Ian-Page-conducts-Classical-Opera-The-Mozartists-at-Barbican-c.-Benjamin-Ealovega.jpg.jpg"
primary_image_credit = "Ian Page conducts Classical Opera -The Mozartists at Barbican. Photo: Benjamin Ealovega."
publishDate = "2017-10-12T09:50:00-04:00"
related_articles = ["articles/ian-page-mozart-imagination.md","articles/talking-with-singers-anna-devin.md","articles/in-review-classical-operas-il-vologeso.md"]
related_companies = ["scene/companies/classical-opera.md"]
related_people = ["scene/people/anna-devin.md","scene/people/stuart-jackson.md","scene/people/ian-page.md"]
short_description = "As a birthday celebration Classical Opera couldn&#039;t have chosen a better program, one which extolled the magic and mystery of music. How else can you explain its ability to inspire and move us, to represent human emotion through pure sound? Ian Page and Classical Opera have shown us that music is a gift to the world. Or as Schiller put it when writing about joy, &quot;beauteous sparks of the gods&quot;."
slug = "a-very-happy-20th-birthday-for-classical-opera"
title = "A very happy 20th birthday for Classical Opera"
+++

Founded twenty years ago by conductor [Ian Page](/ian-page-mozart-imagination/), [Classical Opera](/scene/companies/classical-opera/) continues to flourish today. A sign of the group's good fortune, it has embarked on a number of audacious projects including a complete recording cycle of Mozart's operas. To celebrate these past two decades of success an evening of suitably optimistic music was held at the Barbican Hall. Like an offering to Apollo himself the program featured such transcendent works as Haydn's "The Representation of Chaos" from *Die Schöpfung*, Mozart's "Exsultate Jubilate" and Beethoven's Ninth Symphony. With so many achievements behind it already Classical Opera has obviously got on Apollo's good side. 

The concert aptly began with "The Representation of Chaos". As suggested by its title, the piece depicts the formless tumult before creation. Starting in C minor the orchestra created a world of shadowy disorder, the strings exuding its pulsing and surging energy while repeatedly convulsed by the eruption of the timpani. Into the chaos rose the archangel Raphael, sung by bass Henry Waddington, who with stern gravity intoned the first passages of Genesis. But with the creation of light, sung by the chorus and marked by an orchestral explosion of joy, the piece moved into C Major. Tenor Stuart Jackson as Uriel then radiantly guided us into the newly created universe. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507776072753/2017-10-11---Stuart-Jackson-credit-Benjamin-Ealovega.jpg.jpg)
<figcaption>Stuart Jackson, tenor. Photo: Benjamin Ealovega.</figcaption>
</figure>

With the world now in existence we came to Mozart's celebration of the divine mystery of music, Leidenschaft stillt und weckt Musik, from his reorchestration of Handel's *Ode to St. Cecilia*. It focusses on Jubal, the biblical father of musicians. The music he created with a shell was apparently so exquisite that his brothers believed a god must dwell within. But it was the soprano [Anna Devin](/scene/people/anna-devin/) who seemed blessed by the divine. Captivating us with her warm, velvety voice, her magnificent high notes astounded us yet more. 

She continued to entrance us with the first movement of Mozart's "Exsultate Jubilate", performing the florid passages with consummate skill and seeming to throw them off with ease. Typical of Mozart's daring, this sacred piece is far more operatic than ecclesiastical in style, allowing singers such as Devin to show off their vocal prowess. The tempo however was too fast, preventing us from luxuriating in the sublime opening passages. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507776093310/2017-10-11---Anna-Devin-credit-Benjamin-Ealovega.jpg.jpg)
<figcaption>Anna Devin, soprano. Photo: Benjamin Ealovega.</figcaption>
</figure>

"Accogli, oh re del mar" was a darker note in the evening's program. From Mozart's opera *Idomeneo*, it comes when the king is preparing to sacrifice his son, sung valiantly by tenor [Stuart Jackson](/scene/people/stuart-jackson/). But the scene was stolen by the chorus of priests, whose ominous monotone beseeching Neptune plunged into sinister despair at the end of each passage, envisaging the imminent atrocity. Though similarly occupied with mortality, Beethoven's Cantata on the Death of Emperor Joseph II is jubilant in contrast. Haydn was so impressed by the score that he invited the young composer to come to Vienna as his student.  Anna Devin sang again, replacing Miah Persson who was indisposed. With dignified expressiveness she embodied the words "then mankind ascended into the light", which were repeated by the chorus representing the whole of humanity. This is Enlightenment propaganda at its best, here lauding the reformer Emperor. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507776111288/2017-10-11---Choir-sing-Beethoven-9th-Symphony-at-Classical-Opera-20th-anniversary-c.-benjamin-ealovega.jpg.jpg)
<figcaption>The choir sings Beethoven's Ninth Symphony at Classical Opera's 20th anniversary concert. Photo: Benjamin Ealovega.</figcaption>
</figure>

Concluding the evening in the spirit of Enlightenment self-assurance was Beethoven's Ninth Symphony. Though based on Schiller's 1785 poem *An die Freude*, the writer later disliked the original so much that he rewrote it in 1803, this latter version being used by Beethoven. Beginning with the raw tension and colossal tone of the Allegro, the Scherzo was imbued with a feverish atmosphere, emphasised by the trumpet staccatos. In contrast the Adagio was smooth and meditative, soothing after the upheaval of the first two movements. This was spoilt though by the French horn, which burst weakly into one passage out of tune. The final movement however was a thrilling triumph, definitively one of the most affecting pieces of music ever written. Chorus, orchestra and solo singers all performed impeccably, the bass Henry Waddington in particular imbuing his section with a stirring solemnity which gave way to the movement's euphoric theme. 

As a birthday celebration Classical Opera couldn't have chosen a better program, one which extolled the magic and mystery of music. How else can you explain its ability to inspire and move us, to represent human emotion through pure sound? Ian Page and Classical Opera have shown us that music is a gift to the world. Or as Schiller put it when writing about joy, "beauteous sparks of the gods".
