+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-10-31T09:00:00-04:00"
lastmod = "2015-04-13T23:38:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428982585505/KellyKaduceButterfly.jpg.jpg"
primary_image_credit = "Kelly Kaduce in Madama Butterfly. Photo: Michael Cooper"
publishDate = "2014-10-31T09:00:00-04:00"
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/kelly-kaduce.md"]
short_description = "I worked on the COC&#039;s production of Madama Butterfly (the final show is tonight), and it was a chance for me to see a perfect example of artistic individuality. The twelve-show run at the Four Seasons Centre was shared by two almost entirely different leading casts, save for Elizabeth DeShong as Suzuki. "
slug = "a-tale-of-two-ciocio-sans"
title = "A Tale of Two Cio-Cio Sans"
+++

I worked on the COC's production of _Madama Butterfly _(the final show is [tonight](http://www.coc.ca/PerformancesAndTickets/1415Season/MadamaButterfly.aspx)), and it was a chance for me to see a perfect example of artistic individuality. The twelve-show run at the Four Seasons Centre was shared by two almost entirely different leading casts, save for Elizabeth DeShong as Suzuki. Opera fans know well that different singers bring variety to roles, especially those deeply explored roles like Cio-Cio San. So when I was able to, in the time and place, watch two groups of singers embody one group of characters, it was like a candy shop for my natural singer-curiosity.
The really interesting part about watching different artists perform a role is that the differences aren't always within the singer's control. Granting the usual process of making dramatic decisions based on the score, there are inevitably elements of a character that are extensions of the singer playing the role. For those of you who were lucky enough to see the title role sung by both Patricia Racette and Kelly Kaduce, it was glaringly clear that Cio-Cio San is no caricature. Patricia brought strength and benevolent stubbornness to Butterfly, and it broke our hearts to see her finally admit she had been wrong about Pinkerton. Kelly Kaduce, on the other hand, took advantage of her own youthful, almost carefree demeanour. That broke our hearts too, because the shock of the Act III action seems to hit the teenaged Cio-Cio San out of the blue. Two different tragedies are told using one libretto, and that's just irresistible to watch unfold in the rehearsal room.

It's not the first time that COC audiences have had the chance to hear a role sung by two different singers (_Rigoletto_, _Tristan und Isolde_, and most [COC Ensemble Studio performances](http://www.coc.ca/PerformancesAndTickets/1415Season/BarberOfSeville/EnsembleStudioPerformance.aspx), to give examples), but I think seeing two singers' takes on Cio-Cio San is a prime example of the individuality that exists in opera. As with a lot of Puccini roles, much of the character's mysteries are already solved; it's clear who/where/when they are, and their character's choices are, for the most part, explained explicitly. Perhaps you could argue that Puccini characters aren't as interesting as, say, Salome or Blanche, but I think roles like Tosca or Cio-Cio San help separate the men from the boys, so to speak.

Think about it: when the show is created in a real-time, real-life environment a good director knows that a "concept production"just isn't gonna fly. I remember a smart director ([Paul Curran](http://www.paulcurrandirector.com/) for the curious) saying to our _Tosca _team before beginning rehearsals something like, "The best way to do _Tosca _is, you know, to just _do Tosca_." This might seem like it makes everyone's work easier, but it's really the opposite. Singers can't rely on stylistic idioms or suspended disbelief to tell the story; they're faced with a libretto that gives a real-time scene (i.e. Acts II & III in _Butterfly_), and a score that extends the drama to its operatic scale. Basically, there's conversation music and thinking music, and that's harder to do in an opera that presents a story in a real environment; a Cio-Cio San is responsible for making a specific link between Puccini's music and any waiting time between characters' lines. When there's no concept to give you dramatic license between actual lines of text, you're left with finding out what's _true_ about a character, and that's trickier than you'd think.

Just as a director is left only with the tools of building character relationships in pieces like _Butterfly_, the singer is faced with creating, at the very least, an organic character. The fact that a role like Cio-Cio San, created in one of these "real" environments, is a testament to the work of Puccini and the libretto by Giacosa and Illica. Of course, we owe our experience to artists like Kaduce and Racette for finding something in common between Butterfly and themselves. On the long list of fascinating things I see at work, watching two pros embody one role will stay near the top, I'm sure.
