+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-01-02T21:32:00-05:00"
lastmod = "2016-01-08T17:05:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452098827008/2016-01-05---Theatre.jpg.jpg"
publishDate = "2016-01-06T12:19:00-05:00"
related_articles = ["articles/theres-still-no-opera-on-netflix.md","articles/the-future-of-opera-is-indie.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/tapestry-opera.md"]
related_people = ["scene/people/jay-hunter-morris.md","scene/people/stephanie-blythe.md","scene/people/deborah-voigt.md","scene/people/eric-owens.md","scene/people/richard-croft.md","scene/people/plcido-domingo.md","scene/people/anna-netrebko.md","scene/people/joseph-calleja.md","scene/people/bryn-terfel.md"]
short_description = "This isn&#039;t a post about how singers need to become better actors. The problem of dual-audience opera is almost a microcosm of an issue that&#039;s becoming more in the foreground of what&#039;s demanded of opera singers today. Many of these same singers - who have all the right stuff for the world&#039;s largest stages, yet lack the refined acting skills that are required of the camera - would be equally out of their comfort zones in much of the so-called &quot;indie opera&quot; happening in small venues."
slug = "a-tale-of-two-audiences"
title = "A tale of two audiences"
+++

Something about that nebulous week between Christmas and New Year's drew me to a marathon session of the full *Der Ring des Nibelungen*. So, I settled in to give a good viewing to Robert Lepage's *Ring Cycle* on the [Metropolitan Opera's On Demand](http://www.metopera.org/Season/On-Demand/) service. 

Wagner hasn't ever been my first stop for operatic bliss, but any time I see his operas, I have zero problem getting pulled right into the drama, which is at once action-packed and emotionally luxurious. The same happened with Lepage's *Ring Cycle*; I marvelled over tableaus like the saddened, floating Rheinmaidens at the top of *Das Rheingold*, or Fricka's entrance on her awesome throne, or the hot-as-hell Valkyries, riding their pseudo-horses and dismounting with a joyful slide down Carl Fillion's infamous "machine". 

James Levine conducts a stacked cast of singers, including established pros like [Bryn Terfel](/scene/people/bryn-terfel/), [Deborah Voigt](/scene/people/-deborah-voigt/), [Richard Croft](/scene/people/richard-croft/), and [Stephanie Blythe](/scene/people/stephanie-blythe/). As well, there were big-gun singers who have entered their Wagnerian prime in our current generation, like [Jonas Kaufmann](/scene/people/jonas-kaufmann/), [Eva-Maria Westbroek](/scene/people/eva-maria-westbroek/), [Eric Owens](/scene/people/eric-owens/), and [Jay Hunter Morris](/scene/people/jay-hunter-morris/). This kind of singing is exciting to hear, and there's something additionally thrilling about watching these artists pair huge vocal demands with Lepage's expansive, often perilous, visual concept.

Something that I've seen in many of the Met's HD broadcasts has been a vague-yet-tangible line in the singers' ability to act. There's a certain kind of ease that you can see when watching someone like [Plácido Domingo](/scene/people/placido-domingo/) or [Bryn Terfel](/scene/people/bryn-terfel/), an ease that comes from decades onstage, and it's a relatively rare thing to see. When the cameras zoom in, though, and these established singers share a scene with supporting characters, often played by younger or emerging artists, it's almost a visual capturing of the dramatic standards and priorities of young singers today, versus one generation past.

What I love about the Met's HD broadcasts in particular is how you can see the almost campy details in creating live theatre; the seam of a wig, the pounds of make-up, the falseness of the prop weapons. This stuff is interesting for its own sake, but seeing details like these in something designed specifically for film would be considered low-budget indeed. The same goes for the way the singers act onstage. For the listeners actually in the theatre, opera needs to be big, and the physical drama needs to become exaggerated in order to fit the scope of the music. Acting for the screen is another thing entirely; from my viewing experience so far, the young up-and-comers in the supporting roles steal the camera. It's no surprise, with the huge expansion of training available to young singers, including how to act and move.

Maybe that's besides the point, and maybe it's the tension between performing live and on camera that leads me to notice some not-so-great acting in these broadcasts. It's an interesting dilemma, since there are arguably more people watching from a screen than from the theatre.  Yet the broadcasts I've seen so far have definitely been staged and designed for a live audience. I've [written before](/theres-still-no-opera-on-netflix/) about the potential benefits of opera companies producing a portion of their annual repertoire as content specifically meant to be consumed in video format.

This isn't a post about how singers need to become better actors. The problem of dual-audience opera is almost a microcosm of an issue that's becoming more in the foreground of what's demanded of opera singers today. Many of these same singers - who have all the right stuff for the world's largest stages, yet lack the refined acting skills that are required of the camera - would be equally out of their comfort zones in much of the so-called "indie opera" happening in small venues. The difference in dramatic approach seems to hinge on the distance between performers and audience, and live opera is getting closer and closer to the ears and eyes of its listeners. 

When I go and hear opera in a bar or a courtyard or an old brick factory, I can't help but think of all the singers who wouldn't last a minute in these kinds of productions. It may seem like a ridiculous hypothetical, but I really couldn't see someone like [Anna Netrebko](/scene/people/anna-netrebko/) or [Joseph Calleja](/scene/people/joseph-calleja/) doing something like [R.B. Schlather's *Alcina*](http://www.musicaltoronto.org/2016/01/05/schmopera/) or [Tapestry Opera's *M'Dea Undone*](/in-review-mdea-undone/). Maybe that's not fair, and I'd love to be proven wrong. But ironically, it's this high tier of artists (or at least they're perceived to be so) who are fantastic in opera of a traditionally large scale, yet seem ill-equipped for telling stories up close.

For the people like me, who watch broadcasts precisely because they wanted to catch the real thing but couldn't get to New York, this kind of thing probably won't negatively impact our listening experience. These are spectacular singers we're talking about, of course, and the process of creating a production is as interesting as the opera itself. Yet for newcomers to the art form, perhaps getting introduced via broadcast performances, it may be hard to compare these live broadcasts with movie musicals, where it's slightly more film-first, show-second. 

There's a responsibility on these new audiences, I think, to recognize the differences between studio recordings and live singing, and "forgive" the on-camera eccentricities that happen as a result. Still, are these broadcasts truly meeting its big-screen audience halfway?
