+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2022-02-16T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1645020381/media/2022/02/sqSundayCarnegie_Thurman.jpg_udtfpl.jpg"
primary_image_credit = "Uma Thurman as the Narrator in André Previn and Tom Stoppard's \"Penelope\". Photo: Chris Lee."
related_articles = ["articles/renee-fleming-tso.md", "articles/renee-fleming-brings-a-new-luster-to-dumbarton-oaks.md"]
related_companies = []
related_people = ["scene/people/renee-fleming.md"]
short_description = "The composite was a perceptive and refreshingly theatrical portrait of a complex and insightful woman, a musically shimmering, angry and sometimes languid conclusion to an extraordinary Sunday afternoon at Carnegie Hall."
slug = "a-sunday-afternoon-at-carnegie-hall"
title = "A Sunday afternoon at Carnegie Hall"
youtube_url = ""

+++
On paper this concert looked like a gala event with a roster of artists too starry for a Sunday afternoon—even at Carnegie Hall. It was a heady group headlined by Renée Fleming and the Emerson String Quartet. Also included were the distinctive pianist Simone Dinnerstein and acclaimed actress Uma Thurman.

They were assembled not to make star turns, but to perform the New York premiere of the late Andre Previn's final composition, the monodrama _Penelope_. The libretto is by none other than Tom Stoppard, drawn from the story of Odysseus and Penelope in Homer’s _Odyssey_. But Homer's patient Queen of Ithaca would have to wait until after intermission. First there was a dream of a program that subtly evoked themes associated with Penelope’s dilemma. However celebrated the artists, the afternoon succeeded with an abiding philosophical spirit and stunning modesty.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1645020456/media/2022/02/SundayCarnegie_tutti_mjmsfi.jpg){{% /md %}}

<figcaption>Renée Fleming with member of the Emerson String Quartet, pianist Simone Dinnerstein (far left) and actress Uma Thurman (far right) taking a bow. Photo: Chris Lee.</figcaption>  
</figure>

The Emerson, whose valued presence was heightened by news of their imminent retirement, opened with Samuel Barber's String Quartet in B minor. The quartet dedicated their performance to Roger Tapping, the esteemed violist of the Juilliard String Quartet who recently died. They played with a sense of almost preternatural communication and flawlessly modulated emotional weight. The work's achingly sad _Molto adagio_, perhaps more familiar to listeners in Barber's arrangement for string orchestra, was heard in its unalloyed and most powerful form suggesting that beauty and grief coexist in a turbulent world.

> Thurman, a life force on the screen, is equally compelling on the concert stage.

The concept lingered as those efficient Carnegie Hall stagehands swiftly replaced the trappings of the Emerson with a Steinway that was resplendently positioned centerstage. Dinnerstein entered and played Philip Glass' _Mad Rush_. This rhapsodically abstract piece about the relativity and overlapping of time is filled with oscillating arpeggios and dramatic surges. Dinnerstein's sensuous interpretation replete with intriguingly placed pauses evoked Glass' notion that _Mad Rush_ might be of "infinite length." Few would have minded had it carried on but time is not relative on the concert stage and Dinnerstein had more to do.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1645020540/media/2022/02/Francesco_Primaticcio_fk6krf.jpg){{% /md %}}

<figcaption>Francesco Primaticcio's painting "Ulysses and Penelope". Photo: public domain.</figcaption>  
</figure>

The piano was repositioned and Fleming was welcomed with tumultuous applause. Dinnerstein followed who would accompany the soprano in a set of five songs; two each by Edward Grieg and Gabriel Fauré and a contemporary work by [Kevin Puts](/kevin-puts-i-know-who-i-am-as-a-composer/).

Fleming is a singer with a purpose. Her choices suit the purpose as well as what works best for her voice, one of the many reasons she is acknowledged as an activist as well as a treasured soprano. Her recital on Sunday afternoon was no exception, an exquisitely sung reminder of these challenging times and the threatened environment.

Commenting that nature had been key to her management of the pandemic's darkest days she decided to explore how composers had been inspired by nature and utilized it in song. Grieg's _Lauf des Welt_, an ambivilant love song, was not an obvious recital choice for Fleming but was handled with refinement. His sadly romantic _Zur Rosenzeit_ was better suited to the creamy flow of her voice as was Fauré's _Les Berceaux_, a soft but pointed admonishment of family men lured away by adventure at sea.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1645020582/media/2022/02/Renee_Fleming_AndrewEccles_ttbfbt.jpg){{% /md %}}

<figcaption>Renée Fleming, photographed by Andrew Eccles/Decca.</figcaption>  
</figure>

_Au bord de l'eau_, Fauré's paean to lovers swept away by nature from reality was in stark contrast to Puts's _Evening_ set to a gritty yet lovely poem by the masterful Dorianne Laux. Fleming captivated with a vocal agility that captured the irony in the beauty of nature along with its fragility.

The first half of the program felt like an overture from the gods and our wait for Penelope, who in turn would await the return of Odysseus from the Trojan War, was over. Previn writes beautifully for the voice and created the work especially for Fleming. Stoppard referred to it as "an opera of sorts" and the libretto has a distinct mercurial tone. This may have prompted Previn to depart from the conventions of monodrama and cast another person as the narrator rather than obligate Fleming to the entire text.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1645020622/media/2022/02/SDinnerstein_Lisa-MarieMazzucco_ii8vq1.jpg){{% /md %}}

<figcaption>Pianist Simone Dinnerstein, photographed by Lisa-Marie Mazzucco.</figcaption>  
</figure>

Thurman, a life force on the screen, is equally compelling on the concert stage. Her approach to the narrator was one of demure audacity laced with effective comic and  dramatic timing. One may assume that Thurman's narrator gives voice to Penelope's subconscious leaving Fleming to sing the person but that would be inaccurate. In fact Stoppard creates sequences when the narrator finishes Penelope's sentences without dropping a beat. Beyond a doubt the singer and narrator are one person.

Still there was an apparent but fortunately not constant pairing off in a kind of dialog between Thurman and Dinnerstein just as Fleming and the Emerson were immersed in the stirring music that structures the work. The composite was a perceptive and refreshingly theatrical portrait of a complex and insightful woman, a musically shimmering, angry and sometimes languid conclusion to an extraordinary Sunday afternoon at Carnegie Hall.