+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-08-12T20:49:00-04:00"
lastmod = "2018-08-14T16:44:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1534121631629/Langree-13768_creditMattDine_LincolnCenterforthePerformingArts.jpg.jpg"
primary_image_credit = "Louis Langrée, conductor. Photo: Matt Dine/Lincoln Center for the Performing Arts."
publishDate = "2018-08-12T21:13:00-04:00"
short_description = "After such a substantial appetizer there was a reasonable interval before the\nentrée. It is at this point appropriate to mention the reconfiguration that Mostly Mozart brings to David Geffen Hall. The stage extends beyond the proscenium into the auditorium. Seating is placed at either side of the extended portions of the stage and, when a chorus isn&#039;t performing, behind it."
slug = "a-summer-mozart-menu"
title = "A summer Mozart menu"
+++

Mozart's *Meistermusik* was the *amuse bouche* of this summer concert nearing
the end of Lincoln Center's 2018 edition of its annual [Mostly Mozart Festival](http://www.lincolncenter.org/mostly-mozart-festival). The work was a luscious if solemn taste of what was to come, when, in the latter half of the concert, conductor Louis Langrée, his Mostly Mozart Festival Orchestra and the Concert Chorale of New York directed by James Bagwell, served up the entrée, Mozart's *Requiem*.

*Meistermusik*, running only six minutes, created a dignified and ceremonial atmosphere. Written in 1785 when Mozart was active as a Mason, it served as music to accompany the installation of new Masons. Here it was handsomely played and sung by the orchestra and the male contingent of the Concert Chorale. Later the piece became Masonic Funeral Music when Mozart expanded it and eliminated the male chorus. It was especially pleasing then to hear the work in its original form in this context.

What followed was an appetizer of most generous and refreshing nature, Mozart's Piano Concerto No. 21 in C major. For better or worse the work is known as the "Elvira Madigan" concerto because its Andante movement was so rapturously utilized in the tragic [1967 Swedish film](https://en.wikipedia.org/wiki/Elvira_Madigan_(1967_film)) with that name. Happily, in the hands of pianist Stephen Hough, the movement retained its quiet dignity and we were reminded that this piano concerto and Mozart's others were designed to show off the diverse talents of their composer at the keyboard.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1534121454091/StephenHough-4creditSimCanetty-Clarke.jpg.jpg)
<figcaption>Stephen Hough, pianist. Photo: Sin Canetti Clark.</figcaption>
</figure>

However the first movement, Allegro maestoso, left the strongest impression with Mozart perhaps wanting to demonstrate his controlled energy. Hough and the orchestra played with such delicate verve that the word lilting seemed to have been created specifically for the moment. Exchanges between pianist and orchestra of that exquisitely simple theme were sweetly balanced.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1534121462430/JamesBagwell.jpg.jpg)
<figcaption>James Bagwell, Choral Director, Concert Chorale of New York. Photo: Eric Baiano.</figcaption>
</figure>

Then came the stillness and amorous dignity of the "Elvira Madigan" movement. But it was the notion of Mozart showing a different aspect of his restraint with another beautiful theme that lingered. In the final movement, Allegro vivace assai, Mozart and Hough covered the keyboard with virtuosic charm. Hough and the orchestra smoothly executed the contrasting tempos and increasingly assertive nature of the movement.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1534266470136/4-Concert_Chorale_of_NY-MM2012-9911_copyright-Richard-Termine.jpg.jpg)
<figcaption>Concert Chorale of New York. Photo: Richard Termine.</figcaption>
</figure>

After such a substantial appetizer there was a reasonable interval before the entrée. It is at this point appropriate to mention the reconfiguration that Mostly Mozart brings to David Geffen Hall. The stage extends beyond the proscenium into the auditorium. Seating is placed at either side of the extended portions of the stage and, when a chorus isn't performing, behind it. Above the extended stage is a grid supporting what are presumably acoustical disks and a circle of cylindrical chandeliers. As a result the hall becomes intimate, no smaller in size but warmer and more welcoming in attitude.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1534121489397/MM1.jpg.jpg)
<figcaption>Louis Langrée, conductor, and the Mostly Mozart Festival Orchestra. Photo: Richard Termine.</figcaption>
</figure>

Mindful of the appetizer we had just consumed, Langree provided a brisk and trim *Requiem*. Approaches to this masterwork can differ significantly. To put it in perspective, Sir George Solti's rendition, recorded live in 1991 at St. Stephen's Cathedral in Vienna on the 200th anniversary of Mozart’s death, comes with prayers for Mozart's soul and a tolling bell. Solti leads the Vienna Philharmonic and State Opera Chorus with esteemed soloists Arleen Auger, Cecilia Bartoli, Vinson Cole and René Pape. It is dark, large in scale and deeply religious.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1534266377779/MMFO_Langree-14438_creditRichardTermine.jpg.jpg)
<figcaption>Louis Langrée, conductor, and the Mostly Mozart Festival Orchestra. Photo: Richard Termine.</figcaption>
</figure>

Conversely Langrée led a team of first-rate young singers, Jodie Devos, soprano, Jennifer Johnson Cano, mezzo-soprano, Andrew Stenson, tenor, and Ryan Speedo Green, bass-baritone, all wholly committed to their roles. While Langrée's team didn't have the gravitas or the grandeur of Solti's, what they possessed was a keen sense of the work’s emotional and musical core and the agility to finely articulate his pacing. Next season audiences will have the opportunity to hear yet another interpretation of the *Requiem* when the Orchestra of St. Luke's under Bernard Labadie performs the work at Carnegie Hall in a revised and completed version by Robert Levin.


