+++
author = ["authors/erik-flaten.md"]
categories = "Review"
date = "2017-09-15T13:12:00-04:00"
lastmod = "2017-09-15T16:35:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505496058511/2017-09-15---Square---cree-22.jpg.jpg"
primary_image_credit = "Elizabeth Cree (mezzo-soprano Daniela Mack) makes her confession. Photo: Steven Pisano for Opera Philadelphia."
publishDate = "2017-09-15T14:15:00-04:00"
related_articles = ["articles/elizabeth-cree-kevin-puts.md","articles/kevin-puts-i-know-who-i-am-as-a-composer.md","articles/talking-with-singers-daniela-mack.md","articles/conversations-we-shall-not-be-moved.md","articles/brenda-rae-earns-her-ovation-in-o18-lucia.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/daniela-mack.md","scene/people/kevin-puts.md","scene/people/thomas-shivone.md","scene/people/joseph-gaines.md","scene/people/deanna-breiwick.md","scene/people/matt-boehler.md","scene/people/melissa-parks.md","scene/people/jason-ferrante.md","scene/people/troy-cook.md","scene/people/johnathan-mccullough.md"]
short_description = "The production is bursting at the seams with variations in style, mood and display. Its musical ideas seamlessly transition from comical to frightening. The score includes some familiarity in terms of the musical vocabulary it employs. We hear moments evoking a Broadway musical, moments that are reminiscent of Bernard Herrmann&#039;s sounds of horror, and moments of gorgeously sweeping romantic lines."
slug = "a-stunning-premiere-elizabeth-cree"
title = "A stunning premiere: Elizabeth Cree"
+++

Opera Philadelphia's opening night gala was in full swing, as exhausted staff members and excited patrons gathered at the Kimmel Center's Perelman Theater to welcome the highly anticipated 2017-18 season, as well as the inaugural festival, O17. What better way to kick off such a fantastic marathon of opera than with a world premiere? Composer [Kevin Puts](/kevin-puts-i-know-who-i-am-as-a-composer/) and librettist Mark Campbell's [*Elizabeth Cree*](https://www.operaphila.org/whats-on/on-stage-2017-2018/elizabeth-cree/) has been the subject of much conversation. Expectations have undoubtedly been high, not only for the composer and librettist, but also for Opera Philadelphia, a company which has set the national standard for producing new opera. Opera Philadelphia's marketing team proudly boasts that Puts and Campbell are Philadelphia favorites, as they won audiences over with their Pulitzer Prize-winning *Silent Night* in 2012.

Considering the fact that last year's premiere of Missy Mizzoli's [*Breaking the Waves*](/its-official-breaking-the-waves-wins-best-new-opera/) brought one of the most monumental operatic works of the 21st century to Opera Philadelphia's stage, it was hard to know what to expect of this year's premiere, other than another ground breaking masterpiece. Reviews and sneak-peaks for *Elizabeth Cree* featuring mezzo-soprano [Daniela Mack](/talking-with-singers-daniela-mack/) have all promised that audiences would be stunned. To put it simply: they weren't exaggerating.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495828413/2017-09-15---cree-12.jpg.jpg)
<figcaption>John Cree (baritone Troy Cook) describes the grisly murder of the Gerrard family in his diary. *Elizabeth Cree*, Opera Philadelphia, 2017. Photo: Steven Pisano for Opera Philadelphia.</figcaption>
</figure>

Opera Philadelphia's production of *Elizabeth Cree* is brilliantly colorful, accessible to all ears (both musically trained and untrained,) and entirely enjoyable. (Note that some content is not appropriate for children.) 

The opera is based on the mystery novel *The Trial of Elizabeth Cree* by Peter Ackroyd. We are invited into the world of 1880's London with a dynamic combination of costume, set, and lighting effects. The music invokes the feel of the era, while also keeping the audience on its toes with its original and modern sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495836752/2017-09-15---cree-02.jpg.jpg)
<figcaption>Little Victor Farrell (tenor Jason Ferrante), Doris the Wire Walker (mezzo-soprano Melissa Parks), Aveline Mortimer the Wide-Eyed Warbler (soprano Deanna Breiwick), and Uncle (bass Matt Boehler) entertain the crowd with a variety show. *Elizabeth Cree*, Opera Philadelphia, 2017. Photo: Steven Pisano for Opera Philadelphia.</figcaption>
</figure>

Early in the opera, a charming troupe of characters who perform in a London music hall proclaim, "What gives life its spice? Variety! Variety! Variety!" And indeed, variety is the very thing that captivates and engages our eyes and ears straight through all of the twenty nine scenes to the end of the opera, which runs ninety minutes with no intermission.*

The production is bursting at the seams with variations in style, mood and display. Its musical ideas seamlessly transition from comical to frightening. The score includes some familiarity in terms of the musical vocabulary it employs. We hear moments evoking a Broadway musical, moments that are reminiscent of Bernard Herrmann's sounds of horror, and moments of gorgeously sweeping romantic lines. The unique combination of these musical elements makes a sound that is uniquely and unforgettably Kevin Puts'.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495848387/2017-09-15---cree-20.jpg.jpg)
<figcaption>Elizabeth Cree (mezzo-soprano Daniela Mack) returns borrowed books to the Reading Room. *Elizabeth Cree*, Opera Philadelphia, 2017. Photo: Steven Pisano for Opera Philadelphia.</figcaption>
</figure>

David Schweizer's staging pairs perfectly with the quick shifts in scenes. The action on stage always reflects the mood of the text and music, and the use of projections is definitely not overdone. Alexander Nichols' designs make for several particularly stunning scenes.

This production owes much of its success to the stellar cast and musical leadership. Mezzo-soprano Daniela Mack's performance is worth every moment of hype that preceded opening night. Not only does Mack have a voice with a beautifully even, resonant, and rich sound, thrilling high notes, and flexibility, she is also terrific actress. She never breaks her formidable connection with the audience, as her character drastically changes from scene to scene. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495860502/2017-09-15---cree-11.jpg.jpg)
<figcaption>Dan Leno (tenor Joseph Gaines) and Elizabeth (mezzosoprano Daniela Mack) put on a new act as the Butcher and his wife. *Elizabeth Cree*, Opera Philadelphia, 2017. Photo: Steven Pisano for Opera Philadelphia.</figcaption>
</figure>

[Joseph Gaines](/scene/people/joseph-gaines/), [Deanna Breiwick](/scene/people/deanna-breiwick/), [Matt Boehler](/scene/people/matt-boehler/), [Melissa Parks](/scene/people/melissa-parks/), and [Jason Ferrante](/scene/people/jason-ferrante/) make a wonderfully entertaining group of comedians. Their roles are executed with a combination of effective physical comedy and very fine singing. Joseph Gaines is especially entertaining, and the role of Dan Leno is a perfect fit. Deanna Breiwick proves through flawless and impressive vocal lines that she is not only an outstanding actress, but also a musician of the highest caliber. [Troy Cook](/scene/people/troy-cook/) makes an excellent John Cree, with his powerful voice full of expressive and sinister lyricism. The seemingly instant transformations of several of the small roles played by the same actors is impressive. Baritone [Johnathan McCullough](/scene/people/johnathan-mccullough/) and bass-baritone [Thomas Shivone](/scene/people/thomas-shivone/) handle the rapid changes with ease, and they also sing with tremendous clarity and radiant sound. McCullough's physical changes for each character are one of the most entertaining aspects of the night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495880316/2017-09-15---cree-19.jpg.jpg)
<figcaption>The inhabitants of the Reading Room continue their studies. *Elizabeth Cree*, Opera Philadelphia, 2017. Photo: Steven Pisano for Opera Philadelphia.</figcaption>
</figure>

The chamber orchestra lead by Maestro Corrado Rovaris is alive with rich tones and beautiful playing. The orchestra's lush triumph is a result of the delightfully thoughtful orchestrations by Puts, as well as the players' own expressive musicianship. Beautiful moments of piano writing sweep in and out of the score. A constant change in textures keeps the music vivid and interesting, even though the tempo hardly changes at all throughout the work. The instrumentalists are able to provide delicate and tender embellishments, warm blankets of supportive sound, as well as bone chilling, haunting effects. The acoustics of the Perelman are in favor of *Cree*, as the blend and balance were always superb. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495890858/2017-09-15---cree-23.jpg.jpg)
<figcaption>Dan Leno (tenor Joseph Gaines) goes for the laugh at "The Crees of Misery Junction." *Elizabeth Cree*, Opera Philadelphia, 2017. Photo: Steven Pisano for Opera Philadelphia.</figcaption>
</figure>

Previously coined as the underdog, Opera Philadelphia is now soaring far beyond all expectations, and has emerged as one of the leading opera companies in the country. The company's success is largely due to its commitment to pioneering new works and presenting new and exciting productions. Opera is not a stale or stuffy museum in Philadelphia. The truth is that the success of *Elizabeth Cree* was the least surprising moment of the night. In a previous [interview with Schmopera](/elizabeth-cree-kevin-puts/), Kevin Puts said that his hope for audiences was that "they will want to see it again." Congratulations Kevin, I'll be back Tuesday night. 

*This review will not include plot points, as a major feature of the opera is the shocking twists, cuts, rips, and stabs of the drama. 

>Elizabeth Cree runs until September 23. For full details and tickets, [click here.](https://www.operaphila.org/whats-on/on-stage-2017-2018/elizabeth-cree/)
