+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2017-10-09T10:20:00-04:00"
lastmod = "2017-10-09T13:36:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559204651/2017-10-09---square---pf_1385pr.jpg.jpg"
primary_image_credit = "Nino Machaidze (Leïla) with Nicholas Brownlee (Nourabad) in LA Opera's 2017 production of The Pearl Fishers. Photo: Ken Howard."
publishDate = "2017-10-09T10:51:00-04:00"
related_articles = ["articles/in-review-the-pearl-fishers-at-eno.md","articles/talking-with-singers-nino-machaidze.md","articles/the-lady-steals-the-spotlight-in-rohs-macbeth.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/javier-camarena.md","scene/people/nino-machaidze.md","scene/people/alfredo-daza.md"]
short_description = "Dark fabric billows beneath the set, and one is never allowed to forget that the sea is the underpinning of everything that’s happening. When the inevitable storm comes, the fabric is no longer lovely and tranquil but frightening as it inflates to ever bigger and bigger &quot;waves.&quot; Another constant device: during much of the drama in Act I, a lone fisherman bobs up and down in his boat beneath the pillars that hold up the village."
slug = "a-string-of-pearls-from-bizet-and-la-opera"
title = "A string of Pearls from Bizet and LA Opera"
+++

For most of [LA Opera](/scene/companies/los-angeles-opera/)'s production of Bizet's *The Pearl Fishers* (*Les pêcheurs de perles*), the audience comes to understand why opera has been called "the greatest of all art forms." In a great opera production like this one, the visual and the aural come together and affect the visceral in a way that can't be experienced anywhere else. From the moment we hear maestro Plácido Domingo's downbeat, we know we're in for such an experience. As we listen to the beautiful overture, dancers dressed as pearl divers fly in, "swimming" down to the stage from somewhere high above and beyond the proscenium arch. We view them through a scrim with a projection of moving water, so the effect is that we're under the ocean looking through an enormous window. Throughout the overture, the swimmers dive down then soar upward. They don't find anything, but in this production there are "pearls" for us to find everywhere.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559477116/2017-10-09---pf_0816pr.jpg.jpg)
<figcaption>A scene from LA Opera's 2017 production of *The Pearl Fishers*. Photo: Ken Howard.</figcaption>
</figure>
 
As for Domingo as conductor, one can't help stealing glances at him. Every movement shows he clearly loves every note of the music. But you don't have to see him to know that. (He also conducts on 10/22.)
 
*The Pearl Fishers*, though a longtime staple of the worldwide operatic repertory, is having its first production at LA Opera. Artistic Director Plácido Domingo made the praiseworthy choice to begin the new season of his company with back-to-back Bizet, which serve as bookends to the composer's operatic career. The masterpiece known as *Carmen* (reviewed [here 9/16/17](/la-opera-scores-in-first-half-of-bizet-double-header/)), was composed at the end of Bizet's short life, when he was at his artistic zenith. *The Pearl Fishers* was written ten years earlier, but there is no debate as to why it's revived so often. This is not the work of an immature or half-baked composer - Bizet was only 24, but he had already written his famous symphony at 17, and his work was adored by some of the greatest French composers of his day: Gounod, Berlioz and Halévy - talk about endorsements. Bizet died far too young, so we aren't left with a plentiful canon to enjoy. But "Bizet's other opera" is a work filled with stunning orchestral passages, arias, duets, and of course, powerful chorus numbers. (This reviewer can't say enough about the splendor that the LA Opera chorus exhibits in every production.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559488700/2017-10-09---pf_0301pr.jpg.jpg)
<figcaption>Alfredo Daza (Zurga) and Nino Machaidze (Leïla) in LA Opera's 2017 production of *The Pearl Fishers*. Photo: Ken Howard.</figcaption>
</figure>
 
The libretto is simple and recognizable - a love triangle set in an exotic locale (in this case, Ceylon or rather Sri Lanka, since director Penny Woolcock has imposed some modernity onto the plot - more on that later. ) The story takes place in a fishing village, where the poor villagers live literally on the edge; their little shacks on stilts, covered in corrugated metal, teeter at the edge of the ocean. (A magnificent set by Dick Bird with painterly lighting from Jen Schriever - both artists making their LA Opera debut.) The villagers have no choice about where they must be; the water is the source of their livelihood. And since the water is also unpredictable and a potential destroyer, their world is filled with fear and superstition. (In the wake of so many recent hurricanes we have a profound contemporary understanding of their concerns.)
 
Leïla, the heroine (played by world-class soprano [Nino Machaidze](/talking-with-singers-nino-machaidze/)) is in love with Nadir (tenor [Javier Camarena](/scene/people/javier-camarena/), making his LA Opera debut) while Zurga (baritone [Alfredo Daza](/scene/people/alfredo-daza/)) is in love with her. Completing the triangle is the love/friendship between the two men. But Leïla has a big problem - as a priestess in her religion she's supposed to remain a virgin, lest the wrath of the god Brahma should rain down - as in lots of rain. If she can keep her vow of celibacy, so the watery wisdom goes, then the village will be blessed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559574654/2017-10-09---pf_0390pr.jpg.jpg)<figcaption>Nino Machaidze (Leïla) in LA Opera's 2017 production of *The Pearl Fishers*. Photo: Ken Howard.</figcaption>
</figure>
 
It's Daza who really owns the evening - we see an actor who is plumbing the depths of the character's frustration and despair and, oh yes, it just happens to manifest itself as glorious singing. Camarena, on the other hand, is a little tenuous in his solos, but he vindicates himself in the love duets with Machaidze and in the famous bromance duet with Daza. Rounding out the small cast of principals is Nicholas Brownlee, an alum of the Domingo-Colburn-Stein Young Artist Program. He is clearly making his way in the opera world, delivering here an effectively ominous portrayal of Nourabad.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559517159/2017-10-09---pf_1029pr.jpg.jpg)
<figcaption>Javier Camarena (Nadir) in LA Opera's 2017 production of *The Pearl Fishers*. Photo: Ken Howard.</figcaption>
</figure>
 
Director Woolcock does some wonderful staging with the villagers. Take a look at any one of them during the brilliant opening number and you will see real people who all have their own stories to tell. Some are sewing fishing nets, some reading newspapers, some doing their washing, almost everyone conversing or even debating with their neighbors. (A chorus that is alive and breathing is essential in an opera, something that was lacking in the recent LA Opera production of *Carmen.)* And with designers Bird, Schriever and projections from 59 Productions, Woolcock creates visuals that aren’t just clever tricks but emotional pathways into the story. Dark fabric billows beneath the set, and one is never allowed to forget that the sea is the underpinning of everything that’s happening. When the inevitable storm comes, the fabric is no longer lovely and tranquil but frightening as it inflates to ever bigger and bigger "waves." Another constant device: during much of the drama in Act I, a lone fisherman bobs up and down in his boat beneath the pillars that hold up the village. Don't miss the moment at the very end of the act as he dives into "the water" disappearing into the stage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559558438/2017-10-09---pf_0637pr.jpg.jpg)
<figcaption>Alfredo Daza (Zurga) and Nino Machaidze (Leïla) in LA Opera's 2017 production of *The Pearl Fishers*. Photo: Ken Howard.</figcaption>
</figure>
 
There's something else going on in Woolcock's nearly perfect vision that I'd rather ignore but I've saved this quibble for last. In the very beginning we notice the newspapers and we notice that there are electric bulbs hanging around the village. The bulbs are a lovely part of the overall lighting design but are a clear statement that we aren't in ancient Ceylon (where the opera is supposed to take place) but rather, in modern day Sri Lanka. The villagers are dressed in traditional garb that was probably the same as what was worn by their ancestors - yet Zurga and his minions enter in modern dress, his lieutenants in men's suits. Zurga himself has a blue vest he might have gotten at a sporting goods store. Nadir appears in flip-flops and a combination of modern dress (upper body) and harem pants below. 

And it isn't until Act III that we come to understand that Woolcock is grafting a socio-political and environmental message onto the proceedings. After a thrilling storm and tidal wave, we are subjected to a very long set change, during which we see projections on the curtain. We see destroyed buildings and heaps of debris that could be Puerto Rico or any other modern scene of recent devastation. And when the curtain rises? We see a modern office space with file cabinets, a swivel chair and dockets of documents that rise floor to ceiling. There's even a TV set. This is supposed to be Zurga's seat of power and Woolcock seems to be making a statement about society's powerlessness, and how the powerful are sometimes just inflated bureaucrats. The feeling, however, is that now we're in a different opera. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507559824391/2017-10-09---pf_1902pr.jpg.jpg)
<figcaption>Nino Machaidze (Leïla), Javier Camarena (Nadir) and Alfredo Daza (Zurga) in LA Opera's 2017 production of *The Pearl Fishers*. Photo: Ken Howard.</figcaption>
</figure>

The hints at modernity in Act I gave no indication that in Act III Woodcock was going to completely explode what she had created, taking us out of the world she so carefully crafted. Luckily, Daza's "L'orage s'est calmé…" and his following duet with Machaidze bring us back and remind us of why we're really here. There follows another extremely long set change as the office set is removed and we are returned to the village. This all added up to a huge interruption and distraction. Once we’re back in the village, the show takes off again and we're riveted until the haunting conclusion.
 
The opening night of *The Pearl Fishers* was a special occasion because it fell on the exact day, thirty-one years ago that LA Opera presented its first production. That night, Plácido Domingo starred as Otello. Tonight, Domingo had another starring role with his orchestra. When he entered the pit and turned to acknowledge the welcome from the audience, the applause soared into an ovation of "bravos" and we were given a brief chance to say "thank you" for his myriad artistic accomplishments here in L.A.
 
The production was dedicated to the late Sir Peter Hall who directed at LA Opera for three decades. His *Salome* with Maria Ewing is one of this reviewer's greatest theatrical memories.
 
[*The Pearl Fishers*](https://www.laopera.org/season/1718-Season/pearlfishers/) continues its run **October 15, 19, 22, 25 and 28**.
