+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = "2019-10-14T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Oper Frankfurt's production of [_Manon Lescaut_](https://oper-frankfurt.de/de/spielplan/manon-lescaut/) runs through November 23."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1571017980/media/2019/10/sq4107_manonlescaut07_gross_zfalki.jpg"
primary_image_credit = "Asmik Grigorian (Manon Lescaut) in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller."
related_articles = ["articles/in-review-manon-lescaut-at-roh.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/joshua-guerrero.md", "scene/people/asmik-grigorian.md"]
short_description = "In Puccini's anodyne libretto however, des Grieux and Manon become unwitting martyrs. Des Grieux's self-pity is sublimated into hopeless romanticism too pure for a cruel world. Manon, mercurial and unparsable in the novella, is given a clearly defined voice and a straight-forward moral compass."
slug = "a-star-soprano-and-a-stellar-debut-in-oper-frankfurts-manon-lescaut"
title = "A star soprano and a stellar debut in Oper Frankfurt's Manon Lescaut"
youtube_url = ""

+++
The characters in Abbé Prévost's 1731 novella _Histoire du Chevalier des Grieux et de Manon Lescaut_ are irredeemable, des Grieux most of all. Despite controlling the novella's narrative, the young man comes off as a sociopath. The plot reads like a gussied up litany of his crimes, from petty thievery to armed robbery to cold blooded murder. He's defined less by a drive towards noble love (as in Puccini's opera) than by an inexhaustible depth of self-pity and a willingness to shamelessly leverage status and wealth (often precariously obtained, despite his status) to save himself at the expense of others, including, fatally, Manon.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018055/media/2019/10/4097_manonlescaut20_gross_zmyzsb.jpg){{% /md %}}

<figcaption>Asmik Grigorian (Manon Lescaut, in the center between two poles dancing), Jaeil Kim (A dance master, right next to her snuggled against her) and Ensemble in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

In Puccini's anodyne libretto however, des Grieux and Manon become unwitting martyrs. Des Grieux's self-pity is sublimated into hopeless romanticism too pure for a cruel world. Manon, mercurial and unparseable in the novella, is given a clearly defined voice and a straight-forward moral compass. Opera was popular entertainment after all and Puccini had shows to sell.

> Their flirtation heats up in tandem with growing orchestra swells until the lovers burst into a ravishing duet, their voices sailing to the rafters on a torrent of unison strings.

Àlex Ollé's (_La Fura dels Baus_) new production of _Manon Lescaut_ at Oper Frankfurt moves the story from the 18th century to the present. Before the first note, a short film projected like a movie shows Manon ([Asmik Grigorian](/scene/people/asmik-grigorian/)) laboring in a garment factory, leaving an over-cluttered apartment, ducking under a bolt-cut chain link fence, and being driven in an unmarked van towards who knows where. A voiceover of worried family members laments Manon's absence, her precarious immigration status, and the potential danger she's put herself in by fleeing home.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018085/media/2019/10/4100_manonlescaut05_gross_ieg8g6.jpg){{% /md %}}

<figcaption>Asmik Grigorian (Manon Lescaut, in the front left half dancing) and Ensemble in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

Cut to a stylishly spartan train station cafe with a backdrop of massive cement block letters spelling out LOVE. The towering sculpture, in its coldness and immutability, is so unlike the thing it aims to describe that it seems ironic or at least desperate, like a misguided attempt to solidify an ideal that has become increasingly hard to define.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018148/media/2019/10/4105_manonlescaut10_gross_inszqe.jpg){{% /md %}}

<figcaption>Asmik Grigorian (Manon Lescaut) and Joshua Guerrero (Chevalier Renato Des Grieux) in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

Des Grieux ([Joshua Guerrero](/scene/people/joshua-guerrero/)) spots Manon as she exits the white van and is immediately obsessed. Their flirtation heats up in tandem with growing orchestra swells until the lovers burst into a ravishing duet, their voices sailing to the rafters on a torrent of unison strings. Puccini's intricate understanding of the voice enables him to balance it within powerful orchestral dins. With the instrumentalists at full tilt, the singers' voices still penetrate the soundscape. Grigorian and Guerrero were so in sync in these moments that their voices seemed to ricochet off each other, multiplying in magnitude with each collision of vibrations.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018198/media/2019/10/4108_manonlescaut08_gross_ulywpi.jpg){{% /md %}}

<figcaption>Asmik Grigorian (Manon Lescaut) and Joshua Guerrero (Chevalier Renato Des Grieux) in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

Signalling act two, the cafe's roof discreetly lowers like an elevator platform sliding down the massive concrete LOVE, covering the stage with an intricate new layer of set: a fully functional strip club. Unnecessary nudity in Regietheater is a timeworn cliché, but here it's appropriate. 18th-century Manon is essentially a sex worker, selling love in exchange for security and salary.

> Both he and Grigorian are subtle naturalistic actors and neither lets ego interfere with their dramatic duties.

The same can be said in this updated version. What's different now is the market itself, which caters to a broader public and commodifies women more aggressively. Manon's over-the-hill boyfriend/pimp Geronte profits directly from her wares, unlike her 18th-century patrons. This reversal flips the power structure even further against Manon's favor. Ultimately Manon ends up deported and destitute, dying of thirst and starvation in a desolate American desert.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018220/media/2019/10/4111_manonlescaut15_gross_e2hagg.jpg){{% /md %}}

<figcaption>(l-r) Yury Samoilov (Lescaut), Joshua Guerrero (Chevalier Renato Des Grieux) and Asmik Grigorian (Manon Lescaut) in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

Guerrero and Grigorian both triumph in their roles. [Grigorian](https://operawire.com/charles-castronuovo-asmik-grigorian-win-big-at-the-international-opera-awards/) is a bona fide opera star and not only because she's athletic enough to blend in with professional pole dancers. Though her middle voice is less remarkable, as her voice climbs to its upper range its timbre becomes concentrated, diamond-like in clarity and beauty, flawlessly withstanding punishing series of sustained ascending lines.

> Maestro Lorenzo Viotti wrings a massive sound out of Frankfurt's orchestra, taking advantage of Puccini's forte orchestral interjections to blow the audience's ears back.

Like Grigorian, Guerrero's best singing happens when he flips into his upper register. He opens his mouth and high notes seem to gush out. One feels like a child giddily holding his breath through a tunnel or floating above her seat on the first drop of a roller coaster. You don't want the fun to end.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018251/media/2019/10/4113_manonlescaut01_gross_zleno3.jpg){{% /md %}}

<figcaption>Joshua Guerrero (Chevalier Renato Des Grieux) and Asmik Grigorian (Manon Lescaut) in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

Both he and Grigorian are subtle naturalistic actors and neither lets ego interfere with their dramatic duties. The pair balances acting and singing with a coordinated choreography, giving space to their partner when their melody should take the spotlight, then jumping right back into deft, spontaneous acting.

The production has solid supporting players, with some missteps here and there. Veteran bass Donato Di Stefano's well-sung Geronte de Ravoir seems to have wandered in from the set of _The Sopranos_. Bianca Andrew commits gutsily to a striptease as the musician, and Magnús Baldvinsson brings a delightfully off-kilter sensibility to the crusty cafe maître d'.

> The show achieves a rare alchemy of superb production and set design.

Iurii Samoilov misses as Lescaut. His voice vacillates in and out of its resonance and dramatically he sands down Manon's amoral, alcoholic, huckster brother into a blandly heroic sidekick.

Maestro Lorenzo Viotti wrings a massive sound out of Frankfurt's orchestra, taking advantage of Puccini's forte orchestral interjections to blow the audience's ears back. Still, he's sensitive to the singers and judiciously balances the band to their voices, a difficult task in the hall's notoriously tricky acoustic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1571018291/media/2019/10/4115_manonlescaut21_gross_hsy4jm.jpg){{% /md %}}

<figcaption>Asmik Grigorian (Manon Lescaut) and Joshua Guerrero (Chevalier Renato Des Grieux) in Manon Lescaut, Oper Frankfurt, 2019. Photo: Barbara Aumüller.</figcaption>

</figure>

Àlex Ollé's production faithfully and cleverly translates well-trod musical material and literature into a modern sensibility. The show achieves a rare alchemy of superb production and set design (Alfons Flores), video (Emmanuel Carlier), lighting (Joachim Klein), costume (Lluc Castells), directing (Ollé assisted by Valentina Carrasco), conducting, and singing that Frankfurters will reward with patronage of their own.