+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-08-21T13:53:00-04:00"
lastmod = "2017-08-21T21:16:00-04:00"
preamble = "Readers, the beginning of a new school year is almost upon us. Some of you get excited by the autumn colours and the fresh notebooks, and some of you emit a strong sigh of \"here we go again.\" Whether you're a fan of the fall-to-spring grind or not, it's better spent with a good dose of focus. \n\nOn top of your general plan of becoming a more educated musician, we've got a few specific tasks that are worth some devoted time during this fresh academic year. (Hint: these tips apply for the non-students among you, too.)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1503341670837/2017-08-21---Tasks.jpg.jpg"
publishDate = "2017-08-21T21:16:00-04:00"
related_articles = ["articles/4-myths-from-music-school.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/vibrato-all-the-reasons-why.md"]
short_description = "Readers, the beginning of a new school year is almost upon us. Some of you get excited by the autumn colours and the fresh notebooks; some of you emit a strong sigh of &quot;here we go again.&quot; Whether you&#039;re a fan of the fall-to-spring grind or not, it&#039;s better-spent with a good dose of focus. "
slug = "a-singers-todo-list-4-tasks-to-keep-you-focused-this-year"
title = "A singer&#039;s to-do list: 4 tasks to keep you focused this year"
+++

## Develop a plan for drilling the tricky bits in your music

One of the skills you should take with you as you leave post-secondary education is a solid method of learning your own music. While you still have support from regular coaches and teachers, get specific about the steps you need to learn music as quickly and as thoroughly as possible. 

You can start by identifying what slows down your process; obvious culprits are nasty coloratura sections, strange melodies that don't feel natural, and complicated rhythms. Once you know where the problems lie, you can get a bit scientific about trying out various solutions. If you're focused on coloratura, test out slow practice and switching up the rhythm (we've got more tips on that topic [right here](/4-tips-for-when-there-are-too-many-notes/)); if you're drilling wacky intervals, try singing the phrase in reverse, at different speeds, and in different transpositions.

The goal is to get you as independent as possible, so that the work you do with your teachers and coaches will be time- and money-efficient. Plus, if you develop a reputation for being self-sufficient and quick to learn music, you'll be a hot commodity on the professional scene.

## Learn to paraphrase a song - in your own words

They say that one only truly grasps a concept if they can explain that concept to a young person. Similarly, you can test your understanding of the words in that song or aria you're learning by paraphrasing it in your own words.

Personal anecdote: I once worked with a really fab tenor on Schumann's *Dichterliebe*. At one point, he showed me his genius idea of wrapping his head around the songs, individually and as a whole: he had re-written all of the songs like entries in a diary. It was hilariously emo, and it was a clear reminder of what's timeless about those texts.

You don't necessarily have to make every song a diary entry, but it's an indispensible skill to be able to look at the text of a song or aria and repeat it back in your own words. You can try the "elevator pitch" approach to help you sum up the song's sentiment, but try a line-by-line "translation", too. It's a clear, consistent way of really understanding - and even identifying with - the often lofty poetry that comes with opera and art song.

## Listen to operas that feature no roles for your voice type

Particularly in the years of academia, it can feel like every piece of music you listen to should have some direct correlation to things that you'll sing. It's a noble approach to your extra-curricular time, but it likely means that you're missing out on a bigger picture.

Ladies, make a vow to listen to *Billy Budd*, *Boris Godunov*, *Moby Dick*, and other operas where there aren't a lot of female voices. Gentlemen, settle in to a good recording of *Suor Angelica*, *La voix humaine*, or *Little Women*. Soubrettes and Rossini tenors can learn a lot by listening to Wagner and Puccini, and larger dramatic voices are missing out if they never tune in to *La Cenerentola* or *L'incoronazione di Poppea*.

Basically, make a point of listening to operas that don't come with potential role studies for you. Part of your job as an opera singer is to be familiar with the genre as a whole, not just the small slice that's available to your voice. Plus, you never know: your favourite operas may turn out to be ones you'll never sing in. 

## Pick a musicianship skill, and master it

Are your piano skills laughable? Do you sort of suck at sight-reading? The first step is admitting it; the more productive step is buckling down and strengthening a weak spot in your musical skills. It's a humbling process, to devote an hour a day (or more) to something you know you're not great at, but it's a noble use of time. 

If you're only so-so at harmonic analysis, make it part of your practice time to label the chord progressions in every piece of music you learn. Especially within an academic environment, there are resources to help improve sight-reading and aural skills. Find out if you have a pianist friend who might be willing to trade a few piano lessons for some singing lessons (or baked goods).

The point is this: if you've got a hole in your skill set, start patching it up on your own time, where the reward isn't a grade, but a useful professional skill. 

>Readers, what are your plans for professional improvement this year? Let us know in the comments below, or get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)
