+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2017-10-06T11:32:00-04:00"
lastmod = "2017-10-06T13:13:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507306187537/2017-10-06---Ego.jpg.jpg"
publishDate = "2017-10-06T12:10:00-04:00"
related_articles = ["articles/4-weird-questions-for-opera-singers.md","articles/in-defence-of-singers.md","articles/what-weve-learned-by-talking-with-108-opera-singers.md"]
short_description = "Like I said, this is a stereotype. But even if the opera singer herself is a humble, down-to-earth type, the above scene is still part of her job. She might be a sci-fi nerd and an excellent giver of hugs, but she&#039;s still standing up on that stage holding flowers and looking like a cross between a swan and Grecian fresco. "
slug = "a-singer-and-her-ego"
title = "A singer and her ego"
+++

It's part of the reason that they're called "divas," right? That oversized personality that becomes easily associated with opera singers? Sure, it may be a stereotype, but stereotypes sure do exist for a reason. 

If asked to picture an opera singer onstage, the average person may imagine a well-coiffed, well-gowned lady, poised and ready for an exaggerated curtsey - the kind of bow that's so choreographed that it almost removes the humility it's supposed to intend - holding a lavish bouquet of calla lilies or some other kind of expensive-looking flower.

Like I said, this is a stereotype. But even if the opera singer herself is a humble, down-to-earth type, the above scene is still part of her job. She might be a sci-fi nerd and an excellent giver of hugs, but she's still standing up on that stage holding flowers and looking like a cross between a swan and Grecian fresco. 

And doesn't it take a bit of ego to do that with a straight face? I'm not suggesting that opera singers are putting on a fake personality onstage. The exaggeration and formality of the genre - common, but not ubiquitous - isn't fake. It's well-earned, when you consider the sheer amount of exhaustive work that singers do to make it onto those big stages in the first place. The first person to believe that she's done enough work to deserve applause and flowers should be the artist herself, right?

Singers do funny things that can make them seem mistakenly like someone who's craving attention. At work, they get picky about finding that "perfect tempo", and onstage they can seem to milk that exaggerated bow when the applause kicks in. Offstage, they do things like breaking into song in public - places like busy sidewalks, cafés, and [subways](/louis-cks-subway-opera-singer/). It's an inherently "self-centred" thing to do, in that it's hard for people to ignore someone who has just started belting or crooning with full-blown vibrato. 

But then again, singers are crazy about singing; they *love* it. Sure, you could argue that 
there's a time and place for public singing, but is it really egotistical or self-involved to spontaneously do something you love to do?

Singers tend to overshare. In their voice lessons they bring up weird bodily functions, relationship woes, or they'll deconstruct *ad nauseam* a comment someone made about them in rehearsal or in a review or whatever. Or, they'll take some tragedy or crisis that's happening to a character they're playing in a song or aria, and draw a clear connnection to - you guessed it - themselves. If I knew someone who kept bringing up their own personal moments or making other people's stories about their own lives, I'd say that person is a narcissist. 

But is it narcissistic or egotistical for a singer to overshare and self-relate, when it's actually part of their job - and even who they are? Finding common ground between themselves and their characters is vital to a singer's dramatic process, and that's arguably different from someone with a nasty habit of pulling the conversation toward himself. And I suppose that the type of person who could sing opera for a living - telling extreme stories with mouths agape for hours - is likelier to be the type of person who has a higher bar for what's considered "oversharing".

I guess what we're talking about is the difference between egoism and something like extroversion or sensitivity or a carefree attitude. Doesn't it all depend on whether or not the "diva" is specifically after things like adulation and applause and attention?

I've [interviewed a lot of opera singers](/what-weve-learned-by-talking-with-108-opera-singers/), and I've asked almost all of them why they do what they do. A lot of them say that they love the ability to "communicate" with an audience with their singing (this one makes a bit of an assumption, that an audience *wants* to be part of this singer's onstage "conversation"); others say that they love the opportunity to make an audience feel something they wouldn't otherwise (this one has a bit of an inherent power trip in it, no?).

A smaller group say that it's a thrilling and cathartic thing to become someone else onstage, and fewer still admit that singing is simply their favourite thing to do, and as long as they're able to survive from doing it, they'll choose it over anything else.

So far, none have said that they do it for the applause or attention. (The one exception is tenor and Schmopera contributor Isaiah Bell, who wrote in his amazing piece, ["On the ego"](/on-the-ego/), "I want people to like me. I got into singing because I want people to like me." ) But look: I'm a pianist who enjoys a small portion of rapt attention, and I've learned that playing for singers is the perfect way of getting *some* adulation, without the responsibility of being the main event. I figure if I have taken selfish, egotistical pride in the applause I've earned with my playing, I'm willing to bet that there are singers out there who indulge in a prideful inner monologue that goes something like, *That's right, guys. Can **you** do that? I am a goddess, clap for me*.

If a singer really does have an altruistic relationship with their craft - and these singers do exist - I won't be a skeptic. But in this age of self-love and knowing when you're kicking ass at life, wouldn't it be refreshing to hear more singers say of their noble craft, "I love being the centre of attention!"

>Singers, how much do you love the applause part of your jobs? Let us know in the comments below, or get in touch at [hello@schmopera.com](mailto:hello@schmopera.com).
