+++
author = ["authors/molly-simoneau.md"]
categories = "Review"
date = "2018-10-10T21:23:00-04:00"
lastmod = "2018-10-10T21:23:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539220853410/ViolettasopranoVeneraGimadievrealizesfatewontbekindtoherinWNOsLaTraviata2018production_creditScottSuchman.jpg.jpg"
primary_image_credit = "Venera Gimadieva (Violetta) in Washington National Opera's production of La traviata, 2018. Photo by Scott Suchman."
publishDate = "2018-10-10T21:23:00-04:00"
related_articles = ["articles/la-traviata-shows-houston-how-to-arise.md","articles/in-review-la-traviata-at-roh.md"]
related_companies = ["scene/companies/washington-national-opera.md"]
related_people = ["scene/people/joshua-guerrero.md","scene/people/lucas-meachem.md","scene/people/venera-gimadieva.md"]
short_description = "With a voice that&#039;s all crystal clear, ringing resonance, yet absolutely weightless, she danced through the fioratura of &quot;Sempre libera&quot; without breaking a sweat, and finishing with a perfect high E-flat, then sang with a breathtakingly tender sotto voce in her scene with Germont at &quot;Dite alla giovine,&quot; before opening up later in the act with the broad, sweeping &quot;Amami Alfredo!&quot; while never over-singing. In the final act she offered a gloriously floated high A at the end of simply and beautifully sung &quot;Addio del passato.&quot;"
slug = "a-shining-violetta-in-washington"
title = "A shining Violetta in Washington"
+++

I overheard a conversation as I approached the entrance to the Kennedy Center Opera House before Tuesday night's performance of [*La Traviata*](http://www.kennedy-center.org/calendar/event/OTOSA). "Yeah, I used to subscribe to the Met season but after a while I found it got repetitive," a man said to his friend, "but I always love Traviata."

This is the constant push and pull for the die hard opera lovers of the world.  We crow when seasons are announced, "*Madame Butterfly*? Again? Yawn." We want new opera and we want under-performed and overlooked opera. We want *Bluebeard's Castle* and *I Puritani* and we want Jake Heggie's or Thomas Ades' latest creations, but when *Carmen*, and *Butterfly*, and *Tosca*, and of course *Traviata* are on the bill we keep showing up, again and again.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539220038442/AlfredotenorJoshuaGuerrerocomfortshisdyingloveViolettasopranoVeneraGimadievinWNOsLatraviata2018production_creditScottSuchman.jpg.jpg)
<figcaption>Joshua Guerror (Alfredo) and Venera Gimadieva (Violetta) in Washington National Opera's production of *La traviata*, 2018. Photo by Scott Suchman.</figcaption>
</figure>

And how can we resist? When we hear those aching, shivering chords in the strings which begin Verdi's prelude to, perhaps, his most beloved opera, they grab us by solar plexus and don't let go until Violetta's ecstatic and tragic exclamation of "Ah! Gioia!" two hours later.

After a star-packed 2017/2018 season at Francesca Zambello's Washington National Opera, I was intrigued when I looked up the cast for this run of Verdi's classic and didn’t see a  name among the three leads that I recognized - *Traviata* is a piece that is carried by the prima donna, and it's risky to put trust in a relatively unknown soprano.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219930469/PopularcourtesanViolettasopranoVeneraGimadievafindslovewiththehandsomeAlfredotenorJoshuaGuerreroinWNOsLatraviata2018production_creditScottSuchman.jpg.jpg)
<figcaption>Venera Gimadieva (Violetta) and Joshua Guerrero (Alfredo) in Washington National Opera's production of *La traviata*, 2018. Photo by Scott Suchman.</figcaption>
</figure>

Russian soprano [Venera Gimadieva](/scene/people/venera-gimadieva/), seems to have been busy making a name for herself in Europe - she's performed Violetta at London's Royal Opera House, as well as several other bel canto warhorses at houses throughout the continent, and she triumphed in her WNO debut. With a voice that's all crystal clear, ringing resonance, yet absolutely weightless, she danced through the fioratura of "Sempre libera" without breaking a sweat, and finishing with a perfect high E-flat, then sang with a breathtakingly tender sotto voce in her scene with Germont at "Dite alla giovine," before opening up later in the act with the broad, sweeping "Amami Alfredo!" while never over-singing. In the final act she offered a gloriously floated high A at the end of simply and beautifully sung "Addio del passato."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219939194/GiorgioGermontbaritonLucasMeachemgivesViolettasopranoVeneraGimadievaanultimatuminWNOsLatraviata2018production_creditScottSuchman.jpg.jpg)
<figcaption>Lucas Meachem (Germont) and Venera Gimadieva (Violetta) in Washington National Opera's production of *La traviata*, 2018. Photo by Scott Suchman.</figcaption>
</figure>

Opposite Gimadieva, [Joshua Guerrero](/scene/people/joshua-guerrero/) sang well enough as Alfredo, a somewhat thankless role as far as romantic tenor roles go, destined to play second fiddle to one of the definitive soprano starmakers. He seemed unsure of himself in the first act, sounding rushed with his brief interjections during one of the faster “Sempre Liberas" I've heard, and his act two aria "Deh miei bollenti spiriti," was just ok. Under Zambello's direction, his bluster and spite as the scorned lover made him extra unloveable in a current social climate where the way men behave toward the women in their lives is (rightly) under a microscope.

Baritone [Lucas Meachem](/talking-with-singers-lucas-meachem/) brought a robust, even-toned, masculine voice to the role of the pompous, moralizing Germont. His haughty presence occasionally veered into caricature, and I found myself reminded of the 90's sitcom character Frasier Crane. In his long scene with Violetta, as Gimadieva gave such a nuanced performance with a whole painters palette of vocal colors, Meachem seemed to manage only one level, so later I was pleasantly surprised when he pulled off a huge, thrilling crescendo at the end of "Di Provenza."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219946600/HuntingdogstakecenterstageasAlfredotenorJoshuaGuerrerorelaxesinthecountrysideinWNOsLatraviata2018production_creditScottSuchman.jpg.jpg)
<figcaption>Joshua Guerrero (Alfredo) in Washington National Opera's production of *La traviata*, 2018. Photo by Scott Suchman.</figcaption>
</figure>

As *Traviatas* go, Zambello's production is about what you'd expect: two parties, one quaint love nest in the country, one bleak tuberculosis ward. Zambello adds a bit of depth and death by opening the opera in the stark hospital, where we see Violetta sleeping, while a patient in an adjacent bed dies and is carried out on a stretcher.  The hospital returns at the end of the first act, and it is here that Violetta sings "È strano...Sempre libera." The audience is led to believe that Violetta lives her life in and out of this hospital, and we see Doctor Grenvil, played by bass Timothy J. Bruno, attending to her, and even flirting alongside her many suitors, at both parties.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219953039/GastonetenorArnoldLivingstonGeisandFloramezzosopranoDeborahNansteelenjoythepartyinWNOsLatraviata2018prod.jpg.jpg)
<figcaption>Arnold Livingston Geis (Gastone) and Deborah Nansteel (Flora) in Washington National Opera's production of *La traviata*, 2018. Photo by Scott Suchman.</figcaption>
</figure>

The WNO orchestra led by Renato Palumbo sounded crisp, and clean as a whistle, even as tempos throughout the work were a hair faster than many renditions I've heard. I'm not one to hew to the score and balk at anything that might "contaminate" it, but I found myself asking who thought it was a good idea to let a troupe of dancers onstage during the third act party scene with a bunch of tambourines, and then encouraged the cast and chorus to clap along. The newly added percussion simply seemed out of place.

Misguided choreographical decisions aside, I walked into the Kennedy Center tuesday night wishing for a more adventurous artistic evening than your typical *Traviata*, but what I got was a good old fashioned night at the opera, complete with truly exquisite, thrilling singing from Venera Gimadieva, a name I hope to see on cast lists in Washington again and again.

>La traviata runs at Washington National Opera through October 17. For details and tickets, [click here.](http://www.kennedy-center.org/calendar/event/OTOSA)
