+++
author = ["authors/sara-schabas.md"]
categories = "Op-ed"
date = "2017-02-13T16:59:00+00:00"
lastmod = "2017-02-14T13:55:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487006713847/2017-02-14---Response.jpg.jpg"
publishDate = "2017-02-14T13:55:00+00:00"
related_articles = ["articles/art-is-not-action.md","articles/how-donald-trump-gave-me-writers-block.md","articles/atgbound-a-shocking-immediate-connection.md"]
short_description = "So is it enough to simply lay down Bernstein&#039;s words every time tragedy strikes? No. And while beauty is important in art, art also must challenge, alert and stimulate its performers and listeners, opening our minds to new, diverse thoughts, connecting us to our common humanity, reflecting the darkness of our times and motivating us into action. Activists have already started their marches worldwide: the Women&#039;s Marches, most recently the anti-wall marches in Mexico, and anti-Islamophobia marches in Toronto."
slug = "a-response-to-our-response"
title = "A response to &quot;our response&quot;"
+++

Alex Ross, classical music’s advocate, critic, and shining beacon of hope for relevancy and significance in our times, took on every classical musician’s favourite adage in his [most recent piece](http://www.newyorker.com/culture/cultural-comment/making-art-in-a-time-of-rage) for *The New Yorker*. He dissected the Leonard Bernstein quotation used in response to tragedies by musicians all over social media, "This will be our reply to violence: to make music more intensely, more beautifully, more devotedly than ever before."

Without fail, whenever catastrophe strikes in our society, this line pops up all over my Facebook feed. Yet Ross' article questions whether merely continuing what musicians and artists are already doing, except at a higher level, is enough of a response. And indeed, since the most recent inauguration and with act after act of cruelty being instated in the world's most powerful nation, reinvigoration and a search for new ways to challenge and help and act does seem more fruitful than simply carrying on in the pursuit to make more beautiful music. As expressed in Shakespeare’s Sonnet No. 65 (and quoted in Ross' article):

"How with this rage shall beauty hold a plea?"

I have spent the last two summers as a Fellow at the Aspen Music Festival, where in one of the annual commencement addresses all students and faculty attend, one of the faculty quipped that opera is one of the only things in the world left that is still "deliciously too long." Tearing oneself away from social media and constant technological engagement to sit through a five-hour Wagner opera can intimidate even the greatest of music-lovers. Yet, Ross' essay inspires me that even this can be a form of resilience in this newly anti-intellectual age: "'When 140 characters count as a complete thought, perhaps the occasional thorniness of a longer musical essay might reassure us that important things cannot be abbreviated,' [Steven Schick] wrote."

Two years ago I had the honour of performing in Jake Heggie and Gene Scheer's opera focused around the death penalty, *Dead Man Walking*. Sister Helen Prejean, who attended our performances and on whom Dead Man Walking is based, expressed that she found opera the most powerful medium in which her story had been told. As opposed to in the surface-level Hollywood film made of her story starring Sean Penn and Susan Sarandon, the opera allows time for the interior life of each character and perspective to be explored.

Heggie's music enhances these perspectives, making them relatable to the audience through strategic use of familiar American musical idioms. By the end of the rehearsal process, both cast and crew were emotionally wrecked and one colleague told me that performing in the opera had made him rethink his position on the death penalty. Music and art can comprise some of the greatest works of protest, though a direct political agenda does not comprise necessary criteria for meaningful art. I agree with Alex Ross, in that it is the role of the audience to interpret and absorb the abstractions art presents. If art were entirely literal, symbolic or autobiographical, there would be much less room for creative thought and unique discourse to arise amongst its listeners and viewers.

Art can also fill a void of compassion created by the new exclusionist administration. One of the most meaningful musical parts of my week over the past few months has included singing with elderly residents in a Toronto hospital, some of whom are Holocaust survivors and many of whom have been diagnosed with Alzheimer's dementia. The shared experience of music connects us, brings us joy and reminds us of our shared humanity, in a time when people are being increasingly categorized and divided.

So is it enough to simply lay down Bernstein's words every time tragedy strikes? No. And while beauty is important in art, art also must challenge, alert and stimulate its performers and listeners, opening our minds to new, diverse thoughts, connecting us to our common humanity, reflecting the darkness of our times and motivating us into action. Activists have already started their marches worldwide: the Women's Marches, most recently the anti-wall marches in Mexico, and anti-Islamophobia marches in Toronto. 

Classical music, with its complexity, palate, history, and virtuosic resources, is ready to march in its own way. We classical musicians just need to rise up to the challenge; acting, expressing, and making our art's presence and effect felt. 
