+++
author = ["authors/erik-flaten.md"]
categories = "Review"
date = "2017-09-16T17:16:00-04:00"
lastmod = "2017-09-16T18:08:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596074467/2017-09-16---square---flute-16.jpg.jpg"
publishDate = "2017-09-16T17:22:00-04:00"
related_articles = ["articles/jawdropping-the-nose-at-roh.md","articles/die-zauberflote-at-roh.md","articles/conversations-we-shall-not-be-moved.md","articles/belle-bete-la-opera-beauty.md"]
related_companies = ["scene/companies/opera-philadelphia.md"]
related_people = ["scene/people/ben-bliss.md","scene/people/jarrett-ott.md","scene/people/olga-pudova.md","scene/people/ashley-milanese.md","scene/people/siena-miller.md","scene/people/anastasiia-sidorova.md","scene/people/rachel-sterrenberg.md","scene/people/brenton-ryan.md"]
short_description = "While a new and forward-thinking production such as this Flute is of tremendous value, we must be wary of the cost on the performers themselves. There is a danger in productions where singers are made to fit into a sort of machine (see The Metropolitan Opera) and do not have total freedom to access their full range of expressive tools. These are the tools which would otherwise allow them to connect with the audience and portray their respective characters without limitation."
slug = "a-refreshing-gateway-drug-the-magic-flute-at-o17"
title = "A refreshing gateway drug: The Magic Flute at O17"
+++

In total contrast to the [previous night's world premiere](/a-stunning-premiere-elizabeth-cree/), Opera Philadelphia's production of [*The Magic Flute*](https://www.operaphila.org/whats-on/on-stage-2017-2018/the-magic-flute/) is a genius selection that satisfies both the conservative opera patron and the progressive audience member. While the concept is certainly modern, it still has a Mozartian elegance, charm, and cleverness. Suzanne Andrade, Barrie Kosky, and Paul Barritt have put together a very smart production, which even the most traditional of viewers is sure to enjoy. It becomes instantly clear that this production of a classic manages to look and feel fresh, while also satisfying our craving for the well-loved masterpiece. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596211813/2017-09-16---flute-10.jpg.jpg)
<figcaption>The Queen of the Night (soprano Olga Pudova) orders her daughter Pamina (soprano Rachel Sterrenberg) to kill Sarastro. Photo by Steven Pisano</figcaption>
</figure>

The innovative centerpiece of this production, and the primary storytelling vehicle is the use of projected animations. Graphics portray the majority of the action and scenery throughout the opera. We are treated to bits of silent film-esque dialogue, instead of the otherwise predictable moments of spoken dialogue in the traditional Singspiel style. This silent dialogue is accompanied by Mozart's keyboard music on the fortepiano, which is played with entrancing musicality by Renate Rohlfing. Most of the characters are bound to a single position onstage, or mounted on platforms in the air, while animations handle the rest of the action. Visually mesmerizing and often hilarious images dance all around the stage to enhance and bring new light to moments we know and love. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596245512/2017-09-16---flute-22.jpg.jpg)
<figcaption>Pamina (soprano Rachel Sterrenberg) is soothed by the three spirits (A.J. Owens, Patrick Corcoran, and Damian Ferraro). Photo by Steven Pisano.</figcaption>
</figure>

In the past five years, the worldwide trend in opera houses, in terms of Mozart operas seems to have been a nonstop sequence of rapid tempi. Maestro David Charles Abell's *Flute* was a refreshingly breathable, yet still brisk rendition. The fast and playful score remained precise and exciting from start to finish. Abell and the orchestra did a fine job providing top notch playing, while not burying the singers beneath them, as so often is the case, due to The Academy of Music's dry acoustics.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596270899/2017-09-16---flute-14.jpg.jpg)
<figcaption>Papageno (baritone Jarrett Ott) longs for a Papagena, and Pamina (soprano Rachel Sterrenberg) consoles him. Photo by Steven Pisano</figcaption>
</figure>

When a great company puts on *The Magic Flute*, we expect to hear great singers bringing to life the familiar tunes we have been humming to ourselves in anticipation. This production delivers. It showcases a well rounded cast of expressive singers, despite the sometimes unfortunate stage direction that has them remaining in the same place for the majority of their time onstage. Tenor [Ben Bliss](/scene/people/ben-bliss/) as Tamino sings with such an exquisite sound and impressive command, that we forget just how difficult of an aria "Dies Bildnis" is. From his first entrance, Baritone [Jarrett Ott](/scene/people/jarrett-ott/)'s Papageno is captivating and effortless in his physical embodiment of the bird catcher. His impeccable comedic timing consistently brought the audience into fits of laughter. Ott is quickly emerging as a more-than-reliable singer with great expression and vocal ability. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596339585/2017-09-16---flute-09.jpg.jpg)<figcaption>The three ladies (l-r, soprano Ashley Milanese, soprano Siena Miller, and mezzo-soprano Anastasiia Sidorova) give Papageno (baritone Jarrett Ott) back his voice so he may help Tamino (tenor Ben Bliss) in his trials. Photo by Kelly & Massa Photography</figcaption>
</figure>

[Olga Pudova](/scene/people/olga-pudova/), making her Opera Philadelphia debut as the Queen of the Night, sings with as much fire and power as one can, while also being physically confined to a platform located high above the stage. We missed the show-stealing potential of the Queen's arias because she was required to remain so physically still. Despite the limitations from the production, Pudova still showed mastery of her upper register with flawless high F's. [Ashley Milanese](/scene/people/ashley-milanese/), [Siena Miller](/scene/people/siena-miller/), and [Anastasiia Sidorova](/scene/people/anastasiia-sidorova/) make a dream team of a trio as the Three Ladies. They sing as one unit, but still manage to display their own individuality, flair and fun. The voices blended nicely, with Milanese's silky tone floating on top. [Rachel Sterrenberg](/scene/people/rachel-sterrenberg/) as Pamina sings well, though she does not necessarily have the youthful sound of her colleagues. She sings this difficult role with maturity and grace.

It will be mentioned again and again that the Opera Chorus, under the direction of Elizabeth Braden is a stellar ensemble. Performing consistently well, with tremendous nuance and might, Braden's chorus displays exemplary diction, magnificent blend, and a great, big sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596513137/2017-09-16---flute-13.jpg.jpg)
<figcaption>Monostatos (tenor [Brenton Ryan](/scene/people/brenton-ryan/)) is determined to capture Pamina. Photo by Steven Pisano</figcaption>
</figure>

While a new and forward-thinking production such as this *Flute* is of tremendous value, we must be wary of the cost on the performers themselves. There is a danger in productions where singers are made to fit into a sort of machine (see [The Metropolitan Opera](http://www.npr.org/sections/deceptivecadence/2012/05/07/152183689/wagners-dream-is-it-the-mets-nightmare)) and do not have total freedom to access their full range of expressive tools. These are the tools which would otherwise allow them to connect with the audience and portray their respective characters without limitation. However the team behind this innovative production has found a balance where others have failed. The opera community is always searching for a potential "gateway drug" to lure in new fans who are otherwise completely unfamiliar with the art form. To the question of how to get new fans to buy tickets, this production is the answer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505596523258/2017-09-16---flute-19.jpg.jpg)
<figcaption>Tamino (tenor Ben Bliss) and Pamina (soprano Rachel Sterrenberg) long to be together. Photo by Steven Pisano</figcaption>
</figure>

Opera Philadelphia's [*The Magic Flute*](https://www.operaphila.org/whats-on/on-stage-2017-2018/the-magic-flute/) was beautifully presented, and made for a true delight of an evening. Opera is meant to be entertaining, to remove us from the mundane, and to transport us to another place and time. Without a doubt, Flute did just that, while striking a perfect balance between the past and the present. This production was a modern tribute to an old masterwork, and I'm sure if Mozart himself were in the audience, he would be laughing right alongside the audience. He would have loved being part of the ride.

>The Magic Flute plays until September 24. For details and tickets, [click here.](https://www.operaphila.org/whats-on/on-stage-2017-2018/the-magic-flute/)
