+++
author = ["authors/jeremy-hirsch.md"]
categories = "Interview"
date = "2019-04-20T14:17:19+00:00"
disclaimer = ""
image_gallery = []
postamble = "Next up, Pomakov makes a Canadian return as Méphistophélès in Vancouver Opera's production of _Faust_, April 27 to May 5. For details and ticket information, [click here](https://www.vancouveropera.ca/faust/)."
preamble = "Bass [Robert Pomakov](/scene/people/robert-pomakov/) had an unusually quick start to his career. [Still a teenager](http://www.scena.org/lsm/sm5-9/pomakov-en.htm), he was singled out as a promising singer by the COC's late director Richard Bradshaw, who became a mentor to the young bass. Since then he's been a road warrior touring the globe to sing at the world's most respected houses. He's an unassuming guy off-stage but that doesn't mean he has blunted ambitions.\n\nI spoke with Bob, a [loyal Toronto native](https://www.operabobspublichouse.com/) – he showed up to [coffee](http://bunca.de/) in a vintage Jay's cap –  before the last performance of [_Iolanta_](/the-follies-of-modernization-oedipus-rex-iolanta/) earlier in Oper Frankfurt's season.\n\nThis conversation has been edited and condensed."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1555781169/media/2019/04/sq3703_20iolanta.jpg"
primary_image_credit = "Robert Pomakov as King René in Iolanta, Oper Frankfurt, 2018. Photo: Barbara Aumüller."
related_articles = ["articles/talking-with-singers-ailyn-perez.md", "articles/talking-with-singers-russell-thomas.md", "articles/talking-with-singers-christian-van-horn.md"]
related_companies = ["scene/companies/canadian-opera-company.md", "scene/companies/oper-frankfurt.md", "scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/robert-pomakov.md"]
short_description = "\"It's like when you meet a love for the first time and for the first two months it's ecstatic love. That's what I need to do with my music and with roles; to have that spark at all times because it's what refreshes me.\""
slug = "a-prodigy-grows-into-his-art"
title = "A prodigy grows into his art"
youtube_url = ""

+++
**J: You started working professionally in your teens, then went to Curtis.**

B: But I was working while at Curtis.

**J: Right. You had to turn things down while at Curtis. Not necessarily to save your voice, but to build your technique?**

B: To get an education.

**J: But how has your relationship to the art form developed? You finished Curtis. What was the next thing that happened?**

B: Just working. I'm going to be one of the last singers not to have done a young artist program. That's not possible anymore. I was doing a lot of competitions, so I was making money.

**J: George London, Oratorio Society...**

B: Yeah, and [Queen Elizabeth](http://cmireb.be/cgi?lg=en&pag=1972&tab=108&rec=5229&frm=0&par=aybabtu), [Queen Sonja](https://qsimc.no/en/about-the-competition), [Operalia](https://www.operaliacompetition.org/). I did everything.

I'll never forget, it was the Queen Sonya in Oslo. By this point I was 21, or 22 and I was a competition veteran. I had probably done 15 competitions and I think it was my third international competition with Joan Sutherland on the jury.

I'd always make the finals because of my age and my talent. But partly because I wasn't always driven enough, and partly because I don't think a jury wanted to entrust me with first prize because of my age and my voice type, I'd place. I think the jury felt a responsibility to do that, which in retrospect was the right thing. But it's hard to swallow. When I was younger, I was a much more competitive person. Age kind of chisels away at that.

I'll never forget, at Queen Sonja, I literally sang the best I'd ever sung. I still look back at that video and think, that was damn good singing. I placed third or something – and I remember thinking, for fuck's sakes! So we're at the reception after, and Joan comes up to me, and she says, "Robert dear, maybe one day."

> "I've always been a very naturally curious person, and it's hard to get curious about a character that's only onstage for five or 10 minutes."

The hardest thing for me was being so talented so young and having so much success, but then realizing, it's one thing to do a major role at Curtis or to do Sarastro (_The Magic Flute_) at a B house or place in numerous international competitions; there's a difference between that and having the career I want to have. You have to start at the bottom. Especially being a bass, it's like you're climbing Everest but you're only doing a hundred meters per day. If you want to achieve that, that's a 40, 50-year plan and you have to buy into that.

At the beginning, that was really hard, especially because of the timbre of my voice, and the way I prefer to sing, in a more open heavy way. My agent once said to me, "You know, you listen to all these great basses from the fifties and sixties. That's how you sing." But people don't want to hear that as Figaro or Leporello. Do you know Christian van Horn?

**J: I know his singing. He sang Mefistofele at the MET this season.**

B: Exactly. So he's hit the peak. But he was able to get there by doing a lot of Mozart, whereas that wasn't available to me. So you do a lot of Monterones (_Rigoletto_), Bonzes (_Madama Butterfly_), a Fasolt (_Das Rheingold_) here and there. You do weird, obscure repertoire, or these big, bombastic five to 10-minute scenes. That's how you have to build yourself for ten, fifteen years. But even as a kid, I've always been a very naturally curious person, and it's hard to get curious about a character that's only onstage for five or 10 minutes.

>"You have to get to a very high level day one of rehearsal, and then from day one to opening you have to multiply that by a factor of four or five."

At the end of the day, I'm constantly working and I'm making a good living, so logically I know that's a good thing. That sustains you. But I think it's why, when I get an opportunity like King René (_Iolanta_), I dig my teeth into it so heavily, because it's like, finally this is what I want.

It's one thing if you're going out and doing a Monterone or a Bonze, where you get one moment to take over the stage and you go "Blah," like you're painting with a fucking roller. It has to be very direct. In that case you're using your voice as an instrument of power.

Whereas, what a lot of people forget is that the play _Iolanta_ is based on is called King René's Daughter, so it's actually King René's show. I feel when taking on a lead character, you have a responsibility as both an artist, and as an entertainer – they're two separate things but you have to learn how to bring them together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555781755/media/2019/04/3710_10iolanta2.jpg){{% /md %}}

<figcaption>Asmik Grigorian (Iolanta) and Robert Pomakov (King René) in Iolanta, Oper Frankfurt, 2018. Photo: Barbara Aumüller.</figcaption>

</figure>

**J: What's the difference for you between artist and entertainer?**

B: The entertainer is there for the twelve-hundred people sitting and watching you, and the artist is there as a vehicle of the art, a vehicle of the text, and a vehicle of the music. Especially when you're 4,000 miles from home and you don't have a lot to do on a day-to-day basis besides go to rehearsal, it's incumbent on you to study that score every day and find the nuance.

We as singers always roll our eyes when we hear about six weeks of rehearsal, but there's a reason you do it. Not for the little things, but for the big things. I generally work hard, but I know with this piece I've worked harder than I ever have, every day sitting with that score and asking, what can I do differently, what can I make clearer, what more can I learn from this?

> "When I was younger, I was a much more competitive person. Age kind of chisels away at that."

You have to get to a very high level day one of rehearsal, and then from day one to opening you have to multiply that by a factor of four or five. Your coaching and prep is to get the role into a musically safe, vocally comfortable place. Then once you're in rehearsals, you keep working on those two things, but the characterization takes over in a huge way. When you're in a good collaborative environment, that's fostered easily. When you're not, it's more work.

But I still think you owe it to yourself, you owe it to the score, and you owe it to the audience to put that effort in. Sure, we can all go in and give 70 percent and have a nice career and make good money, but if you're going to go 70 percent, why not go 100 percent? Why not just do that extra work?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555781723/media/2019/04/RobertPomakov-pc-AdrianParks.jpg){{% /md %}}

<figcaption>Robert Pomakov, Canadian bass. Photo by Adrian Parks.</figcaption>

</figure>

**J: Where's the gap for you between 70 and 100 percent?**

B: I think a lot of it depends of the role and on the piece. If you're doing some bel canto piece, you can think of that last 30 percent as really engaged acting, but what kind of engaged acting can you do in bel canto? So then you have to concentrate more on the voice. But if it's all about hitting the marks and just singing as great as I can, I'm putting all my eggs in one basket. If I have an off day, that's going to be really disappointing. Whereas, if you add these other layers, even if you're having a bad day you can find satisfaction in it.

Maybe some people get off on perfecting their technique every day. I need more complexity in what I do. I get bored. I constantly want to find new stuff. That's just the animal that I am. I need more layers.

> Everything's a vehicle in life. So your voice is a vehicle for the music. Your voice is a vehicle for your personality.

I do a lot of work with a particular singer, and he's an animal. He goes on stage and vomits and diarrheas everywhere. And he always recognizes me – still doesn't know my name. We've done, I don't know, four or five productions together, and I've still never seen him engage with anyone on stage even when he's in the most intimate love scene. But I appreciate what he does. I appreciate that kind of animal instinct because that's just too much energy for me. And 85 percent of the audience loves that. It just reads. He arrives for his ridiculous bow and they go nuts.

The last thing I did with him, after the show everyone's standing outside the stage door. He comes swooshing out, takes a lady and kisses her, gets on the back of a motorcycle, and rides off. It's all planned out.

>"I'm not getting self-satisfaction out of this, there's no point in doing anything."

I think we have to have showmen in this business. But I'm not a tenor, and I don't look like that. Those cards aren't there for me, so why should I even attempt to play them? If the art form survives, and my voice survives, I'm going to be doing this another 40 years, so I need to find what fulfills me, understanding that my two priorities are the audience and the art form itself and that I'm the tertiary in that. But, if I'm not getting self-satisfaction out of this, there's no point in doing anything.

**J: Do you think that self-satisfaction feeds the art though?**

B: I think it feeds the creative spirit. Everything's a vehicle in life. So your voice is a vehicle for the music. Your voice is a vehicle for your personality.

It must be so awesome, especially at a house of this level, to have a fest contract and work here, not necessarily year-round, but to have a full paying job and get to spend a good chunk of time in one place and have a life based around that. Perhaps have a family or partner or whatever works into that. I could move over here and do that, but I've been doing this for half my life the way I've been doing it, and I don't see that changing.

I like the hustle better, but it also becomes cumbersome. It's like when you meet a love for the first time and for the first two months it's ecstatic love. That's what I need to do with my music and with roles; to have that spark at all times because it's what refreshes me. It's what keeps me light, which keeps my brain functioning at a decent level.