+++
author = ["authors/vivian-darkbloom.md"]
categories = "Review"
date = "2017-10-13T21:18:00-04:00"
lastmod = "2017-10-13T22:02:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944763505/2017-10-13---square---VEPRES_0523-MALIN-BYSTRO%CC%88M-AS-HE%CC%81LE%CC%80NE-ROH.-PHOTO-BILL-COOPER.jpg.jpg"
primary_image_credit = "Malin Byström (Hélène) in Les vêpres siciliennes, ROH, 2017. Photo: Bill Cooper."
publishDate = "2017-10-13T22:02:00-04:00"
related_articles = ["articles/operas-sexual-assault-secret.md", "articles/in-review-der-rosenkavalier-at-roh.md", "articles/an-operas-evolving-relevance-turandot.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/bryan-hymel.md", "scene/people/malin-bystrm.md", "scene/people/michael-volle.md", "scene/people/erwin-schrott.md"]
short_description = "I don&#039;t understand why we haven&#039;t critically and fundamentally re-read all of these classic operas. I am a huge fan of modernising the way we produce opera, but I think has to include radical re-readings of characters and scenarios, not just new costuming and concepts."
slug = "a-problematic-creaky-old-masterpiece-les-vêpres-siciliennes"
title = "&quot;A problematic creaky old masterpiece&quot;: Les vêpres siciliennes"

+++
If you're a human being in the western world, chances are you've heard about what's going on in Hollywood with Harvey Weinstein. By direct extension, if you're a human being in the opera world, you might have noticed that people are buzzing about sexual misconduct in our own industry. I'd actually just read [Dan Kempson's cutting editorial](/operas-sexual-assault-secret/) about sexual violence in opera when I settled down to watch [*Les vêpres siciliennes*](http://www.roh.org.uk/productions/les-vepres-siciliennes-by-stefan-herheim) at the [Royal Opera House](/scene/companies/royal-opera-house/) last night. I was expecting to marathon through one of Verdi's longest operas. I was ready for some stonking singing and lots of big choruses. I wasn't expecting what I got: a tired revival of an odd production that hasn't managed to catch up with the rest of the world in condemning sexual assault.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944557679/2017-10-13---VEPRES_1842-PRODUCTION-IMAGE-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Production image from *Les vêpres siciliennes*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

The curtain came up and the drama began with the graphic rape of a group of young Sicilian women. I'm not exaggerating when I say graphic. A whole group of young women were abducted, virginal and dressed in white, by brutal soldiers who took them away screaming. The scene cleared, leaving Guy de Montfort, alone (the French Governor of Sicily). He held a woman down by her throat and mimed… well. I don't need to tell you what he mimed. The entire Royal Opera House - 2,200 of us - witnessed the whole act in mimicry. I was in shock. I was furious. And I was also furious that nobody else in the audience seemed to be disturbed. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944566988/2017-10-13---VEPRES_0888-ERWIN-SCHROTT-AS-JEAN-PROCIDA%2C-MALIN-BYSTRO%CC%88M-AS-HE%CC%81LE%CC%80NE-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Erwin Schrott (Jean Procida) and Malin Byström (Hélène) in *Les vêpres siciliennes*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

The story continues as the Sicilian woman becomes pregnant, giving birth to the protagonist of the opera, young Henri. She teaches him to hate his monstrous father. To make a long and complicated plot short, Guy de Montfort knows Henri is his son and attempts to reconcile with him. This production showed us a Montfort who was profoundly misunderstood, a father who longs only to be loved by his son. As far as I'm concerned, we should have seen him as nothing but a monster. I understand the challenges with an opera like this one. The plot is fundamentally flawed. It hinges on a rape. There would be no story without the rape or the resulting pregnancy. But this production didn't damn his crimes. It didn't portray him as a monster, or even a cruel man. He was sympathetic and lonely, a character you were meant to love despite his roughness. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944579020/2017-10-13---VEPRES_1485-BRYAN-HYMEL-AS-HENRI%2C-MALIN-BYSTRO%CC%88M-AS-HE%CC%81LE%CC%80NE-ROH-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Bryan Hymel (Henri) and Malin Byström (Hélène) in *Les vêpres siciliennes*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>
 
The production really didn't get any better. The first act unfolded with grabby, aggressive french soldiers helping themselves to young Sicilian women as they pleased, mocking them openly. The staging gave these women little to no agency over their own bodies - they seemed unable (or unwilling) to free themselves from the clutches of the soldiers. The cherry on top of the treatment of these women was the extra little story of Ninetta, the maid of the main heroine, Hélène. She was sexually harassed and assaulted by French guards in act I, and by act III was pregnant with one of their children and looking terribly happy. Perfect, let's all agree that if you grab a woman enough times, she'll give you what you want! Throughout the opera, women were consistently encouraged to embrace their abusers and let go of their resentment. Unfortunately for directors, this dialogue is written right into the structure of the opera. But let's be honest, it isn't 1855 anymore. Verdi is dead. Let's re-stage, re-think, re-imagine these tired old stories so the music can live.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944600185/2017-10-13---VEPRES_1411-BRYAN-HYMEL-AS-HENRI%2C-MICHAEL-VOLLE-AS-GUY-DE-MONTFORT-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Bryan Hymel (Henri) and Michael Volle (Guy de Montfort) in *Les vêpres siciliennes*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

I don't understand why we haven't critically and fundamentally re-read all of these classic operas. I am a huge fan of modernising the way we produce opera, but I think has to include radical re-readings of characters and scenarios, not just new costuming and concepts. I'm tired of seeing a sympathetic Don Giovanni played across from a despicable Donna Elvira. I don't want to see another production of *Rosenkavalier* where the audience laughs uproariously at the intense sexual harassment perpetrated by Baron Ochs auf Lerchenau towards Sophie. I am done with it. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944614374/2017-10-13---VEPRES_0590-MICHAEL-VOLLE-AS-GUY-DE-MONTFORT-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Michael Volle (Guy de Montfort) in *Les vêpres siciliennes*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

I hated the production, and it's a shame, because the singers I heard last night were stunning. The voices were all incredible. [Malin Byström](/scene/people/malin-bystrom/) was warm and gorgeous as Hélène. [Bryan Hymel](/scene/people/bryan-hymel/), [Michael Volle](/scene/people/michael-volle/) and [Erwin Schrott](/scene/people/erwin-schrott/) were a formidable trio, full of power and passion. They were all wonderful actors and they carried a bizarre, fragmented story with admirable commitment. I would have been blown away by what they had to offer, but I was too angry to enjoy it properly. The staging was very clever, the sets were lush. The drama was well paced, until the third act, which was a bit of a mess of ineffective conceptual staging. But the opera was spoiled for me. It was a messy, old fashioned production of a problematic creaky old masterpiece.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507944625743/2017-10-13---VEPRES_0912-MICHELLE-DALY-AS-NINETTA%2C-JIHOON-KIM-AS-ROBERT-ROH.-PHOTO-BILL-COOPER.jpg.jpg)
<figcaption>Michelle Daly (Ninetta) and Jihoon Kim (Robert) in *Les vêpres siciliennes*, ROH, 2017. Photo: Bill Cooper.</figcaption>
</figure>

>[Les vêpres siciliennes](http://www.roh.org.uk/productions/les-vepres-siciliennes-by-stefan-herheim) runs at the Royal Opera House through November 4. For details and ticket information, follow our box office links below.