+++
author = ["authors/greg.md"]
categories = "Review"
date = "2018-03-30T13:33:00-04:00"
lastmod = "2018-03-31T10:04:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430692466/sq---DressRehearsal_Overcoat-DahliaKatz-6153.jpg.jpg"
primary_image_credit = "Geoffrey Sirett in The Overcoat: A Musical Tailoring, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz."
publishDate = "2018-03-30T13:33:00-04:00"
related_articles = ["articles/materialism-turns-tragic-dont-miss-the-overcoat.md"]
related_companies = ["scene/companies/tapestry-opera.md", "scene/companies/vancouver-opera.md"]
related_people = ["scene/people/geoffrey-sirett.md", "scene/people/peter-mcgillivray.md", "scene/people/keith-klassen.md", "scene/people/aaron-durand.md", "scene/people/giles-tomkins.md", "scene/people/caitlin-wood.md", "scene/people/andrea-ludwig.md", "scene/people/erica-iris.md", "scene/people/magali-simard-galdes.md", "scene/people/meher-pavri.md"]
short_description = "Throughout all the major demands on his body, never once did the character of Akakiy falter or weaken. We empathetically follow his journey from introverted, obsessive-complusive to local celebrity and back down again. We see in him our own need to be held in high regard by people we do, and don&#039;t, know."
slug = "a-perfect-fit-the-overcoat"
title = "A perfect fit: The Overcoat"

+++
Every once in a while a work comes along where all the pieces fall into place. [_The Overcoat: A Musical Tailoring_](https://www.canadianstage.com/online/overcoat), which opened last night in the Bluma Appel Theatre at the St. Lawrence Centre for the Arts, was one such piece.

Based on a movement piece called _The Overcoat_, directed by Morris Panych and choreographed by Wendy Gorling which debuted in Toronto and Vancouver in 1998, twenty years later this adaption of Nikolai Gogol's classic is receiving the operatic treatment at the hands of composer James Rolfe.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430791969/DressRehearsal_Overcoat-DahliaKatz-5427.jpg.jpg)
<figcaption>Andrea Ludwig, Geoffrey Sirett, Colin Heath, and Courtenay Stevens in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

Tapestry Opera, Vancouver Opera, and Canadian Stage join their considerable forces to bring this piece to light. Bringing back the whole creative team from the original 1998 production, and the result is pure theatrical magic. James Rolfe's score is one of the most beautiful and intelligent contemporary works I've heard in a long time. Rolfe's music never outshines the story and successfully drives the pace and the plot along (I will say that this is one of the best-paced opera performances I've seen in a long time). The instrumentation and orchestration were simple and sparse where they needed to be and lush and complex at other times, and flowed seamlessly from one to the other. Leslie Dala led the orchestra and the singers through this work with nuance and skill and mastered the balance of orchestra and singers in the Bluma Appel which is used to housing amplified singers.

>What the show definitively does is show how people are willing place value on people by what they wear.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430800534/DressRehearsal_Overcoat-DahliaKatz-5508.jpg.jpg)
<figcaption>Caitlin Wood, Geoffrey Sirett, Erica Iris Huang, and Magali Simard-Galdes in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

In the lead role of Akakiy Akakiyevich Basmachkin, baritone [Geoffrey Sirett](/scene/people/geoffrey-sirett/) was the perfect fit. Tall, lean, and quirkily handsome Geoffrey sang the role with all of his characteristic artisty. Big and booming at some points, ethereal and delicate in others he was a treasure to listen to. Having already made a name for himself as a "mover" in the opera world (_AtG's Messiah_, TSO's _The Seven Deadly Sins_) Sirett handled the choreographed movements with grace and dignity. Throughout all the major demands on his body, never once did the character of Akakiy falter or weaken. We empathetically follow his journey from introverted, obsessive-complusive to local celebrity and back down again. We see in him our own need to be held in high regard by people we do, and don't, know.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430809559/DressRehearsal_Overcoat-DahliaKatz-6003.jpg.jpg)
<figcaption>Colin Heath (underneath), Geoffrey Sirett, costume design Nancy Bryan in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

Head of the Department and the tailor Petrovich (who fashions the eponymous garment) were both played exquisitely (and hilariously) by Tapestry regular [Peter McGillivray](/talking-with-singers-peter-mcgillivray/). Abandoning a portion of the "prima la voce" attitude and delivering in some seriously high-quality character voicework, yet ably letting his full beautiful tone free when artistically necessary. Alongside Sirett, McGillivray was incredible at the marriage of such heightened movement.

>Constantly flowing over each other and playing a group bully to Akakiy's introvert, the three sang complex harmonies and timings with finesse.

As the predatory Landlady, [Andrea Ludwig](/scene/people/andrea-ludwig/) was every part the 1920s vamp. Using such delicious things as cabbage soup and cigarette smoke, she tries repeatedly and unsuccessfully to woo her way into Akakiy's life. Her voice was clear and bright and covered a wide range.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430819060/DressRehearsal_Overcoat-DahliaKatz-6048.jpg.jpg)
<figcaption>Meher Pavri, Courtenay Stevens, Peter McGillivray, Aaron Durand, Geoffrey Sirett, Giles Tomkins, Asitha Tennekoon in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

As three fellow accountants (and various other roles) tenor [Keith Klassen](/scene/people/keith-klassen/) (Mokiya), baritone [Aaron Durand](/scene/people/aaron-durand/) (Sossiya) and [Giles Tomkins](/scene/people/giles-tomkins/) (Khozodat) were magic in their rollicking staging and musicianship. Constantly flowing over each other and playing a group bully to Akakiy's introvert, the three sang complex harmonies and timings with finesse. As the secretary Meher Pavri was also quite the little vixen. Her voice sparkled and her physicality was divine. As the Manager, Dora-Award winning tenor [Asitha Tennekoon](/scene/people/asitha-tennekoon/) was fiesty and brought his bright-eyed delivery in spades.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430830044/DressRehearsal_Overcoat-DahliaKatz-6141.jpg.jpg)
<figcaption>Aaron Durand, Geoffrey Sirett, Keith Klassen, and Caitlin Wood in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

I think my favourite part of the Mad Chorus sung by Magali Simard-Galdes, Caitlin Wood, and Erica Iris Huang (who also doubled as the Tailor's wife). These three sang some of the most complex music of the show. They sang in tight harmonies and arrangements with an otherworldly colour. At fist I was a little confused as to why they were a "Mad Chorus" but (without giving too much of a spoiler) it all makes sense at the end.

>Works like _The Overcoat_ lie in this most-delicious of grey areas that can lead us all in an incredible direction theatrically.

Enhancing the action and in one of my most favourite theatrical tools, _The Overcoat_ features two non-singing characters (Colin Heath and Courtenay Stevens) who act as conscience, reflection, and disguised running crew. Their movements and dance vocabulary were perfectly suited to both the overall aesthetic of the show as well as the musical composition and narrative.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430838662/DressRehearsal_Overcoat-DahliaKatz-6204.jpg.jpg)
<figcaption>Geoffrey Sirett and entire company in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

A show that combines a libretto by Panych, a score by Rolfe, choreography by Gorling has had the question asked of it: is it an opera?

Spoiler Alert: It is.

I'm not sure why the debate has surrounded this piece in the first place. Is it because Gorling had her singers use their bodies as more than just an instrument to make sound? Was it because Rolfe's score was tonal and accessible even though it was written within the last 10 years? Is it because Panych used some of the most successful, creative staging that didn't rely on "staircases and chandeliers" to create theatre magic? Works like _The Overcoat_ lie in this most-delicious of grey areas that can lead us all in an incredible direction theatrically. Perhaps we should stop asking the question "Is this even an opera?" and start asking "How did this make me feel?" - which I think is kinda the point of art anyway.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522430847544/DressRehearsal_Overcoat-DahliaKatz-6273.jpg.jpg)
<figcaption>Caitlin Wood, Erica Iris Huang, Magali Simard-Galdes, Keith Klassen, and Colin Heath in _The Overcoat: A Musical Tailoring_, a co-production from Tapestry Opera, Canadian Stage, and Vancouver Opera. Photo by Dahlia Katz.</figcaption>
</figure>

What the show definitively does is show how people are willing place value on people by what they wear. Akakiy finds himself in three different "coats" in the show, and each one has society treat him as if he were a completely different person. People infuse all these various qualities upon him based on his attire, and I think it does a great job of exploring both sides of this phenomenon: How people react to you and how you react to people's perceptions of you.

Do yourself a favour if you're in Toronto - [go see this show](https://www.canadianstage.com/online/overcoat). It runs until April 14 at the Bluma Appel Theatre and you can get tickets here. West Coasters, fear not - the show will be moving out to Vancouver to be a part of the Vancouver Opera Festival from April 28 to May 6 and you can book your tickets for the west coast showing [here](http://tickets.vancouveropera.ca/single/EventListing.aspx).