+++
author = ["authors/andrew-schneider.md"]
categories = "Review"
date = "2017-09-17T11:28:00-04:00"
lastmod = "2017-09-17T15:54:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505670433175/2017-09-17---square---_KA38212.jpg.jpg"
primary_image_credit = "Countertenor Nichola Garza in American Baroque Opera Co.'s Masquerade: Opera Cabaret, 2017. Photo by Karen Almond."
publishDate = "2017-09-17T14:55:00-04:00"
related_articles = ["articles/in-review-toronto-masque-theatre-indes-mecaniques.md","articles/in-review-isabel-bayrakdarian-and-tafelmusik.md","articles/wendy-bryn-harmer-leads-sensitive-inspirational-fidelio.md"]
related_companies = ["scene/companies/american-baroque-opera-co.md"]
short_description = "This group has succeeded in being a passionate representative of Baroque opera as not merely an outlier that &quot;comes before the real operas of Mozart, Puccini, Verdi, and Bizet&quot;, but as a vibrant, effusive, and brilliant genre sui generis that appreciates the love and devotion performers bring to it."
slug = "a-masked-ball-american-baroque-opera-cos-opera-cabaret"
title = "A masked ball: American Baroque Opera Co.&#039;s Opera Cabaret"
+++

The [American Baroque Opera Company](/scene/companies/american-baroque-opera-co/), based in the Dallas-Fort Worth area, had its inaugural concert this weekend at the AT&T Performing Arts Center's Hamon Hall, as part of the recently started Elevator Project. I went to the performance on Friday, September 15, at 8:00. It had a great deal to offer just about everyone, from opera newcomers to seasoned early music connoisseurs. This concert, which was called [*Masquerade: Opera Cabaret*](https://www.baroqueopera.org/new-page/), took the form of a Greatest Hits sampler, including several arias from their upcoming spring production of *Alcina*, several other "oldies but goodies", and several rare and virtuosic gems by Vivaldi and Porpora that gave a very promising hint of the repertoire that these intrepid performers intend to bring to the mainstream Texas consciousness.

Indeed, there are several early music groups throughout Texas which often program operatic arias, but this is the first group in the state specifically devoted to Baroque opera. While several mainstream companies have been producing some of the bigger Handel operas, often they are faced with the challenges that come with staging them in extremely big theatres. (My first opera ever was *Giulio Cesare* when Houston Grand Opera staged it in 2003.) A lot of these arias which in "normal" venues are easily perceived as commonplace were most certainly not so here; rather, this concert gave the impression of giving these arias the metaphorical spotlight, highlighting their strong points. In the intimate yet spacious venue that is the Hamon Hall, resembling the rooms that Baroque audiences might well be used to, this concept was brought off very effectively.

It will assist the reader to imagine all the singers (and several of the orchestra players, including the director, Eric Smith, who played cello) with Venetian masks, to understand how successfully this concept worked. Namely, I perceived throughout that attention was easy to focus on the arias as musical works in themselves, as well as the characterization that each of the individual singers brings. Moreover, one must keep in mind that these masks (and costumes) were changing constantly, giving an impression of the singers all being a part of a huge masked ball (or some unknown opera, who knows?), on which this just happened to be a fortuitous "open mic night", without said sound amplification device. The effect was heightened by how the singers just happened to walk up to the stage in character throughout. It was not only a concert; it was an immersion.

The concert opened with the quite virtuosic overture to Vivaldi's *L'Olimpiade*, which showed off the orchestra's agility, dynamic contrast, and cohesion, all attributes which very well foreshadowed the challenges inherent in the music to come. Intonation was very much on point, and the ensemble was very superb at acting as one.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505670459074/2017-09-17---_KA38251.jpg.jpg)<figcaption>Anna Fredericka Popova, soprano, in American Baroque Opera Co.'s *Masquerade: Opera Cabaret*, 2017. Photo by Karen Almond.</figcaption>
</figure>

The above makes what the singers contributed to the picture even more impressive: throughout, the singers were very effective at drawing the listener through the arias to follow, particularly Handel's, which are particuarly long and harmonically complex. Soprano Anna Fredericka Popova's take on "Ah, mio cor" was especially informative, featuring very dark vowels which were very much used to dramatic effect. This 12-minute aria is pretty much Handel attempting to test his ability to use all possible chords in a dramatic C Minor context. One would think merely by this dry theoretical assessment that this aria would be quite esoteric, but Popova ensured it was anything but; every phrase was infused with passion and dramatic interpretation in a way that can entirely be interpreted as a microcosm of the concert as a whole. Her take on "Lascia ch'io pianga", a classic by which many voice students get their introduction to Handel, was similarly transcendent, working with the simple harmonies to render it extremely expressive. She also sang Vivaldi's extremely agile "Siam navi all'onde algenti" with the greatest of ease and finesse. Once again, I credit the intimacy of the space for rendering it easy for the audience to get in contact with the music in the manner articulated above. It enabled the singers to dominate the stage by their presence without having to traverse it physically.

Countertenor Nicholas Garza, who will be singing Ruggiero in the upcoming *Alcina*, showcased one of that character's arias at the end of the first half, "Sta nell'Ircana", complete with a robust natural horn obbligato cheerfully supplied by Nancy Piper, notable for its imitation in canon of the vocal line in places. He also sang "Venti, turbini, prestate" from *Rinaldo* and a passionate cantabile aria by Nicola Porpora, "Alto Giove", the latter of which was quite long, requiring a singer whose ability to sustain long notes and tenuto scales is well-ingrained, and Garza certainly fit the bill in full, with his vibrato being very supportive when necessary, yet never excessive. "Venti, turbini" was a classic study in agility which he also pulled off greatly, though perhaps the tone in melismatic passages was breathy in places.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505670537248/2017-09-17---_KA38147.jpg.jpg)<figcaption>Laura Warriner Bray, mezzo-soprano, in American Baroque Opera Co.'s *Masquerade: Opera Cabaret*, 2017. Photo by Karen Almond.</figcaption>
</figure>

Mezzo-soprano Laura Warriner Bray had no shortage of coloratura arias, but her most impressive factor was her authoritative presence. It greatly assisted her take on Sesto's aria from *Giulio Cesare* (in which she sported a long sword and black cape, perhaps helping us associate the character with the pirate Roman history tells us he became), once again helping the audience make sense of the harmonic complexity of this aria. "Ombra mai fu" was transcendent, with her voice being very much at home throughout her register, as it was in the seemingly ubiquitous "When I am laid in earth" from Purcell's *Dido and Aeneas*. She ended the whole program with "Agitata da due venti" from Vivaldi's *Griselda*, with the usual spellbinding vocal acrobatics which the audience had come to love immensely.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505670510782/2017-09-17---_KA38355.jpg.jpg)
<figcaption>Soprano Jendi Tarde and countertenor Nicholas Garza in American Baroque Opera Co.'s *Masquerade: Opera Cabaret*, 2017. Photo by Karen Almond.</figcaption>
</figure>

Soprano Jendi Tarde filled out the program quite well with her selection which had by far the most acting, in addition to her delightfully unencumbered vocal instrument. She sang "Tornami a vagheggiar" as she will be singing Morgana in *Alcina*, and her ornaments were simultaneously very well-planned yet came off seemingly spontaneously, as if she were effortlessly grasping them from the thin air. One enjoyed guessing what she would do next in the *da capo* sections, in the same manner one enjoys listening to Broadway lyrics for the next witty rhyme. She also sang a song from the play *Dioclesian*, for which Purcell wrote music; quite a bit of the music was set very high for the English words being set, but Tarde was quite great at keeping the whole of the musical line together. The orchestral ritornello featured her scattering flowers amongst us assembled worthies. I particularly enjoyed her take on "Stizzoso, mio stizzoso" from Pergolesi's *La serva padrona*, sung in a hilarious English translation, in which she brought in a chair at a comically slow pace and proceeded to sing while dusting everything in sight, including the occasional unsuspecting violinist. In short, she was, as the vernacular goes, a riot.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505669325324/2017-09-17---Masquerade-Curtain-call.jpg.jpg)
<figcaption>(l-r): Laura Warriner Bray, mezzo-soprano; Nicholas Garza, countertenor; Jendi Tarde, soprano; Anna Fredericka Popova, soprano; Eric Smith, artistic director, taking a curtain call at American Baroque Opera Co.'s *Masquerade: Opera Cabaret*, 2017. Photo by Karen Almond.</figcaption>
</figure>

In short, this group has succeeded in being a passionate representative of Baroque opera as not merely an outlier that "comes before the real operas of Mozart, Puccini, Verdi, and Bizet", but as a vibrant, effusive, and brilliant genre *sui generis* that appreciates the love and devotion performers bring to it. The audience certainly showed this, with great reason, and I look forward to this company accomplishing many great things in the seasons to come.
