+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2017-11-13T14:08:00-05:00"
lastmod = "2017-11-13T18:09:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600667370/2017-11-13---square---Lucia-Anna-Christy-2-Photo-Credit-Chris-Kakol.jpg.jpg"
primary_image_credit = "Anna Christy as Lucia in Lucia di Lammermoor, Florida Grand Opera, 2017. Photo: Chris Kakol."
publishDate = "2017-11-13T18:09:00-05:00"
related_articles = ["articles/a-lucia-with-agency-and-independence-at-the-royal-opera-house.md","articles/in-review-lucia-di-lammermoor-at-roh.md"]
related_companies = ["scene/companies/florida-grand-opera.md"]
related_people = ["scene/people/simon-dyer.md","scene/people/haeran-hong.md","scene/people/jesus-leon.md"]
short_description = "Soprano Haeran Hong in the title role was superb. Her performance from start to finish was a spellbinding display of virtuosity and musical imagination; her mad scene cadenza felt effortless, almost improvised. She captured a range of emotion and colour to rival the soaring range of notes — flawlessly executed — that comprise Donizetti&#039;s challenging score."
slug = "a-luminous-lucia-at-florida-grand-opera"
title = "A luminous Lucia at Florida Grand Opera"
+++

The [*Lucia di Lammermoor*](http://tickets.fgo.org/Tickets/EventDetails.aspx?id=1592) "mad scene" is, to say the least, iconic. Gowned in nuptial white and bathed in blood, Lucia sings to the hallucinated spectre of her lover, Edgardo, after having murdered Arturo, the nobleman she was forced to marry. A quick YouTube survey turns up widely varied interpretations — Lucias who are defiant, urgent, and dangerous; or Lucias who are broken and frail, ethereal tropes of female mental fragility.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600765994/2017-11-13---Lucia-Anna-Christy-1-Photo-Credit-Chrs-Kakol.jpg.jpg)
<figcaption>Anna Christy as Lucia in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>
 
The crowd gathered at Ravenswood Castle reacts in alternating bouts of fear, or pity, or shock; in the Met's 2007 production, Lucia is administered a sedative and physically carried offstage. But in [Florida Grand Opera](/scene/people/florida-grand-opera/)'s November 12 performance (featuring one of two concurrent casts) at the Adrienne Arsht Center in Miami, the heroine was met with a sentiment that seems rare amongst the Internet's trove of mad scenes: compassion.

Soprano [Haeran Hong](/scene/people/haeran-hong/) in the title role was superb. Her performance from start to finish was a spellbinding display of virtuosity and musical imagination; her mad scene cadenza felt effortless, almost improvised. She captured a range of emotion and colour to rival the soaring range of notes — flawlessly executed — that comprise Donizetti's challenging score.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600787806/2017-11-13---Lucia-Anna-Christy-Edgardo-Joshua-Guerrero-2-Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>Anna Christy (Lucia) and Joshua Guerrero (Edgardo) in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>
 
Bass [Simon Dyer](/scene/people/simon-dyer/) as the chaplain Raimondo commanded the role with warmth and sincerity. As Lucia stood centre stage, adrift in an imagined conversation with Edgardo, Raimondo approached her gently and — without a moment's hesitation, unbothered by the blood — placed a reassuring hand on her shoulder. The gesture was one of comfort and solidarity, so often missing from mad scenes that hype up the grisly drama. Outstanding orchestral work — a heavenly flute solo, and French horns acing rich, pitch-perfect harmonies — added to the vulnerable moment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600796895/2017-11-13---Lucia-Anna-Christy-Enrico-Trever-Scheunemann-1-Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>Anna Christy (Lucia) and Trever Scheunemann (Enrico) in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>

The production as a whole was far removed from the compassion and warmth woven through its tragic conclusion. Bleakly minimalist set and costumes by designer Liz Ascroft captured the story's Calvinist undercurrents: tenets of simplicity, atonement, and the fatalism of Predestination. Clad in all black, the chorus' cries of "What joy!" at the approaching wedding came across as laughably ironic. Unwilling bride Lucia would agree.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600919595/2017-11-13---Edgardo-Joshua-Guerrero-Raimondo-Kristopher-Irmiter-Enrico-Trever-Scheunemann_-Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>Joshua Guerrero (Edgardo), Kristopher Irmiter (Raimondo) and TRever Scheunemann (Enrico) in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>
 
The set, conceived as part of a co-production with Houston Grand Opera led by Scottish director John Doyle, was meant to distill the opera's Highlands setting into what Doyle’s program notes referred to as "a cold place, misty gray-blue […] dominated by vast skyscapes." Enormous screens painted with dark, churning clouds were raised and lowered in the foreground and background, sometimes tilted to create stark, geometric diagonals across the stage. During Lucia's secret rendezvous with Edgardo in Act I, nosy guard captain Normanno — sung by tenor Dominick Corbacio with apt deviousness, but with a voice slightly lost in the largest orchestral numbers — could be seen weaving stealthily between the angled layers of cloud cover.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600815600/2017-11-13---Lucia-Anna-Christy-Edgardo-Joshua-Guerrero-4-Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>Anna Christy (Lucia), Joshua Guerrero (Edgardo) in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>

With this dismal, spacious backdrop, lighting designers Jane Cox and Michael James Clark worked magic. Silhouettes and shadows moved fluidly across the stage, and during the famous sextet — musically, one of the most powerful moments of the show — Hong's sobbing Lucia was caught in a soft, luminous glow.

Because Lucia was exactly that: luminous. Even drenched in the blood of her murdered husband, she shone with confidence and strength. Through the eyes of stage director Elise Sandell, leading the FGO production following Doyle's Houston original, Lucia's final moments were not a loss of control, but rather a reclamation of power. "In this time, a woman's place is all about responsibility, with absolutely no control," Sandell wrote in her program notes. "The phrase 'it's a man's world' is more than appropriate in this opera. We see Lucia constantly surrounded and controlled by men."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600827832/2017-11-13---Lucia-Anna-Christy-Alisa-Mary-Beth-Nelson-Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>Anna Christy (Lucia) and Mary Beth Nelson (Alisa) in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>

The mad scene was a striking reversal of this "man's world;" the characters on stage, and the audience along with them, were thrust into a world that was entirely Lucia's. She didn’t break because she was weak; she broke because she was driven to incomprehensible pain by the megalomaniac machinations of abusive, manipulative men.

The men in question were Lucia's brother, Enrico, portrayed by baritone [Troy Cook](/scene/people/troy-cook/); and Edgardo, portrayed by tenor [Jesus León](/scene/people/jesus-leon/). Cook's Enrico was conniving and vengeful, powerfully sung, while León’s intensely expressive Edgardo earned the loudest applause at curtain call. Though Edgardo was positioned as a star-crossed victim of Enrico's merciless power grab, ultimately committing suicide in the opera's final scene, his furious breakup with Lucia after she was driven by her brother to marry another man mirrored villain Enrico's short-fused toxicity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600836320/2017-11-13---Raimondo-Kristopher-Irmiter-Lucia-Anna-Christy-Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>Kristopher Irmiter (Raimondo) and Anna Christy (Lucia) in *Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>

Lucia's support system — kind, logical Raimondo and steadfast best friend Alisa (a thoughtful performance by mezzo-soprano Mary Beth Nelson) — offered concern and solidarity where her brother and lover offered only anger and violence. Still, they could not prevent Lucia's death — a woman's death, seemingly inevitable in opera, yet through Sandell's vision treated with dignity and compassion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510600807391/2017-11-13---Luci-di-Lammermoor_Photo-Credit-Chris-Kakol.jpg.jpg)
<figcaption>*Lucia di Lammermoor*, Florida Grand Opera, 2017. Photo: Chris Kakol.</figcaption>
</figure>

Florida Grand Opera's tagline for the production reads, "A young bride loses it on her wedding night." But that's too dismissive of the events that unfolded on stage: Lucia lost nothing; instead, her health and safety were forcibly taken from her. The performance came in a month and a year during which countless women have stood up and spoken out against the abuses committed by powerful men. Though Lucia didn't survive her trauma, her voice is only one in a growing chorus that refuses to be silenced.

>FGO's *Lucia di Lammermoor* runs through December 2. For details and ticket information, follow our box office links below.
