+++
author = ["authors/vivian-darkbloom.md"]
categories = "Review"
date = "2017-11-01T12:04:00-04:00"
lastmod = "2017-11-01T12:31:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509552937502/2017-11-01---square---PR8A5280-LISETTE-OROPESA-AS-LUCIA%2C-CHARLES-CASTRONOVO-AS-EDGARDO-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg"
primary_image_credit = "Lisette Oropesa (Lucia) and Charles Castronovo (Edgardo) in Lucia di Lammermoor, ROH, 2017. Photo: Stephen Cummiskey."
publishDate = "2017-11-01T12:23:00-04:00"
related_articles = ["articles/in-review-lucia-di-lammermoor-at-roh.md","articles/talking-with-singers-lisette-oropesa.md","articles/a-luminous-lucia-at-florida-grand-opera.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/lisette-oropesa.md","scene/people/christopher-maltman.md","scene/people/charles-castronovo.md"]
short_description = "It was even more refreshing to see a very real depiction of female pain on stage - something that could never be sterilised or downplayed. There was nothing but bravery from Oropesa as she navigated the emotional turmoil of the second half of the opera. "
slug = "a-lucia-with-agency-and-independence-at-the-royal-opera-house"
title = "A Lucia with agency and independence at the Royal Opera House"
+++

I love a production that shakes up operagoers, and in its first season last year, [Katie Mitchell's production of *Lucia*](/in-review-lucia-di-lammermoor-at-roh/) did just that. People were up in arms about it. I saw it during the run and I was blown away by the intensity and beauty of the story. The the drama was unlike anything I'd ever seen from a bel canto opera and Lucia's fate brought me to floods of tears. It remains one of my favourite productions. Last night's revival of the show was a mixed experience for me. They’ve really taken a lot out of the show, I assume to please the ROH’s audience. Last year, I watched a wild Lucia unabashedly make love to Edgardo in the graveyard in Act I. I thought it was a powerful statement of her autonomy and her passion as a woman. This year, they'd removed the sensuality from the first act, something which I thought took away some of the power of the drama.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509553092897/2017-11-01---IMG_0532-RACHAEL-LLOYD-AS-ALISA%2C-LISETTE-OROPESA-AS-LUCIA-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Rachael Lloyd as Alisa and Lisette Oropesa as Lucia, *Lucia di Lammermoor*, ROH, 2017. Photo: Stephen Cummiskey.</figcaption>
</figure>

Thankfully, the structure of Acts II and III remained quite similar. The drama unfolded seamlessly on stage. The set was split in half with two distinct areas, brilliantly crafted to keep the energy moving through the longer scenes. The action was a perfect balance in this production, never pulling you away from the singers for too long, but never failing to give you something beautiful to look at.  The production was visually wonderful as well - cohesive and lush, but not ever overbearing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509553102728/2017-01-11---PR8A5065-LISETTE-OROPESA-AS-LUCIA%2C-KONU-KIM-AS-ARTURO-BUCKLAW%2C-RACHAEL-LLOYD-AS-ALISA%2C-CHARLES-CASTRONOVO-AS-EDGARDO-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Lisette Oropesa (Lucia), Konu Kim (Arturo Bucklaw), Rachael Lloyd (Alisa), and Charles Castronovo (Edgardo), *Lucia di Lammermoor*, ROH, 2017. Photo: Stephen Cummiskey.</figcaption>
</figure>

[Lisette Oropesa](/talking-with-singers-lisette-oropesa/) sang her Royal Opera House debut as a was tender, sincere Lucia. Her voice was easiest in the top and she navigated the role with ease. We did sometimes lose her a little in the bottom of her voice, but she was compelling and vulnerable throughout the whole journey of her character. Her lover, [Charles Castronovo](/scene/people/charles-castronovo/), was wonderful as Edgardo. He portrayed a passionate young lover, sympathetic and believable. His voice was beautiful and easily produced, matching the emotion he put into the role. Castronovo and Oropesa were beautifully matched, giving the impression of true tenderness and passion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509553113473/2017-11-01---PR8A5164-LISETTE-OROPESA-AS-LUCIA%2C-RACHAEL-LLOYD-AS-ALISA-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Lisette Oropesa (Lucia) and Rachael Lloyd (Alisa), *Lucia di Lammermoor*, ROH, 2017. Photo: Stephen Cummiskey.</figcaption>
</figure>

[Christopher Maltman](/scene/people/christopher-maltman/) gave us an Ashton to consider - he was equally despicable and relatable, commanding our attention on the stage. I did feel that sometimes he pushed his splendid voice a little far, giving us a little too much harshness at times.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509553122076/2017-11-01---IMG_0570-CHRISTOPHER-MALTMAN-AS-ENRICO-ASHTON%2C-LISETTE-OROPESA-AS-LUCIA-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Christopher Maltman (Enrico Ashton) and Lisette Oropesa (Lucia), *Lucia di Lammermoor*, ROH, 2017. Photo: Stephen Cummiskey.</figcaption>
</figure>

The only miscast to me was the young fiancé, Arturo. I have no bad words to say about tenor Konu Kim, one of the Jette Parker Young Artists. In fact, I thought Kim was wonderful - his voice really shone, even in just a few bars - and I hope we hear more of him. I simply thought he was too handsome and too likeable to be a very good Arturo. He was too upstanding and too sympathetic - I felt that I wanted to hate him, but I couldn't.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509553130886/2017-11-01---IMG_0836-CHRISTOPHER-MALTMAN-AS-ENRICO-ASHTON%2C-KONU-KIM-AS-ARTURO-BUCKLAW-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Christopher Maltman (Enrico) and Konu Kim (Arturo), *Lucia di Lammermoor*, ROH, 2017. Photo: Stephen Cummiskey.</figcaption>
</figure>

Despite the sterilising of Act I, I still loved this production. It was refreshing to see a Lucia with agency and independence, an upending of the traditionally docile gothic heroine. It was even more refreshing to see a very real depiction of female pain on stage - something that could never be sterilised or downplayed. There was nothing but bravery from Oropesa as she navigated the emotional turmoil of the second half of the opera. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509553140222/2017-11-01---PR8A5530-LISETTE-OROPESA-AS-LUCIA%2C-CHARLES-CASTRONOVO-AS-EDGARDO-ROH.-PHOTO-BY-STEPHEN-CUMMISKEY.jpg.jpg)
<figcaption>Lisette Oropesa (Lucia) and Charles Castronovo (Edgardo), *Lucia di Lammermoor*, ROH, 2017. Photo: Stephen Cummiskey.</figcaption>
</figure>

This production gives me hope, in a way. Hope for a future that reimagines opera into something that belongs in the 21st century. Something that subverts the age-old narratives of male dominance, a standard in the world of opera. If we want to continue to share these great works of art, we need to continue to change the way we look at these characters. I am glad that Royal Opera House chose to present this production again (albeit, in a muted form). I hope they continue to think outside the box, especially when it comes to established repertoire pieces.

>[*Lucia di Lammermoor*](http://www.roh.org.uk/productions/lucia-di-lammermoor-by-katie-mitchell) runs through November 27 at the Royal Opera House. For details and ticket information, follow our box office links below.
