+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2024-07-15T00:00:00-00:00"
lastmod = "2024-07-15T00:00:00-00:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1720897949/sqNightMusic_Susan_Graham.jpg"
primary_image_credit = "Susan Graham, mezzo-soprano. Photo: Dario Acosta."
publishDate = "2024-07-15T00:00:00-00:00"
related_articles = ["articles/talking-with-singers-matthew-polenzani.md", "articles/stellar-performances-from-a-star-cast-in-chicagos-dead-man-walking/.md"]
related_people = [""]
related_companies = [""]
short_description = "Graham captures Desiree's humor and sass and broaches the melancholy in the ever sigh-worthy Send in the Clowns."
slug = "jonathan-tunicks-symphony-size-orchestration-for-sondheims-a-little-night-music"
title = "Jonathan Tunick's symphony size orchestration for Sondheim's A Little Night Music"

+++
Stephen Sondheim said it best in a 2011 video interview for Sony Masterworks. "Jonathan Tunick is the best orchestrator in the history of the theater...What I value most about Jonathan is his dramatic instinct." That instinct was on beautifully knowing display when he led the Orchestra of St. Luke's in his new orchestration for Sondheim's "A Little Night Music" in a concert production at David Geffen Hall.

Can an orchestration for 53 musicians, almost twice the size of the original Broadway pit crew, also orchestrated by Tunick, enrich the sound while maintaining the intimacy of the score or the delicacy of the waltzes that permeate it? Can it resonate and reveal while serving the amorous encounters in an actress's dressing room or the furtive summer night maneuvers at the chateau of an aged courtesan? Under Tunick, yes. Resonant strings evoking memories and possibilities wafted through the hall while flirty woodwinds and the rich timbre of horns underscored the gravity of the romantic antics at hand.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1720897949/NightMusic_Sondheim_and_Tunick_at_the_2003_rehersals_for_NY_City_Operas_s_ALNM.jpg){{% /md %}}
<figcaption>'A Little Night Music' composer, Stephen Sondheim (left), and his and frequent orchestrator, Jonathan Tunick in 2003. Photo: Sara Krulwich / The New York Times.</figcaption>
</figure>

Long a Sondheim collaborator, Tunick has orchestrated _Company_, _Pacific Overtures_, _Merrily We Roll Along_, _Into the Woods_, and, the composer’s final show, _Here We Are_. Most notably for Cleo Laine, herself once a lively Desiree, he orchestrated the essential recording, "Cleo Sings Sondheim", matching Laine's jazzy sensibility and theatrical training with orchestrations that maintained "theater song" status but with enough pizazz to attract a non-Broadway audience.

Susan Graham, the celebrated mezzo-soprano sang the role of Desiree Armfeldt, an actress who thinks it might be time to give up her not-so-glamorous life on and off stage. Perhaps she'll settle down with the middle-aged Fredrik, a former lover who is, inconveniently, the husband in an unconsummated marriage with the youthful Anne. Graham captures Desiree's humor and sass and broaches the melancholy in the ever sigh-worthy "Send in the Clowns". Ironically, the song, indeed the entire role, was written for a singer of limited singing range (Glynis Johns won the 1973 Tony Award for her Desiree) and Graham possesses an unalloyed abundance of range. Just for a moment I let my mind wander to her lovely "Vilja" from _The Merry Widow_ a few seasons back. Desiree's young daughter, Fredrika, her name telegraphing a happy ending, was sung by Addie Harrington, a beguiling presence throughout, especially so in "The Glamorous Life". Flanked by Desiree and her grandmother, Madame Armfeldt, played by Marsha Mason who, to put it simply, was beige in this most purple of roles, Harrington was an energetic delight.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1720897950/NightMusic_Jason_Gotay_Shuler_Hensley_Susan_Graham_Marsha_Mason_Ruthie_Ann_Miles_Ron_Raines_and_Kerstin_Anderson.jpg){{% /md %}}
<figcaption>(l-r) Jason Gotay (Henrik), Shuler Hensley (Carl-Magnus), Susan Graham (Desiree Armfeldt), Marsha Mason (Madame Armfeldt), Ruthie Ann Miles (Charlotte), Ron Raines (Fredrik) and Kerstin Anderson (Anne) in Stephen Sondheim's 'A Little Night Music', featuring a new orchestration by Jonathan Tunick at the conductor's podium. Photo: Joan Marcus.</figcaption>
</figure>

Ron Raines, having his third go at Fredrik, brought little more than a booming voice this time around. He barely projected the charm and animation that might have attracted Anne in the first place. Their relationship felt not just implausible but vaguely disturbing, especially as the delightful Kerstin Anderson played her. Of sweet voice and demeanor, Anderson reveled in her character's naiveté without descending into cuteness. She imbued Anne with a streak of cleverness, giving this virgin bride some depth.

Jason Gotay was earnest, intense and befuddled as Fredrik's son Henrik, a frustrated divinity student, with a handsome sound and bearing. It's aways a pleasure to know what the characters don't, in this case the romantic destinies of Anne and Henrik. More telegraphing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1720897950/NightMusic_Jin-Ha-and-Cynthia-Erivo.jpg){{% /md %}}
<figcaption>Jim Ha (Frid, Madame Armfeldt’s servant) and Cynthia Erivo (Petra, Anne's flirtatious maid and confidante). With a show-stopping rendition of 'Silly People', Ha welcomed the song back to the score after it was cut in Boston decades ago. Petra sang a compelling 'The Miller's Son'. Photo: Joan Marcus. </figcaption>
</figure>

Another pleasure was Jin Ha's impassioned rendition of the reinstated "Silly People", cut decades ago in Boston. Without the song Frid does little more than push Madame Armfeldt about in her wheel chair. Ha gave "Silly People" a somewhat bitter song, a show-stopping homecoming. Back and hopefully forever, it and "The Miller's Son" are quite the framework for "Send in the Clowns".

Aside from borrowing the show's title from Mozart, Sondheim carries on his tradition of writing music for the peasants, in this case the service class, consisting of Frid and Anne's flirtatious maid and closest confidant, Petra. Cynthia Erivo entered with an attitude so intense that It was reasonable to wonder if this was her take on Petra or something else altogether. Whatever the case she compounded Henrik’s frustration with cat-like prowess. Later, singing "The Miller's Son", Erivo was undeniably commanding but still seemed ambiguously possessed. At Saturday afternoon's performance she required an orchestral pause to regain her place in Sondheim's rapid-fire lyrics.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1720897950/NightMusic_Ruthie-Ann-Miles-and-Kerstin-Anderson.jpg){{% /md %}}
<figcaption>Ruthie Ann Miles (Charlotte) and Krestin Anderson (Anne) share the trials of dealing with unfaithful husbands in 'Every Day A Little Death'. Photo: Joan Marcus.</figcaption>
</figure>

Mozartian influence was again apparent in the puffed up Count, Carl-Magnus who claims Desiree as his mistress, and Charlotte, his suffering but calculating wife. Shuler Hensley worked earnestly to portray Carl-Magnus as a strutting peacock and found the comedy in his unrelenting pomposity. Charlotte, played by the always superb Ruthie Ann Miles, laced every word and gesture with irony and sardonic wit. Charlotte could easily slip into parody but instead she was the most fully realized character on stage, eclipsing the limits of concertized performance.

Above and around all the goings-on were the Liebeslieders, a stylish group of three women and two men, functioning as a musical chorus and risqué memory bank. Singing with elegance and infectious mischief they were Leah Horowitz, Jonathan Christopher, Andrea Jones-Sojola, Ross Lekites and Ellie Fishman. Marvelously unified, each still managed to suggest a distinct and racey character and though they didn't actually dance they were, quite pleasantly, swirling everywhere.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1720897950/NightMusic_From-L-to-R_-Leah-Horowitz-Jonathan-Christopher-Andrea-Jones-Sojola-Ross-Lekites-Ellie-Fishman.jpg){{% /md %}}
<figcaption>(l-r) The Liebeslieders; Leah Horowitz, Jonathan Christopher, Andrea Jones-Sojola, Ross Lekites and Ellie Fishman who functioned as a musical chorus and risqué memory bank. Photo: Joan Marcus.</figcaption>
</figure>

A much-anticipated recording is planned and will doubtless hold pride of place in _Night Music_ collections, though the original Broadway cast recording still rules. In the meantime we have been gifted with a _Night Music_ that transcends musical theater and advocates for its presence in opera houses and symphony halls. Tunick's most enduring contribution to Sondheim's work may be in keeping this heady masterpiece alive — and waltzing.