+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2018-03-06T08:24:00-05:00"
lastmod = "2018-03-06T12:07:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520341726463/sq---Christian-Van-Horn_FAUST_T8A1706_c.Cory-Weaver.jpg.jpg"
primary_image_credit = "Christian van Horn (Méphistophélès) in Faust, Lyric Opera of Chicago, 2018. Photo: Cory Weaver."
publishDate = "2018-03-06T08:24:00-05:00"
related_articles = ["articles/talking-with-singers-christian-van-horn.md","articles/talking-with-singers-ailyn-perez.md","articles/fellow-travelers-is-luminous-in-chicago.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/ailyn-prez.md","scene/people/christian-van-horn.md","scene/people/edward-parks.md","scene/people/benjamin-bernheim.md"]
short_description = "Dressed as a fantastical dandy in a violent orange suit, van Horn&#039;s Mephisto was cool. And it&#039;s not just his good looks—which not even a black-and-white pompadour could disguise—it&#039;s also his booming but seductive-sweet voice."
slug = "a-kind-of-twisted-egotistical-apotheosis-faust-in-chicago"
title = "A kind of twisted, egotistical apotheosis: Faust in Chicago"
+++

At the [Lyric Opera of Chicago this month](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/faust-opera-tickets#), Faust is a frustrated artist, whose own carvings and *objets* come to life to torment him. This new production is the result of a unique collaboration between visual artist John Frame (whose artwork and guiding aesthetic shaped the opera's look), set and costume designer Vita Tzykun, lighting designer Duane Shuler, projection designer David Adam Moore, and director Kevin Newbury. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342129524/Ailyn-Pe%CC%81rez_Benjamin-Bernheim_Christian-Van-Horn_FAUST_T8A1168c.Cory-Weaver.jpg.jpg)
<figcaption>Benjamin Bernheim (Faust) and Christian van Horn (Méphistophélès) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>

As a disclaimer, I feel this production is being treated unfairly in the press. I am irked by dour critics who attend productions only to waste their inches summarizing how a performance failed to conform to their own pre-existing expectations of the work—an exercise I consider reductive and ultimately pointless. Approaching opera with an eager, open-mind is especially crucial with regards to new productions, the commissioning and performing of which I consider vital to the continuation of our art form. This production takes liberties and pushed boundaries that give this classic new life (for those thoughtful enough to appreciate it.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342150224/Benjamin-Bernheim_FAUST_T8A0811_c.Cory-Weaver.jpg.jpg)
<figcaption>Benjamin Bernheim (Faust) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>

In the titular role, French tenor [Benjamin Bernheim](/scene/people/benjamin-bernheim/) was astounding. In this production, Faust is an ambivalent but ultimately obedient follower of the Devil. While indecisiveness is a difficult posture to strike onstage, Bernheim's singing was anything but ambiguous. His warm but cutting voice is a perfect fit for the French lyric repertoire. It was exhilarating to witness his triumphant American debut.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342160733/Ailyn-Pe%CC%81rez_37A1231_c.Cory-Weaver.jpg.jpg)
<figcaption>Ailyn Pérez (Marguerite) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>

House favorite [Christian van Horn](/talking-with-singers-christian-van-horn/) imbued his Méphistophélès with a greasy kind of charm and violent humour. Dressed as a fantastical dandy in a violent orange suit, van Horn's Mephisto was *cool*. And it's not just his good looks—which not even a black-and-white pompadour could disguise—it's also his booming but seductive-sweet voice. It's no wonder he's made something of a specialty of villains, including all four in [*Les contes d'Hoffmann*](http://www.christianvanhorn.com/4-villians).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342179245/Christian-Van-Horn_Benjamin-Bernheim_FAUST_10_c.AndrewCioffi.jpg.jpg)
<figcaption>Christian van Horn (Méphistophélès) and Benjamin Bernheim (Faust) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>

From Marguerite's first line in Act II, [Ailyn Pérez](/talking-with-singers-ailyn-perez/)'s uniquely beautiful tone and uncommon intelligence, subtlety, and emotional commitment were self-evident. Pérez is also a gifted, compelling actress—crucial for this physically-demanding production in which Marguerite is disabled and uses crutches throughout. It was refreshing to see a disability symbolizing not an outward manifestation of some inner corruption but rather as a marker of self-reliance. 

Baritone [Edward Parks](/scene/people/edward-parks/) makes his Lyric debut as Marguerite's brother, Valentin. His death scene at the end of Act IV was some of the most profound, expressive singing I've heard on the Lyric stage this season. A truly gripping performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342195133/FAUST_59_c.AndrewCioffi.jpg.jpg)
<figcaption>Ailyn Pérez (Marguerite) and Christian van Horn (Méphistophélès) *Faust*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>

While I won't present a full litany of all the additions and design elements that make this new production unique, I want to mention a few that I found especially meaningful. During the Act IV's church scene, a heavily-pregnant Marguerite sits side-by-side with Méphistophélès. At the scene's climax, she goes into labor and in a moment of sheer *Rosemary's Baby*-style horror, the Devil steals her baby. In the libretto, it is alluded to that Marguerite commits infanticide, though as the director Kevin Newberry pointed out in a [must-read interview](http://www.chicagotribune.com/entertainment/music/vonrhein/ct-ent-classical-lyric-faust-preview-0228-story.html) with John von Rhein of the Chicago Tribune,"In the libretto she never says, 'I killed my child'—it's Mephisto who says that to Faust and Faust repeats it." It was a shocking visual but one that was far from gratuitous; the result was that Marguerite's dramatic arc was more clearly articulated and coherent.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342207806/Benjamin-Bernheim_FAUST_37A0479_c.Cory-Weaver.jpg.jpg)
<figcaption>Benjamin Bernheim (Faust) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>

Usually in top-form, the Lyric Chorus occasionally struggled on Saturday evening to find maestro Villaume's downbeats, especially in the coquettish women's first entrance, when rushed singing threatened to unseam the ensemble. The chorus' strongest impression came in the Act IV Scene 3 soldier's chorus, here played for maximum nihilistic effect, with the ragged, battle-scarred troops seizing onto the stage as Moore's skeletal animations intimate that war, too, is the province of the Devil.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342297469/Edward-Parks_Ailyn-Pe%CC%81rez_FAUST_95_c.AndrewCioffi.jpg.jpg)
<figcaption>Edward Parks (Valentin) and Ailyn Pérez (Marguerite) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Andrew Cioffi.</figcaption>
</figure>

What may prove most controversial about this production is its treatment of the opera's final moments. In a move that disrupts the most blatant Christian moralizing of the libretto, Marguerite's ultimate redemption was relegated upstage while Faust's demise takes downstage center. Throughout the opera, Méphistophélès' helpers, (think steampunk *commedia dell'arte* with Punch-&-Judy-sized masks), attend to every scene and invade every bit of the action. At the last, Faust is presented with his own mask and takes his place in line with the minions. In the context of the production's generative premise, the substance of Faust's ultimate transformation is unclear; has he become the Devil's minion or been subsumed into his own art, a kind of twisted, egotistical apotheosis?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520342306838/Ailyn-Pe%CC%81rez_FAUST_T8A1245_c.Cory-Weaver.jpg.jpg)
<figcaption>Ailyn Pérez (Marguerite) in *Faust*, Lyric Opera of Chicago, 2018. Photo: Cory Weaver.</figcaption>
</figure>

Days later, I'm still ruminating on that and other questions inspired by this dynamic, [deeply human *Faust*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/faust-opera-tickets#). I'm planning to see it again, further along in its run (continuing through March 21), and hope to see you there!
