+++
author = ["authors/michael-zarathuscook.md"]
categories = "Review"
date = 2020-02-04T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1580866081/media/2020/02/sqPBNC_1255a_d5mm0z.jpg"
primary_image_credit = "Kevin Short as Porgy and Angel Blue as Bess in The Gershwins' \"Porgy and Bess.\" Photo: Ken Howard / Met Opera."
related_articles = []
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/eric-owens.md", "scene/people/angel-blue.md"]
short_description = "Even with Gershwin's best intentions in demanding that this opera only ever be produced with an all-black cast, it is nonetheless apparent that this was and is an opera written for the white gaze. Be it the cringe-inducing libretto, the caricatured depiction of Southern accents (both white and black), the depiction of the hyper-saturation of religion in black communities (on and on with talk of the \"promised land\") and the gross exaggeration of Bess as the quintessential portrait of semper femina."
slug = "a-handful-of-the-mets-porgy-and-bess"
title = "A handful of the Met's Porgy and Bess"
youtube_url = ""

+++
If you're looking for a handful of popcorn to go along with some opera, or a handful of an opera with some popcorn on the side, either way you should see the Met's _Porgy and Bess_. Broadcasted live and in high definition - though of course nothing compares to the live experience - it's a marvel of the camera work that adds extra dimensions to the experience.

That said, even with all the close-ups and fancy cuts, outstanding cast of singers and dancers, perfectly believable sets and costumes—the cringe-worthiness of _Porgy and Bess_ is nevertheless an ineluctable feature of this stellar production. It's a complicated experience, but one still worth having, inasmuch as an all-black cast on an opera stage is a few and far between thing (more on that later). The main thing is that this production succeeds as a hybrid: a hybrid of opera and musical theatre, of classical and jazz inspirations, of stage and screen, dance and voice, of the vestiges of a racist past and a self-conscious present, and - again - popcorn and opera: an underestimated combination.

> Her choreography was, for me, really the only unique feature of this production that made it feel like it was happening to an audience in 2020.

This production's stage is a busy place, a sixty-member chorus to bolster an already sizable list of main characters, the set is practically a rotating neighbourhood and the lighting design has to account for both changes in daylight as well as seasons. All of it works together because of the cast; it's amazing to see the whole host of singers move and feel as a cohesive unit. Much credit goes to the chemistry between the main cast for adding an extra layer of believability to the fictional lives of the residents of Catfish Row.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580866150/media/2020/02/PBNC_0492a_wx3pvg.jpg){{% /md %}}

<figcaption>A scene from The Gershwins' "Porgy and Bess" with Kevin Short as Porgy and Angel Blue as Bess. Photo: Ken Howard / Met Opera</figcaption>

</figure>

One of the biggest stars of the production, however, didn’t make an appearance till the curtain call: Camille Brown, the forty-year old choreographer making her Met debut and taking on the biggest cast she's ever worked with. Her choreography was, for me, really the only unique feature of this production that made it feel like it was happening to an audience in 2020. Her emphasis and mission was to more or less draw out the innate choreography ensconced in black bodies, to present and incorporate African-American dance culture as a form of communication that is as essential as dialogue, a form of protest even, simultaneously defiant and jubilant. Her invisible hand is present throughout this nearly four-hour ordeal, not just in the dancing, but as well in the generally diffused kinetic energy that animates the chorus and main cast.

> Mostly in a sleek maroon gown, her profile is subtly highlighted amongst the period drab of her surrounding characters.

Even with Gershwin's best intentions in demanding that this opera only ever be produced with an all-black cast, it is nonetheless apparent that this was and is an opera written for the _white gaze_. Be it the cringe-inducing libretto, the caricatured depiction of Southern accents (both white and black), the depiction of the hyper-saturation of religion in black communities (on and on with talk of the "promised land") and the gross exaggeration of Bess as the quintessential portrait of _semper femina_ - Brown's choreography is about the only thing in this production that isn’t for the gaze of the demographic of the audience present when this work premiered in 1935. The social context of her choreography, however, works in tandem with her solution to the always questionable task of integrating dance into opera. "I didn't want it to be a space where first you have the dancers, and then the actors, and then everybody comes together every five minutes," said Brown in an interview for the Met’s website, "I really wanted it to be a community where it's all flowing and everybody has the same energy".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580866176/media/2020/02/PBNC_0829b_ud3qhz.jpg){{% /md %}}

<figcaption>Donovan Singletary as Jake and Janai Brugger as Clara in The Gershwins' "Porgy and Bess." Photo: Ken Howard / Met Opera.</figcaption>

</figure>

Brown is definitely one of the engines on which this production runs, the other is tenor Frederick Ballentine whose slick and serpentine portrayal of Sportin' Life - the resident stereotypical neighbourhood coke dealer - is the rotary that keeps the show moving every time one is just about to get sick of Porgy's pussyfooting and Bess's too-one-dimensional character. There are still two more shows left in this extended run, if you should see it, keep an eye and ear out for the sheer ballistic force that propels Ballentine's take on the "It ain't necessarily so" aria.

Speaking of Porgy and Bess, one does best to separate the performances by [Eric Owens](/scene/people/eric-owens/) and [Angel Blue](/spotlight-on-angel-blue/) from the aspects of their characters that feel dated. Starting with Owens as Porgy, the physical toll of his performance would still be deserving of the ovation it received even if there hadn't been a pre-show announcement that he was fighting off a vicious cold but would nonetheless be performing. The result of which is an ever-so-slightly hoarse Porgy, which is actually quite befitting and nearly irrelevant next to Owens's tremendous voice control. His Porgy is portly and steady, and his commitment to the character's deformity is remarkable - inexplicably sustaining the contortion of his right leg away from his body throughout the performance - so much so that there's a bit of a jolt when we comes out of character for the curtain call.

> I’d be remiss if I didn’t mention the music, but truth be told the music barely registered in the broadcast.

Angel Blue's Bess, on the other hand, rang bell-clear. Her presence is the most dominant on stage, and not just because her character's name is in the title. Mostly in a sleek maroon gown, her profile is subtly highlighted amongst the period drab of her surrounding characters. Even through the shoddy volume at which this broadcast played out at the Cineplex at Yonge and Dundas (a major irk throughout), the reverberative power of her voice was a head above the rest.

Other notable performances include that of South African soprano Golda Schultz as Clara, her "Summertime" aria at the start of Act I delivered a strong start; and soprano Latonia Moore's stellar performance as Serena, the borough's matriarch, who shined in the spotlight set by the "My Man's Gone Now" aria.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580866206/media/2020/02/PBNC_0861b_nwy7xe.jpg){{% /md %}}

<figcaption>Angel Blue as Bess and Kevin Short as Porgy in The Gershwins' "Porgy and Bess." Photo: Ken Howard / Met Opera.</figcaption>

</figure>

The remaining aspects of the production are variously applaudable: the costumes are unambitious, and therefore accurate - though not even period accuracy can justify the combination of wearing suspenders _and_ a belt - nearly all are clothed in a washed pastel motley of period pieces, save for the Undertaker, whose attire was handled with a bit more spiff. The projections are used effectively and discreetly, mainly on the large translucent scrim that displays impressionistic silhouettes of Catfish Row in between acts. The lighting design is likewise unadventurous, serving moreso to direct attention than to inspire it by keeping the busy set tidy with perfectly timed highlights and transitions. The set design is more conceptual than realistic - more so like scaffolding than it is a structure - but nevertheless evocative of the solidity and depth of a realistic living space. 

> How else will mainstream opera celebrate black singers if we cancel _Porgy_?

Set designer Michael Yeargan does a really good job of navigating the public and private spaces of Catfish Row without any set changes, aside from the aforementioned occasional rotation of the entire set, matched with an enormous red-brick backdrop. In contrast to the  energy of the choreography, the fight scenes are barely believable, at times perfunctory - too reliant on the strength of our imagination to fill in the details of, for example the strength of Porgy's grip around Crown's neck. I of course don't want to see anyone get hurt, but I guess it’s one of the pitfalls of great camera work is that you get to see things up close that might work better from a distance. 

I’d be remiss if I didn’t mention the music, but truth be told the music barely registered in the broadcast; perhaps that's a result of technical oversights in the particular auditorium I was in, or the placement of microphones in the recording. Either way a fantastic opportunity was missed to interrupt our visual field with momentary cuts to David Robertson and the Met orchestra. They're half the show, after all, and the broadcast could benefit from the added material.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580866257/media/2020/02/PBNC_1274a_rd3mqf.jpg){{% /md %}}

<figcaption>Kevin Short as Porgy in The Gershwins' "Porgy and Bess." Photo: Ken Howard / Met Opera.</figcaption>

</figure>

So yes, the Met's _Porgy_ is a mixed bag of yay’s and semi-nay’s—it's a hard opera to watch, and not only because of its libretto. The question of its relevance today is more complicated than that of most operas in the canon. The aspects of it that works are the ones that stem from the artform: an exceptional international cast of opera singers and the gale-force of a sixty-headed chorus. It's all the other non-operatic stuffs that makes a perfectly decent production like this one difficult to sit through. Yes the language is outdated, the black-and-white stereotypes laughable, it's implicitly and explicitly sexist, and racist against redheads (to that end "A redheaded woman" kills two stones with one aria) - but that is no threat to its relevance, unfortunately. _Unfortunate_ because this opera is in a class all on its own, as in...how else will mainstream opera celebrate black singers if we cancel _Porgy_?

> As several opera companies in Toronto attested to during their 2018-19 season: black Mimì works just as well as white Mimì.

It wasn't until the very late date of January 1955, under the auspices of the relatively progressive leadership of General Manager Rudolf Bing that an African-American artist sang a lead role at the Met for the first time (Marian Anderson, _Un ballo in maschera_). The Met's desire to shine a spotlight on such belated milestones brought about Black Voices at the Met, a historical exhibition concomitant with their first production of _Porgy_ in thirty years, an effort to "pay tribute to the great African American artists who have graced the Met stage". It's a bit awkward reading the Met's own account of how its Chairman in the 1930's, Otto Kahn, decided against giving this opera its world premiere at the Met on account of it being "too complicated and costly". 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580866271/media/2020/02/PBNC_1540a_jn5hp8.jpg){{% /md %}}

<figcaption>Denyce Graves as Maria and Janai Brugger as Clara in The Gershwins' "Porgy and Bess." Photo: Ken Howard / Met Opera.</figcaption>

</figure>

Nevertheless, it is a reminder that progressive thought is not always necessarily found in higher concentration in the well-educated opera-going public than in the general public, and even so, that thought doesn't always engender action. But that was then and the fortunes of black artists in opera are much better now, and it would be ludicrous to wholesale dismiss the Met's current intentions on account of its racist past. 

Nevertheless, as the Met looks back on the last 100 years of its black singers (the first appearance was in 1897, and inspired decades of minstrelsy), it's the next 100 years that is in question. What difficulties do black artists in opera today still face in booking roles that are historically white characters? Writing another all-black opera is not progress as far as I'm concerned; it only serves to emphasize the supposed otherness of these artists. 

As several opera companies in Toronto attested to during their 2018-19 season: black Mimì works just as well as white Mimì.