+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = "2017-10-15T18:37:00-04:00"
lastmod = "2017-10-15T21:07:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546392800/media/2019/01/sqVOTurandot.jpg"
primary_image_credit = "Amber Wagner (Turandot) & Sam Chung (The Emperor Altoum) in Turandot, Vancouver Opera, 2017. Photo: Tim Matheson."
publishDate = "2017-10-15T21:07:00-04:00"
related_articles = ["articles/talking-with-singers-othalie-graham.md", "articles/rohs-madama-butterfly-better-to-be-furious-than-bored.md", "articles/a-fascinating-marriage-of-art-forms-kayoi-komachi.md"]
related_companies = ["scene/companies/vancouver-opera.md"]
related_people = ["scene/people/amber-wagner.md", "scene/people/marianne-fiset.md", "scene/people/marcelo-puente.md"]
short_description = "Given the size of the Chinese community in Vancouver, tackling Turandot is not only an ambitious project, but a potentially controversial one. However VO dealt with the controversies head-on, talking extensively in the program about the accusations of &quot;Orientalism&quot; in the score, and how they wanted to address those for a modern audience, and how these kinds of dialogues will continue to inform productions for years to come."
slug = "a-grand-night-out-at-vancouver-operas-turandot"
title = "A grand night out at Vancouver Opera&#039;s Turandot"

+++
[Vancouver Opera](/scene/companies/vancouver-opera/)'s inaugural performance for the 2017-18 season is Puccini's [*Turandot*](https://www.vancouveropera.ca/Turandot). In an epic launch which will hopefully be setting the tone for the rest of the season, this production is grand on a scale you could only see in opera, an absolutely sumptuous feast for the eyes from beginning to end. 

Given the size of the Chinese community in Vancouver, tackling *Turandot* is not only an ambitious project, but a potentially controversial one. However VO dealt with the controversies head-on, talking extensively in the program about the accusations of "Orientalism" in the score, and how they wanted to address those for a modern audience, and how these kinds of dialogues will continue to inform productions for years to come. They also projected the surtitles in both English and Chinese, in what is a VO first.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508107261444/2017-10-16---Turandot_Amber-Wagner-Princess-Turandot%2C-Marcelo-Puente-Calaf.jpg.jpg)
<figcaption>Amber Wagner (Turandot) and Marcelo Puente (Calaf) in *Turandot*, Vancouver Opera, 2017. Photo: Tim Matheson.</figcaption>
</figure>

The production itself is incredibly lush, with a circular central set piece that is covered in gold and blood, and red circular set pieces and stylized beheaded heads on spikes. The scene opens with a huge chorus of fifty-two dressed in red grasping at the stark red lights, and crawling around the set in an undulating mass. The chorus was continuously pulsating with energy as they looked on in terror at the execution, and the effect was absolutely mesmerizing. About twenty minutes in I realized I'd stopped looking at the surtitles entirely because everything on stage was so visually captivating. Director/choreographer Renaud Doucet's staging was ambitious and dynamic. Aided by dancers, the chorus was used to the fullest extent in their pursuit of Liù, in their fear of Turandot, and as the masses of court attendants in the Imperial Palace. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508107303989/2017-10-16---Turandot_Calaf-Marcelo-Puente%2C-Ping-Pang%2C-Pong-by-Tim-Matheson.jpg.jpg)
<figcaption> in Turandot, Vancouver Opera, 2017. Photo: Tim Matheson.</figcaption>
</figure>

The ministers, Ping (Jonathan Beyer), Pang (Julius Ahn), and Pong (Joseph Hu) added the comedy to the evening, while managing to avoid the racial stereotypes that tend to plague these characters. They were a pleasure to watch onstage, and even had a dance routine in Act II that was light-hearted and very funny. 

The standout of the evening was tenor [Marcelo Puente](/scene/people/marcelo-puente/) in the role of Calaf. This is Puente's role debut as the besotted Prince, and his performance was absolutely breathtaking. "Nessun dorma", an aria that is performed so often and used as the background in so many TV shows and movies, was given new life by Puente in what easily has to be the best performance of the aria that I've ever heard. His voice was expressive and pure, and sounded effortless even at the very top of his range. He had barely finished the final "Vincerò!" when the audience roared with applause. I hope this role becomes a staple for Puente, as his performance was such a pleasure.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508107331011/2017-10-16---Turandot-by-Tim-Matheson-3.jpg.jpg)
<figcaption> in Turandot, Vancouver Opera, 2017. Photo: Tim Matheson.</figcaption>
</figure>

Sopanos [Marianne Fiset](/scene/people/marianne-fiset/) as Liù and [Amber Wagner](/scene/people/amber-wagner/) as Turandot also made their role debuts in the production. Fiset brought great emotional depth, particularly as she is tortured in Act III to reveal Calaf's name, while being pursued relentlessly by the desperate chorus. Wagner's Turandot was cold and cruel as she tells the riddles, but softens reluctantly as Calaf professes his love. Her final line "Il suo nome è...Amor!" was a beautiful and powerful moment as her voice soared above the orchestra.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1508107318780/2017-10-16---Turandot-by-Tim-Matheson.jpg.jpg)
<figcaption> in Turandot, Vancouver Opera, 2017. Photo: Tim Matheson.</figcaption>
</figure>

The only drawback of the show was the Emperor. With the massive stage, the Emperor was seated in a recessed alcove at the very furthest back of the stage in a beautiful throne, set far apart from the rest of the cast. Visually, it was stunning, but it made it very difficult to hear him, even without the orchestra playing. 

This production is one of the most grand that VO has put on in recent memory, and is an absolute must-see. The opening night audience jumped to its feet as soon as the curtain dropped in a standing ovation that lasted so long that the audience was still applauding after the bows were over and the curtain lowered again.

>[Turandot](https://www.vancouveropera.ca/Turandot) runs at Vancouver Opera through October 21. For details and ticket information, [click here.](https://www.vancouveropera.ca/Turandot)