+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-12T21:42:00-04:00"
lastmod = "2018-03-14T10:44:00-04:00"
preamble = "Described \"without exaggeration, as a perfect novel\", Adolfo Bioy Casares' [*The Invention of Morel*](https://www.longbeachopera.org/the-invention-of-morel#about) is adapted into an opera by librettist/director Jonathan Moore and composer Stewart Copeland (as in, the drummer and co-founder of The Police). The opera, based on Casares' futuristic story about love and questioning reality, had its first successful run at Chicago Opera Theater last year, and this month sees the second part of its co-world premiere at [Long Beach Opera (**March 17-25**)](https://www.longbeachopera.org/the-invention-of-morel#about). \n\nWe spoke with two singers from the cast of [*The Invention of Morel*](https://www.longbeachopera.org/the-invention-of-morel#about): tenor Nathan Granner, who sings the titular Morel, and soprano Jamie Chamberlin, who sings Faustine."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520904975050/IMG_7486.jpg.jpg"
primary_image_credit = "(l-r) Kimberly E. Jones as Dora, Nathan Granner as Morel, and Valerie Vinzant as Faustine in The Invention of Morel, Chicago Opera Theater, 2017. Photo: Liz Lauren."
publishDate = "2018-03-13T20:21:00-04:00"
related_articles = ["articles/twice-on-this-island.md","articles/dont-miss-the-love-potion.md","articles/psycho-meets-sartre-at-the-nigredo-hotel.md"]
short_description = "&quot;He is a super-genius who has created an invention that will change life as we know it. He is in obsessive love with Faustine. He has invited Faustine and the remaining characters (in the opera) to the island to woo Faustine. His gambit is to spend the rest of his days with her. ...which is kinda creepy on any level.&quot;"
slug = "a-futuristic-love-story-the-invention-of-morel"
title = "A futuristic love story: The Invention of Morel"
+++

## What do you think this story says about humans and their concept of "reality"?

**Nathan Granner**: Consider that this opera has a number of different timelines. Consider that at this point in our perception of humanity, science cannot rule out that we are a simulation. A simulation where we all must play our part. We must eat and drink. We must love, or we perish and cease to exist.

But what if that didn't have to be? What if our reality were different. Skewed by maybe just a few degrees. What if you could choose what your reality was, but in order to do so meant giving up part of our humanity? If the physical and emotive rules by which we co-exist, to a good or bad degree, were unnecessary would we remain human?

## What does Stewart Copeland' s music have to say about this story?

**Granner**: Copeland's music is to me at once viscerally driven and percussive as well as being lyrical and poignant. It has that dirt and grit of punk rock while having the sophistication of progressive contemporary music ... with a serious disjointedness of modern period music. It is a good blend of post-modernist sensibility.

This music in *The Invention of Morel* reflects all of the elements in the story. Also, like in [Tim Nolan's movie] *Memento*, scenes that are out of sequence in the timeline give you a real wrenching feeling. You, like the characters of The Fugitive and The Narrator, feel a little bit of the disorientation they feel. The interactive experience we look for now in today’s entertainment is written into the opera itself.

The machinery of the invention, love and attraction... Copeland fleshes out this story with the flair of a romantic composer, who writes music which informs the scene-work, just as much as it accompanies the voices.

I love the fact that we have a person who quite literally learned the art of writing pop songs and anthems for stadiums. Don't for a second think it was only Sir Gordon Sumner - aka Sting - who penned the music for The Police. They all were writing. I can hear the influences of The Police and progressive rock contemporaries in Copeland's music. It is fascinating really. It is all so very... fascinating.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1520986756148/KC6A0969.jpg.jpg)
<figcaption>(l-r) David Govertsen as Stoever, Barbara Landis as Duchess, Valerie Vinzant as Faustine, Nathan Granner as Morel, Kimberly E. Jones as Dora, and Scott Brunscheen as Alec/Ombrellieri in *The Invention of Morel*, Chicago Opera Theater, 2017. Photo: Liz Lauren.</figcaption>
</figure>

## Can you tell us a bit about your character? (no spoilers, please!)

**Granner**: My character, Morel, is your typical super-genius. I think of him as the superimposed id of Elon Musk, Steve Jobs, Dr. No (of Bond fame) and Robert Oppenheimer.

He is a super-genius who has created an invention that will change life as we know it. He is in obsessive love with Faustine. He has invited Faustine and the remaining characters (in the opera) to the island to woo Faustine. His gambit is to spend the rest of his days with her ...which is kinda creepy on any level.

**Jamie Chamberlin**: Faustine is the vehicle through which we see the obsession and insecurities of both Morel and The Fugitive reflected. She is their mirror. Much like the silent film *Pandora's Box*, which starred Louise Brooks (the muse for the character Faustine), in this opera, she is the blank slate onto which men cast their own projections. Those projections include their hopes, fears, and fantasies. 

In this sense, it can be a challenge as an actress. I have chosen to portray her not as she is merely seen by those around her, but rather as a fully fleshed out, complicated woman (all within the limited structure of the score and libretto of course!). In this way we draw attention to the idea of expectation versus reality. What is real? Who is this person to you and is that the same as the person they truly are? Or is the influence of your own expectation of yourself and the world around you clouding your vision? 

So in short, yes... Faustine, both in reality and fantasy is quite a complex character.

### Compared to all the works about myths and historical figures, why do you think futuristic stories are relatively rare among operas?

**Chamberlin**: In every art form, expansion takes time. Historically speaking, opera from the 17th century through most of the 20th century relied on tales of the distant past, or recent past at best. I think the industrial revolution needed to happen before these storytellers could even wrap their minds around anything "futuristic". With the onset of modernism, surrealism and science fiction, these tales have finally begun to emerge and take their place within the operatic canon.

It makes perfect sense to me that we now have a blank slate, where we can take a story, *The Invention of Morel*, written by Adolfo Bioy Casares in the 1940s, which is modern-surrealist, and apply it within the context of a contemporary piece of music (written by a rock 'n' roll superstar, no less) and it just works. We have entered an era where style and story goes into this melting pot with "the influence of the future on the past" to quote our Dr. Morel directly from Jonathan Moore's libretto. A new and exciting opera is created. It is fully immersive on every level, because it's not simply a futuristic tale, it's also science-fiction, surrealism and modernism, coupled with completely unique contemporary music. 

It's good to be an opera singer these days, and especially to be involved from the early stages of development as many of us have been with *The Invention of Morel*.

>Long Beach Opera's *The Invention of Morel* plays at the Beverly O'Neill Theater, Marcy 17-25. For details and tickets, [click here.](https://www.longbeachopera.org/the-invention-of-morel#about)
