+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-03-01T14:40:00+00:00"
lastmod = "2016-03-01T15:55:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456846771665/Covent-Garden-Station.jpg.jpg"
publishDate = "2016-03-01T15:45:00+00:00"
related_people = ["scene/people/maria-agresta.md"]
short_description = "When the average, non-opera-obsessed North American attends an opera, they come away with the tale that they&#039;ve seen La bohème or Aïda, and that&#039;s the end of it. They&#039;re not likely to tell their fellow, non-opera-obsessed friends that they saw &quot;Zeffirelli&#039;s Bohème&quot; or &quot;Tim Albery&#039;s Aïda&quot;. There&#039;s nothing maliciously ignorant about any of this. It&#039;s just not how North Americans generally understand the process of putting an opera onstage."
slug = "a-funny-thing-happened-on-the-way-to-the-opera"
title = "A funny thing happened on the way to the opera"
+++

In conversation with a pleasant Londoner today, we experienced a bit of mild cultural shock. After it came up that we were opera lovers, said Londoner asked if we had plans to catch anything at ENO or the Royal Opera House. We assured him that we did, and he wondered aloud what was currently up at Covent Garden. I'll paraphrase what he said:

"There's a revival on of *Traviater* [sic] at the moment, isn't there?"

And then,

"I've not got tickets myself; I've seen it about a dozen times at this point."

He was right; [currently at ROH](http://www.roh.org.uk/productions/la-traviata-by-richard-eyre) is Richard Eyre's [22-year old production](http://seenandheard-international.com/2015/05/richard-eyres-traviata-celebrates-21st-birthday/) of *La traviata*, starring Violettas [Maria Agresta](/scene/people/maria-agresta/) and [Nicole Cabell](/talking-with-singers-nicole-cabell/).

It wasn't the fact that his information was correct that gave us that mild cultural shock; it was the way he phrased it. A *revival*, he said. Not *La traviata*, not even *That Italian One*, but a *revival*. Granted, I don't know much about this Londonder other than his polite manners and smart sense of fashion, but I do know that he doesn't work in arts circles. 

I instantly compared his comment to almost all conversations I have with Canadians or Americans who aren't involved in operatic circles; the use of the word "revival" is almost obsolete as a descriptor for a live show on a big stage. Music theatre fans know "revival" to mean that their favourite show is coming back to theatres, and the more hardcore individuals will get excited about seeing a director's name attached to a current run of said favourite show. Yet, when we're talking about opera, the idea of a "production" is quite foreign.

When the average, non-opera-obsessed North American attends an opera, they come away with the tale that they've seen *La bohème* or *Aïda*, and that's the end of it. They're not likely to tell their fellow, non-opera-obsessed friends that they saw "Zeffirelli's *Bohème*" or "Tim Albery's *Aïda*". There's nothing maliciously ignorant about any of this. It's just not how North Americans generally understand the process of putting an opera onstage: an opera is what it is, and it often doesn't occur to the lay-listener that there's a director's influence at all, or that the "opera" really only exists as music, text, and sometimes a few stage directions from the composer.

Perhaps the business of producing opera is more familiar in Europe; I wouldn't be surprised if it were, considering the difference in sheer quantity between Western European countries and Canada, for example.

Take our Londoner's revival-savvy comment, and pair it with his second statement ("I've seen it about a dozen times at this point."), and that's something of which to take note. It's not likely that anywhere near the majority of London's population has seen "*Traviater*" a dozen times. Yet, if we met someone in Canada who didn't work in musical or operatic circles, but who had seen a specific production of a single opera multiple times, we'd assume him or her to be a hardcore fan. 

Wouldn't one also expect that a fan of that status would out him or herself immediately if opera came up accidentally in conversation? This gentleman did no such thing; perhaps it's because it didn't matter enough to him that we know he's an enormous opera lover, but perhaps it's also simply not the case.

The sample pool is much too small to really make any conclusions about opera's reception here in the UK. But we can say with confidence that in comparison to the opera chatter in Canada, this brief, small-talk-driven conversation we had with one man from London was notable enough to inspire this bit of written rambling.

>What do you think? Are we getting overly excited? Or have we found the first of many pleasant surprises as opera lovingv Canadians abroad? Let us know in the comments below!
