+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2018-10-21T12:36:00-04:00"
lastmod = "2018-10-21T21:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540156687491/sqTGradyPhoto-9143.jpg.jpg"
primary_image_credit = "Photo: Thomas Grady."
publishDate = "2018-10-21T21:05:00-04:00"
related_articles = ["articles/in-review-il-trittico-at-roh.md"]
related_companies = ["scene/companies/opera-omaha.md"]
related_people = ["scene/people/leah-partridge.md","scene/people/jonathan-burton.md","scene/people/alexander-elliott.md","scene/people/todd-thomas.md"]
short_description = "In the second act, it felt like Burton and Partridge were no longer holding back dramatically, and in their final confrontation during the play within a play, both singers delivered the most heart wrenching vocals of the opera. Their struggle was rife with emotional and physical violence, and predictably, it did not end well for Nedda or her lover, Silvio."
slug = "a-frighteningly-timeless-story-of-abuse-pagliacci"
title = "A frighteningly timeless story of abuse: Pagliacci"
+++

The storyline of *Pagliacci* is unfortunately just as realistic and relevant as when it premiered in 1892. Leoncavallo found his inspiration for the plot in a newspaper crime report, and he wouldn't have to look too hard to find similar cases of violence against women in a newspaper today. Sure the darker aspects of the story are surrounded by more lighthearted theatrical trappings, but at its core, the opera is less about clowns and more about the dangerous emotions of a jealous, abusive husband. Opera Omaha's production of *Pagliacci* delivered the classic contrast between the players' two worlds - the thin theatrical façade that hides their tumultuous emotions.

The stark and minimal production, which originated at [Welsh National Opera](/scene/companies/welsh-national-opera/), served as a neutral backdrop to the story. The colorful clothes, sets, and emotions of the players were on prominent display in the faded town square. The time period was unclear, perhaps intentionally, but the costumes seemed to hint at 1940s or 1950s. Even in their normal street clothes, the players stand out from the crowd with just a hint more color than the chorus' outfits. Everything seemed designed to focus in on the essential characters and their conflicts.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540156964058/TGradyPhoto-8880.jpg.jpg)
<figcaption>Leah Partridge (Nedda) and Todd Thomas (Tonio, right) in *Pagliacci*, Opera Omaha, 2018. Photo: Thomas Grady.</figcaption>
</figure>

The orchestra, led by Timothy Myers, created the musical atmosphere of Leoncavallo's opera, captivating the audience before the prologue even began. The chorus, under the direction of Sean Kelly, seemed to struggle to keep up with the orchestra at the beginning of the opera, but this issue seemed to work itself out as the scene progressed. I found myself wishing that the chorus would interact with the players more throughout the opera. Their musical discomfort seemed to overshadow the crucial part the chorus has to play as the onstage audience which was unfortunate.

The inclusion of four circus performers - Jack Austin, Jacob D'Eustachio, Leonid Filatov, and Brian Koenig - was a wonderful addition to the otherwise small troupe of players. They displayed a variety of charming talents like hula hooping and stilt walking as well as more awe inspiring feats like knife juggling and spitting fire. Their antics added extra layers of fun to some of the slower moments of the opera. The four men were equally talented actors, and their reactions to the main characters enhanced the drama. Without them, Beppe would have been the only sane person in the troupe!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540156971399/TGradyPhoto-02550.jpg.jpg)
<figcaption>Leah Partridge (Nedda) and Todd Thomas (Tonio) in *Pagliacci*, Opera Omaha, 2018. Photo: Thomas Grady.</figcaption>
</figure>

[Todd Thomas](/scene/people/todd-thomas/) gave a commanding performance as the vindictive Tonio. The baritone displayed his vocal versatility in the opening prologue, breaking the fourth wall and drawing the audience into the story before the curtain rises. Tonio is a complex character, and Thomas' dramatic portrayal was nuanced, prompting both pity and anger. This production decided to switch out Tonio's hunchback deformity for a simple leg brace and cane. This ended up undermining the concept of Tonio being deformed on both the outside and the inside. Thomas looked fairly normal with a slight limp at most, so Nedda's repulsion seemed completely unrelated to his appearance. While I don't necessarily agree with the elimination of Tonio's deformity, it did change the audiences' interpretation of his predatory advances and subsequent rage towards Nedda. Without his physical hang ups, his character is less sympathetic in some ways. Tonio represents a fear that many women will find familiar - rejection of unwanted male interest resulting in a violent end. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540156977588/TGradyPhoto-02416copy.jpg.jpg)
<figcaption>A scene from *Pagliacci*, Opera Omaha, 2018. Photo: Thomas Grady.</figcaption>
</figure>

[Leah Partridge](/scene/people/leah-partridge/) sang the role of Nedda, a trapped and lonely woman. Partridge was difficult to hear over the orchestra and her male counterparts at times, particularly in her lower registers, but her higher, coloratura lines were bright and clear. The soprano flourished during her love duet with Silvio, bringing all the lyric beauty and heartbreak of their relationship to life through her voice. Some of the staging decisions worked against Partridge's dramatic performance. Nedda's physical confrontation with Tonio was clumsy and lacked intensity, and the whip was left out of the fight entirely. Her loving embraces with Silvio were undermined by their awkward positioning on the bench and the unnecessary removal of her panty hose as she sang. Despite these distractions, Partridge managed to portray Nedda with grace and vitality. 

Nedda is the sole female character of the opera, and this only serves to highlight the isolated life she endures. She is trapped in an abusive marriage, threatened by the prospect of sexual assault from her coworker, and engaging in an affair despite her fears. None of the men in her life can fully understand the treacherous path she has to tread. Even Silvio, sung by [Alexander Elliott](/scene/people/alexander-elliott/) with equal parts charm and desperation, does not grasp the potential danger in his plea for her to run away with him. He envisions the happy future they could have together, but he fails to take the risks involved seriously. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540156986605/TGradyPhoto-9071.jpg.jpg)
<figcaption> in *Pagliacci*, Opera Omaha, 2018. Photo: Thomas Grady.</figcaption>
</figure>

Beppe, portrayed by [Jason Ferrante](/scene/people/jason-ferrante/), represents the only male character that is sympathetic toward Nedda and without ulterior motives. Ferrante's light tenor voice was also difficult to hear in the theater at times, but his silvery serenade in the second act was breathtaking and clear. In the final confrontation, Beppe seems to be the only one with any sense onstage, but his efforts to intercede on Nedda's behalf are unsuccessful.

Tenor [Jonathan Burton](/scene/people/jonathan-burton/)'s performance was vocally powerful, but his Canio wasn't menacing enough in the first act for me. The character's controlling, abusive nature should be bubbling under his performer's façade from the start, but his rage didn't reach a simmer until he catches Nedda with her lover toward the end of the act. This lack of groundwork just made it feel like his sudden shift to jealous maniac came out of nowhere when it should be clear that Canio has always been a constant ticking time bomb ready to go off at his wife.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540156996732/TGradyPhoto-9367.jpg.jpg)
<figcaption> in *Pagliacci*, Opera Omaha, 2018. Photo: Thomas Grady.</figcaption>
</figure>

Burton sang the famous aria, "Vesti la giubba," with beautiful ease, smearing his face with makeup and swigging booze to accent his impending breakdown. This felt like the true turning point of his portrayal. This was the unhinged mess of a man I had been waiting for!

In the second act, it felt like Burton and Partridge were no longer holding back dramatically, and in their final confrontation during the play within a play, both singers delivered the most heart wrenching vocals of the opera. Their struggle was rife with emotional and physical violence, and predictably, it did not end well for Nedda or her lover, Silvio. The ending of the opera felt a bit anticlimactic, all staging coming to a strange standstill after Canio commits double homicide in front of a crowd. It was as if everyone onstage was too shocked to react, and Canio was left hovering over his victims indecisively. He's had his revenge, but what now?

At its core *Pagliacci* tells a story that is still all too common. It is about a woman trapped in abusive relationship, and the question always comes up: Why doesn't she leave? While the methods are theatrical, the end result of Pagliacci is sadly the same as many cases in real life. When she finally tries to leave her abuser, the situation turns from violent to deadly. Leoncavallo may have written this opera over a hundred years ago, but the themes continue to be relevant to this day. When it comes to the disturbing reality of violence against women, I have to agree with the final line of the opera: "The comedy is over."
