+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-14T12:15:00-04:00"
lastmod = "2017-10-16T10:21:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507997888626/2017-10-14---Mirror-Werewolves.jpg.jpg"
publishDate = "2017-10-15T20:56:00-04:00"
related_articles = ["articles/things-i-want-to-see-la-zombiata.md","articles/gareth-matteys-belladonna-is-unashamedly-queer.md"]
related_companies = ["scene/companies/wholetone-opera.md"]
short_description = "&quot;Lycanthropy is such a great metaphor for sexual fluidity,&quot; says co-librettist Teri Kowiak. &quot;Our werewolf is not human when in human form, nor is he a wolf when he is in wolf form. He is always a werewolf, no matter how he appears at a specific time.&quot;"
slug = "a-fiercely-queer-opera-for-halloween"
title = "A &quot;fiercely queer opera&quot; for Halloween"
+++

This Halloween, WholeTone Opera - the company that brought you *La Zombiata* - presents [*The Werewolf*](https://www.eventbrite.com/e/wholetone-opera-the-rockwell-present-the-werewolf-tickets-36843876025), a "freshly transformed, fiercely queer opera". Adapted from Louise Bertin's 1827 melodrama, *Le loup-garou*, and inspired by the early 20th century's silent films, *The Werewolf* features a modernized libretto by J. Deschene and Teri Kowiak that keeps with WTO's mission to better represent the LGBTQIA community on operatic stages.

"[Lycanthropy](https://en.wikipedia.org/wiki/Clinical_lycanthropy) is such a great metaphor for sexual fluidity," says co-librettist Teri Kowiak. "Our werewolf is not human when in human form, nor is he a wolf when he is in wolf form. He is always a werewolf, no matter how he appears at a specific time."

[*The Werewolf* runs **October 20-31**](https://www.eventbrite.com/e/wholetone-opera-the-rockwell-present-the-werewolf-tickets-36843876025) at The Rockwell, Davis Square, Somerville, MA (including late-night showings on October 21st and 28th where you can come in costume). We spoke with Nora Maynard, Artistic Director of WholeTone Opera, about their latest operatic adventure.

## What about *Le Loup-garou* do you find translates well into WTO's *The Werewolf*?

Although we were very excited to find an original werewolf opera written by a woman, Louise Bertin's 1827 opera did not originally embody as many of the feminist, progressive attributes WholeTone Opera insists on including in our productions. As our stage director, J. Deschene wrote for TheaterArtLife, "Right away, it was clear that a few things needed to happen.  First, unless you’re counting werewolves (and even then, not really), the opera wasn’t doing much to represent the underrepresented.  Second, Alice needed some agency of her own.  Our audiences would simply not be able to take the helpless, hand-wringy, 19th-century maiden seriously.  Finally, and perhaps most obviously, a show called *The Werewolf* was going to need a real werewolf somewhere within it.  Easy, right?" Riiiiight...

 What the original show gave us, however, was an opera full of character-oriented scenes. This gave us an opportunity for far more character development than one usually experiences in an opera under 90min. Once we pared it down to its skeleton, we also found some excellent, lyrical vocal and orchestral writing to lay our new story upon. What we now have on our hands is a very different sort of production with both the allure and the aura of danger one finds in a beautiful but only partially domesticated animal, made much more feral under our influence.

## What does it mean for an opera to be "fiercely queer?"

We are proud of the fact that almost all of the main characters in this story identify as queer or gay - at least by the end of the opera. Some of them struggle with discovering and revealing their closeted identities more than others. One character is casually open about being queer, which is even more rare to see on the stage. I love when queer characters are as unabashedly comfortable in their identities, as I, a queer gender fluid person, attempt to be. It takes quite a bit of bravery and fierceness of will to live authentically. Four out of our five main characters make huge strides in that regard through the course of the show. It is a beautiful thing to watch them grow into their true forms.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507997908628/2017-10-14---The-Werewolf.jpg.jpg)
</figure>

## What do you think the opera industry gains from from a new focus on female, femme, and non-binary composers?

First of all, the industry might have a slim chance to survive if it responds to the fact that the newer generation of potential audience members wants to see productions that are relevant to its interests. Of all the things that people might claim the millennial generation has "killed", we might as well include opera. As told by events such as the bankruptcy of New York City Opera in 2013, it is clearly not easy to be financially viable as an opera company these days. Most high level houses have chosen to stick to the safe, secure route of producing only well-known operas which draw loyal patrons. Of course almost all of these works were written by men, as with most classical music in general. According to [*Huff Post*](https://www.huffingtonpost.com/lydia-kontos/women-in-the-arts-its-tim_b_14522038.html), "women composers accounted for only 1.8 percent of the total pieces performed in the 2014-2015 concert season among the top 22 American orchestras." Not only that, but as mentioned in [*The Guardian*](https://www.theguardian.com/music/2017/sep/14/opera-needs-to-tackle-its-biases-the-future-of-the-industry-depends-on-it?CMP=share_btn_fb), many of these operas have plots that are often misogynistic as well as racist. Powerful female characters are all but absent, except for the occasional villain.  

Rather than choosing the conservative path to bring in patrons who have been loyal for decades, opera houses could instead produce works that appeal to younger, statistically-more-likely-to-be-liberal audiences. Contemporary operas that are written by women, femmes, and non-binary people are more likely to authentically represent the experiences of non-cis-male characters, making them more believable and relatable to younger audiences. Indeed, attendance is already up for more contemporary, progressive opera. Although admitting that most of the operas mentioned were written by men and over-represent cis-male narratives, [*The New Yorker*](https://www.newyorker.com/culture/cultural-comment/the-decline-of-opera-queens-and-the-rise-of-gay-opera) is convinced that we are in the midst of a growing wave of gay and queer opera. I'm happy to draw the conclusion that these stories must therefore be more interesting and relevant to the rising generation of opera-goers. 

The second thing it could gain is its conscience. In our world it is awfully difficult to do almost anything professionally that works against systematic misogyny and/or racism. Opera houses seem to be particularly besieged by this problem. Luckily, there are some newer opera companies and orchestras are demonstrating a rich sense of social responsibility, and for that I applaud them. The Refugee Orchestra Project, conceived by Lidiya Yankovskaya, is one excellent example. MetroWest Opera recently created "La Femme Boheme"; a production of the classic Puccini work featuring an all-femme cast. Kim Feldkamp is doing amazing work in queer & progressive opera with OperaRox, NYC .

At WTO we see the creation of progressive works as the only viable option since it is our societal responsibility to actively work against systems of privilege. One way we are attempting this is by featuring composers who are more marginalized. We also recognize the lack of female, femme, and non-binary presence on all sides of the stage, from actors to stage directors to set designers and more. We feel called to make sure that at every level, our company is working to empower women and people of diverse identities. As artistic director of WTO, I only hope that we will continue to discover how to further our goals to that end. And there is hope! But we must rise with the tide.

>For details and ticket information about WholeTone Opera's *The Werewolf*, follow our box office links below.
