+++
author = ["authors/john-beckett.md"]
categories = "Review"
date = "2017-10-27T14:18:00-04:00"
lastmod = "2017-10-27T17:25:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129203081/2017-10-27---ENO-1718-Rodelinda---Juan-Sancho%2C-Tim-Mead-Jane-Hobson.jpg.jpg"
primary_image_credit = "Juan Sancho (Grimoaldo) and Tim Mead (Bertarido) in Rodelinda, ENO, 2017. Photo: Jane Hobson."
publishDate = "2017-10-27T17:25:00-04:00"
related_articles = ["articles/in-review-partenope-at-eno.md","articles/laughing-out-loud-the-barber-of-seville-at-eno.md","articles/opera-is-artifice-giulio-cesares-conquest-of-houston.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/tim-mead.md","scene/people/rebecca-evans.md","scene/people/christopher-lowrey.md","scene/people/juan-sancho.md"]
short_description = "While not a total work of feminist theatre, I do like seeing operas from the 18th century where women are shown as strong-willed characters in control of their own destinies and not being controlled by men. In fact, the plot is driven by how much the other characters of the opera need Rodelinda."
slug = "a-fierce-mob-wife-rodelinda-at-eno"
title = "A fierce mob wife: Rodelinda at ENO"
+++

This week in fierce opera women: Handel's [*Rodelinda*](https://www.eno.org/whats-on/rodelinda/) opened at English National Opera last night. While not a total work of feminist theatre, I do like seeing operas from the 18th century where women are shown as strong-willed characters in control of their own destinies and not being controlled by men. In fact, the plot is driven by how much the other characters of the opera need Rodelinda - she, being the queen and mother to the heir of Milan in this modernized production, is in possession of so much political power that the the people around her have to fight for her favor just to stay afloat.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129227540/2017-10-27---ENO-1718-Rodelinda---Matt-Casey%2C-Rebecca-Evans%2C-Tim-Mead%2C-Juan-Sancho-Jane-Hobson.jpg.jpg)
<figcaption>Matt Casey, Rebecca Evans, Tim Mead, and Juan Sancho in *Rodelinda*, ENO, 2017. Photo: Jane Hobson.</figcaption>
</figure>

Concrete walls and surveillance cameras set the scene for this revival production by Richard Jones, set in Mussolini's Italy. The connections between characters were threaded by the tattoos displayed on their bodies - as alliances changed, the ink remained permanent. The stage was divided into sections so we could peer into different rooms at once, which means that in the long *da capo* arias there was almost always something for the eye to catch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129240861/2017-10-27---ENO-1718-Rodelinda---Christopher-Lowrey%2C-Rebecca-Evans%2C-Neal-Davies%2C-Juan-Sancho-c-Jane-Hobson.jpg.jpg)
<figcaption>Christopher Lowrey, Rebecca Evans, Neal Davies, and Juan Sancho in *Rodelinda*, ENO, 2017. Photo: Jane Hobson.</figcaption>
</figure>

[Rebecca Evans](/scene/people/rebecca-evans/) was lovely as the title role which requires a heavy amount of stamina, navigating the very difficult passages that give a sense of power and true purpose to Rodelinda. It was exciting to see Rodelinda as a fierce mob wife, and it made me hopeful that a composer might be inspired to write an opera adaptation of the hit reality television show, "Mob Wives."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129252822/2017-10-27---ENO-1718-Rodelinda---Christopher-Lowrey%2C-Tim-Mead-1--Jane-Hobson.jpg.jpg)
<figcaption>Christopher Lowrey and Tim Mead in *Rodelinda*, ENO, 2017. Photo: Jane Hobson.</figcaption>
</figure>

The countertenor [Tim Mead](/scene/people/tim-mead/) sang Bertarido with elegance and grace making the exiled king a noble and sane man, winning the audience on his side with the beauty of his voice. The countertenor singing was incredibly strong, with [Christopher Lowrey](/scene/people/christopher-lowrey/) singing alongside Mead as Unulfo. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129271960/2017-10-27---ENO-1718-Rodelinda---Juan-Sancho-2-Jane-Hobson.jpg.jpg)
<figcaption>Juan Sancho in *Rodelinda*, ENO, 2017. Photo: Jane Hobson.</figcaption>
</figure>

The graciousness of Bertarido was a stark contrast to [Juan Sancho](/scene/people/juan-sancho/)'s Grimoaldo, whose desperation to hold onto his kingdom intensified throughout the night. While Susan Bickley's Eduige was very well sung, her voice seemed to be wasted on a role with not many impressive arias and a character that had little to do with the action of the story. Matt Casey was a scene stealer in the silent role of Flavio, the son of Bertarido and Rodelinda. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129285390/2017-10-27---ENO-1718-Rodelinda---Juan-Sancho%2C-Rebecca-Evans%2C-Tim-Mead%2C-Neal-Davies-Jane-Hobson.jpg.jpg)
<figcaption>Juan Sancho, Rebecca Evans, Tim Mead, and Neal Davies in *Rodelinda*, ENO, 2017. Photo: Jane Hobson.</figcaption>
</figure>

Under Christian Curnyn, the orchestra played stylishly and with an energy that breathed life into the already timeless music of Handel. Like the rest of Italian opera at this time, all of the arias are written into pre-existing tropes - you have your fast coloratura aria, your aria written in unison with the strings, your aria that has an obbligato for a wind instrument, maybe a lament thrown into the mix as well. The ENO orchestra played with a great variety and with an array of colours, making each number interesting and alive. Perhaps the most stunning number in the entire opera is the duet at the end of the second act, "Io t'abbraccio."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509129297100/2017-10-27---ENO-1718-Rodelinda---Rebecca-Evans%2C-Tim-Mead%2C-Juan-Sancho-Jane-Hobson.jpg.jpg)
<figcaption>Rebecca Evans, Tim Mead, and Juan Sancho in *Rodelinda*, ENO, 2017. Photo: Jane Hobson.</figcaption>
</figure>

You can see this master work by Handel at the London Coliseum until November 15.

>For details and ticket information about ENO's [Rodelinda](https://www.eno.org/whats-on/rodelinda/), follow our box office links below.
