+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = "2017-10-27T11:39:00-04:00"
lastmod = "2017-10-27T14:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509128537321/2017-10-27---KayoiKomachi_HeatherPawseyAsKomachi_photoTrevanWong_6492.jpg.jpg"
primary_image_credit = "Soprano Heather Pawsey. Photo by Trevan Wong."
publishDate = "2017-10-27T14:24:00-04:00"
related_articles = ["articles/a-grand-night-out-at-vancouver-operas-turandot.md","articles/tarrare-the-freak-i-just-want-to-be-full.md"]
short_description = "In traditional Noh, there is far less in terms of story and action than you would expect in a Western-style play or opera. So much of the story is often based in metaphor, and the performers, rather than acting out a series of events, are conveying the essence of a story instead of enacting it."
slug = "a-fascinating-marriage-of-art-forms-kayoi-komachi"
title = "&quot;A fascinating marriage of art forms&quot;: Kayoi Komachi"
+++

[*Kayoi Komachi* (*Komachi Visited*)](http://www.tomoearts.org/Performances/TomoePerformancesKayoi.htm) is billed as a Noh Chamber Opera, blending the styles of Japanese Noh Drama with Western opera onto a Canadian stage. This production contained different elements of both styles, bringing together performers with extensive backgrounds in either Noh or Opera, a chamber orchestra of both Western and Japanese instruments, and text sung in both Japanese and English. 

In traditional Noh, there is far less in terms of story and action than you would expect in a Western-style play or opera. So much of the story is often based in metaphor, and the performers, rather than acting out a series of events, are conveying the essence of a story instead of enacting it. There's little in terms of sets or props, dialogue is sparse, and there are frequent moments of total silence in the score. Compared with the high drama, elaborate sets and costumes, and sweeping dramatizations in Western opera, it's hard to imagine how the two could be compatible, and yet *Kayoi Komachi* does this almost seamlessly. 

The chorus (or "Ji") in Noh is similar to a Greek chorus, in that they are not characters, but narrators that often underscore the dialogue of the Principals, or sing for the Principal characters. Kayoi's chorus was comprised of two opera singers; tenor Joseph Bulman, and bass-baritone Peter Monaghan, and two Noh actors; Muraoka Kiyomi and Kashiwazaki Mayuko. The score, while containing elements of Western and Japanese music was reminiscent of modernist tonality, with dissonant harmonies that lended an otherworldly atmosphere to the score. Bulman and Monaghan brought amazing precision and artistry to a phenomenally challenging score, bringing the dense harmonies to life with consummate skill. Muraoka and Kashiwazaki were intense and powerful, blending the darker Noh singing style with their opera counterparts in a way that added a compelling depth and texture to the sound. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509128491965/2017-10-27---YamaiTsunao__NohNoMask.jpg.jpg)
<figcaption>Noh actor Yamai Tsunao. Photo: courtesy of Tomoe Arts.</figcaption>
</figure>

The three principals of the production; Noh actor Yamai Tsunao, soprano Heather Pawsey, and mezzo-soprano Melanie Adams were subtle and engaging in their depictions of their characters. As an audience member who is used to Western opera, you have to reset your expectations in watching this production. The story, which was over an hour, would take less than 5 minutes in a traditional drama. There is very little movement, a great deal of silence, and very little text. And yet, because of the subtlety, every movement becomes imbued with significance. When Yamai took the stage, he had moments of amazingly fluid dance, and moments of stillness that were incredibly captivating. As the spirit of Fukasa, the dead lover of Komachi, Yamai's performance was haunting in its nuance, and the moment where he and Komachi (Pawsey) finally sing a single line in the same language was striking in its contrast, and a beautiful moment to bring the parted lovers together. Likewise when Komachi (Pawsey) attempts to reach out to the spirit of Fukasa (Yamai), the small gesture is full of longing and sadness. 

*Kayoi Komachi* was a fascinating marriage of art forms that would typically stand in such stark contrast to each other. In taking away so many elements of traditional opera, you're left with a beautiful story, engaging music, and a production that will make you rethink what opera can be.

>Kayoi Komachi runs through October 28 at The Cultch Historic Theatre in Vancouver. For details and ticket information, [click here.](http://www.tomoearts.org/Performances/TomoePerformancesKayoi.htm)
