+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-01T13:17:00+00:00"
lastmod = "2017-02-06T09:55:00+00:00"
postamble = "Newbies (or near-newbies), tell us about your first operatic experience! What did you like? What had you bored? Let us know in the comments below."
preamble = "We love hearing from people who have attended their first opera. We also love when we get questions about opera-going etiquette, what sort of homework should be done before the show, and how long the average opera is. Since opera newbies are the best kind of people, we figured it was time to compile a list of frequently asked questions, tailored to operatic first-timers. \n\nPhoto: [Rolf Venema](https://www.flickr.com/photos/xrustypicturesx/4996192549/in/photolist-8BuMYR-6okjAW-rrv51P-5RNZrj-9SScHJ-7GZn1X-WDkhk-kjUazw-9iKHnC-oFHtZN-4PphaY-6bbLCt-ni4p7x-jQXvSs-cfqXg9-5hMJZq-jDdzFn-gPWyk5-g9XfMJ-7Hg5UM-6zPWT2-7pKJqA-8SZXs2-bBqoSf-oexbpz-byMTAY-9nYSsY-aooe1H-acx2uN-bdgTu-8eH99z-8NTXwY-59a8bq-5LxBe-pUNgwk-7EgLYm-525CEw-dwf1eH-qatzqU-bpZtvb-cHYebf-e8NXbV-7RHyAD-8ntAXt-aj2MmC-8yeyru-ap5mbE-gsbPN4-dqSe8A-6hQoHj) via [Flickr](https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485957539586/2017-02-01---FAQ.jpg.jpg"
publishDate = "2017-02-06T09:06:00+00:00"
related_articles = ["articles/back-to-school-opera-a-practical-glossary.md", "articles/tales-from-stage-management.md", "articles/shades-of-opera-how-to-tell-your-buffo-from-your-bel-canto.md", "articles/goks-divas-solid-picks-despite-the-packaging.md"]
short_description = "One word of advice: if you spend the opera wondering how long it&#039;s going to be, that opera will certainly feel pretty long. Bring a bottle of water, accept that most operas are a bit longer than the average movie, and let yourself get sucked in."
slug = "a-faq-checklist-for-opera-newbies"
title = "A FAQ checklist for opera newbies"

+++
## Do I need to dress up?

It's a night out, so don't be a slob. There's no need for an evening gown or a tuxedo, but good shoes and a nice jacket go a long way. Comfort is key, especially when you're sitting, so don't be a hero with those really tight pants.

>If you're looking for something in English, there's a higher chance you'll hear something more modern (except if it's by people named Handel or Purcell).

## How do I choose which opera to see?

Of course, that depends on your taste. Puccini is great for well-paced drama and totally beautiful music. Rossini, Donizetti, and Bellini all offer some vocal fireworks; Verdi does too, but the stories tend to be a bit meatier.

Mozart is older, so it may sound a bit more contained, but if there's an option to see a _Don Giovanni_ or _Le nozze di Figaro_, you won't be disappointed.

Wagner is long, sure; but in our experience, it's rarely boring.

Bizet's _Carmen_ has the Toreador Song in it, and a few other famous tunes.

If you're looking for something in English, there's a higher chance you'll hear something more modern (except if it's by people named Handel or Purcell). We're huge fans of Britten's operas, and it might be a refreshing surprise to try out something by a North American composer, like operas by John Adams or Kevin Puts or John Estacio.

## What if I don't speak the language?

That's alright! Most opera houses offer translated surtitles. If you want a head start on the plot, you can do a Wikipedia search for the opera and jump to "synopsis". Even operas in English come with English surtitles, since the text can be tricky to understand when it's sung.

>If you're not sure if you should clap or not, take a cue from those around you instead of initiating spontaneous applause.

## Is the opera really long?

At most major opera houses, the night lasts for about three hours, usually including at least one intermission. Puccini's operas are a bit shorter than average, and Wagner operas are generally the long-hauls, anywhere from 3.5-5 hours long. _Le nozze di Figaro_ can be pretty lengthy, depending on how much they cut, and _Les contes d'Hoffmann_ is a bit of a beast. Classics like _Carmen_, _La traviata_, _Don Giovanni_, and _La bohème_ clock in under 3 hours.

Most major opera companies list an approximate duration of their shows on their websites, if you want to be exact about it.

One word of advice: if you spend the opera wondering how long it's going to be, that opera will certainly feel pretty long. Bring a bottle of water, accept that most operas are a bit longer than the average movie, and let yourself get sucked in.

## Why are people clapping in the middle of the show?

Audiences may clap after a musical moment that's well-known and/or well-sung. If you're not sure if you should clap or not, take a cue from those around you instead of initiating spontaneous applause.

## What should I be listening for?

The big difference between an opera and a play is that the music of an opera enhances - even changes - the meaning of the words. Composers like Wagner, Strauss, even Verdi use things like _leitmotifs_, which are musical themes that hold meaning. They can refer to a certain character or event in the opera, and composers can use these motifs to foreshadow the story. Same deal as in the _Star Wars_ soundtrack.

>Honestly, whatever you hear is what you're meant to hear.

Listening to the singers is just as fun. Any time they sing something really high or really low, be aware that it takes extraordinary technique to do so. Some singers are excellent at spitting out words faster than lightnight, and some singers have impressive lung power. Remember, opera is an acoustic art, so when a singer cuts over a 60-piece orchestra, they're doing it _au naturel_. Taking note of the different skills each singer brings to the stage is a fun, engrossing exercise.

Finally, there's often a form or recipe to an opera. When they write arias (solos), composers like Verdi, Rossini, and Donizetti often use a system of recitative > slow part > recitative/filler > fast part. Mozart tends to go from _secco recitative_ (where the singer is basically speaking, with just a piano or harpsichord playing along), to _accompanied recitative_, which is still speech-like, but with a full orchestra, to full-on aria.

With later composers like Wagner, Strauss, and Britten, the arias are more closely knitted into the overall sound of the opera; compared to Donizetti, where it's obvious when an aria is done, Wagner writes in what's called "through composed" form, where there's no obvious beginning or ending to a solo moment.

Honestly, whatever you hear is what you're meant to hear. If you miss a _leitmotif_, you won't be in the dark. Remember, opera isn't just music; the sets and costumes can be just as impressive as the singing, and if that's what you take away from your opera experience, awesome.