+++
author = ["authors/blanche-isral.md"]
categories = "Review"
date = "2017-09-16T16:56:00-04:00"
lastmod = "2017-09-17T13:23:00-04:00"
preamble = "Main image: Canadian Jessica Strong (Vanessa) and Barbara Zechmeister (the Old Baroness; on floor facing away) in *Vanessa*, Oper Frankfurt, 2017. Photo: Barbara Aumüller."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505666756073/2017-09-17---square---vanessa_2017-18_barbara_aumueller_07.jpg.jpg"
publishDate = "2017-09-17T12:46:00-04:00"
related_articles = ["articles/in-review-il-trovatore-at-oper-frankfurt.md","articles/the-future-of-opera-is-indie.md","articles/persona-and-the-sounds-of-silence.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/jessica-strong.md","scene/people/jenny-carlstedt.md"]
short_description = "Thoma presents the trio of women as three generations of the same person: Erika, the Baroness and Vanessa herself are all one immortal woman, eternally alone and suffering, stuck in time forever and unable to move forward. The Baroness embodies Vanessa&#039;s future as a bitter widow, while her niece Erika represents her past as a hopeful, beautiful, innocent young girl. As Erika laments, &quot;Sometimes I am her niece/But mostly her shadow&quot;."
slug = "a-dreamy-psychological-thriller-vanessa-at-oper-frankfurt"
title = "A dreamy psychological thriller: Vanessa at Oper Frankfurt"
+++

Three generations of almost identical women await the [Oper Frankfurt](/scene/companies/opera-frankfurt/) audience as they find their seats for Samuel Barber's [*Vanessa*](http://www.oper-frankfurt.de/en/season-calendar/vanessa/?id_datum=892). Frozen in time, they are behind a translucent scrim, seated separately and each wrapped up in their own world. Even after conductor Rasmus Baumann reaches the podium and after the clapping dies down, they remain frozen, this time joined by the audience, for another full minute. Further emphasizing Vanessa's 20-year wait, a very slow and gradual fade of lights leads into the beginning of the opera.

This production of *Vanessa* directed by Katharina Thoma, premiered in 2009 at Swedish company Malmö Opera and first brought to Frankfurt in 2012, is a psychological exploration of containment and twisted relationships. Thoma presents the trio of women as three generations of the same person: Erika, the Baroness and Vanessa herself are all one immortal woman, eternally alone and suffering, stuck in time forever and unable to move forward. The Baroness embodies Vanessa's future as a bitter widow, while her niece Erika represents her past as a hopeful, beautiful, innocent young girl. As Erika laments, "Sometimes I am her niece/But mostly her shadow". The three are nearly identical in appearance and temperament. The final fugue-like quintet, one of the most stunning moment of the opera, highlights the endless and inevitable cyclicality of their lives. Erika attempts to rebel against this stifling cycle by using the cold to put an end to her pregnancy, before closing herself up in the piano like a coffin for her innocence - "the end of my youth". 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505666517004/2017-09-17---vanessa_2017-18_barbara_aumueller_06.jpg.jpg)<figcaption>Anatol (Toby Spence) and Erika (Jenny Carlstedt) in Vanessa, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

But what started this decades-long cycle? As a young Canadian urbanite, I am always quick to notice an all-white cast. But this cast was so snow white and Aryan that it got me thinking, are the characters actually all meant to be related? And Thoma seems to have gone there. Menotti's libretto hints at incest from the very beginning, quoting the story of Oedipus the King on several occasions, as American music scholar James Keller lays out in [his interpretation](http://www.santafenewmexican.com/pasatiempo/columns/listen_up/in-the-family-way-pondering-vanessa/article_d118b239-ac91-5ee5-82b5-5a0c5990c91f.html). Keller hypothesizes that Vanessa focuses on a single act of incest between Erika and Anatol Jr., Vanessa's estranged illegitimate son (and therefore Erika's cousin, or perhaps even her brother if some lying has taken place), to the scorn of her grandmother the Baroness. 

But Thoma takes it even further than just that one incestuous act: she lays hints that Anatol Sr. himself, Vanessa's former lover, is also the Baroness's estranged son, and therefore Vanessa's brother. (To elaborate: this would mean that twenty years ago, Vanessa had an incestuous relationship with her brother, Anatol, and together they had a son, Anatol Jr. After impregnating Vanessa for a second time, Anatol Sr. abandons her, taking their first-born son with him. Vanessa's "niece", Erika, is really the product of that second pregnancy by Anatol Sr. The Old Baroness is appalled by this and refuses to talk her daughter. Now, decades later, with Anatol Sr. dead, their son has come back to find his estranged mother, and quickly falls in love with and impregnates Erika, who is in fact his sister. When the Baroness finds out about this, she violently shuns Erika as well. After being rebuked by Erika, Anatol Sr. marries his own mother, Vanessa. You still with me?) 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505666567826/2017-09-17---vanessa_2017-18_barbara_aumueller_05.jpg.jpg)
<figcaption>Jessica Strong, centre, as a Vanessa clinging to appearances to conceal her twisted family secrets. *Vanessa*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

The image of Vanessa holding the hands of both Anatol Sr.'s spectre and Anatol Jr. at the same time links them: "He sent me his younger self". It is a powerful interpretation, and one that works easily within Gian Carlo Menotti's libretto, which is truly an onion to be peeled, as are the brilliant libretti of many of his own operas. ([The University of Toronto Faculty of Opera’s double-bill presentation of two Menotti operas in 2015](/in-review-the-telephone-the-medium/) still stands as one of my most memorable opera experiences to date.) Frivolity - like a day of skating - feels sad and false within this context, and everything that seems normal on the outside is tinged with malaise and euphemism.

Julia Müer's set and costumes emphasize this by communicating the power of the cold, which acts almost as a character of its own. Müer's striking use of white symbolizes time standing still. The cold harsh outdoors stand as one of the walls of the house, a physical barrier, like a gnawing depression that physically boxes its occupants in and seems to creep in more and more as the opera goes along. White hues dominate the set and reflect the frozen state of this family in two ways: literal freezing through the stark, bluish outside white, and a metaphorical freezing of time through the faded, greying inside white. On the walls, portraits of the characters in the same clothing they are currently wearing hang alongside taxidermy butterflies in frames, further emphasizing their captivity and Vanessa's attempts to preserve the past. The costumes are gorgeous and simple, subtly reflecting the evolving personalities and states of mind of each character through colour and line. Müer's understated and larger-than-life setting perfectly underscores the story, which takes place more in the characters' minds than in reality. 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505597431855/2017-09-16---911_vanessa19hq_gross.jpg.jpg)
<figcaption>Jenny Carlstedt (Erika) on the stairs against striking sets by Julia Müer. *Vanessa*, Oper Frankfurt, 2012. Photographer: Barbara Aumüller.</figcaption>
</figure>

At the time of its premiere in 1958, Barber's offer to premiere the title role of Vanessa was [(perhaps apocryphally) turned down by the legendary Maria Callas](http://www.nytimes.com/2007/11/04/arts/music/04davi.html), for whom the role was essentially written, because she recognized that this would be a coup for the so-called secondary character of Erika. It certainly was last night for Finnish-Swedish mezzo-soprano [Jenny Carlstedt](/scene/people/jenny-carlstedt/), who triumphantly reprised her Hitchcock-esque portrayal of Vanessa's tortured and stunning niece. Her voice was round and juicy, if at times a bit quiet as in the opera's most famous aria "Must the winter come so soon?". Carlstedt's Erika was also extremely relatable as a young woman caught up in a grotesque love triangle. It was as intimate as watching a movie with close-ups of her face. Her exchange with the uncomfortably high bassoon part in the first scene was eerie and snaky and highlighted the orchestra's excellent contributions to setting the opera’s uneasy tone. Erika's pallor and empty eyes in the final scene communicated across the audience with film-like intimacy in way I have rarely seen on stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505666615590/2017-09-17---vanessa_2017-18_barbara_aumueller_01.jpg.jpg)
<figcaption>Jenny Carlstedt (Erika) behind Jessica Strong (Vanessa) in *Vanessa*, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

[Jessica Strong](/scene/people/jessica-strong/) represented Canada well as Vanessa, in her first guest role with Oper Frankfurt since leaving the Ensemble. She was easily understood in her native English, as was British tenor Toby Spence as Anatol, but the other characters' diction was a bit harder to follow. Spence played Anatol as a vain, selfish man-child oblivious to the harm he is causing and unaware of his incestuous origins, constantly telling Erika to smile more. I was left wanting more depth in his character, perhaps more of a complicity within the twisted narrative of the family. 

[Dietrich Volle](http://www.oper-frankfurt.de/en/ensemble-guest-artists-opera-team/ensemble/?detail=78) (Alain Coulombe, is that you?) was wonderful as the eccentric, extravagant old Doctor, providing several moments of welcome comic relief, particularly in the "Dear Doctor" aria, as well as some sanity amongst the twisted environment of the opera. Studio member Mikołaj Trąbka was great as butler Nicholas, his warm voice, exaggerated obedience and youthful presence positioning him as a fun straightman getting yanked around by Volle's drunk Doctor. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505666676507/2017-09-17---vanessa_2017-18_barbara_aumueller_04.jpg.jpg)<figcaption>Mikołaj Trąbka (Nicholas, the Major-Domo) and Jessica Strong (Vanessa) in Vanessa, Oper Frankfurt, 2017. Photographer: Barbara Aumüller.</figcaption>
</figure>

Oper Frankfurt has once again hit the mark with its highly believable casting. This Vanessa has the feel of a psychological thriller, bringing in a dream space with realistic subtlety that creeps up on you in the hours after watching the opera. [*Vanessa*](http://www.oper-frankfurt.de/en/season-calendar/vanessa/?id_datum=892) runs at Oper Frankfurt until October 5, 2017. For details and tickets, [click here.](http://www.oper-frankfurt.de/en/season-calendar/vanessa/?id_datum=892)
