+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2017-11-22T13:45:00-05:00"
lastmod = "2017-11-22T20:52:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511376095491/2017-11-22---square---Matthew-Polenzani_THE-PEARL-FISHERS_LYR171115b_0264_c.Todd-Rosenberg.jpg.jpg"
primary_image_credit = "Matthew Polenzani as Nadir in The Pearl Fishers, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg."
publishDate = "2017-11-22T20:52:00-05:00"
related_articles = ["articles/la-opera-scores-in-first-half-of-bizet-doubleheader.md","articles/talking-with-singers-matthew-polenzani.md","articles/piotr-beczala.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/marina-rebeka.md","scene/people/matthew-polenzani.md","scene/people/mariusz-kwiecien.md"]
short_description = "The plot may be banal, the title confusing, and the libretto outrageous, but the fine singers of the Lyric wrought every possible nuance from the story and embraced The Pearl Fishers for what it is. Sure, it&#039;s no Carmen, but why should it be? The Pearl Fishers is something else: an unapologetic bit of hazy escapist fantasy — a rumination on passion and friendship set against an alluring, (if problematically ill-defined), &quot;oriental&quot; backdrop."
slug = "a-dreamy-indulgence-the-pearl-fishers-in-chicago"
title = "A dreamy indulgence: The Pearl Fishers in Chicago"
+++

This past Sunday afternoon, with a blustery wind at my back, I joined a throng of red-cheeked opera-lovers piling into the opening matinee of the [Lyric's new-to-Chicago production](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/the-pearl-fishers-opera-tickets) of Bizet's *The Pearl Fishers*. Though Bizet will always be loved best for his *Carmen*, *Pearl Fishers* is enjoying a resurgence in today's major houses, thanks in no small part to the sensational costumes and sets of this particular production, designed by renowned British couturier Dame Zandra Rhodes. The production premiered in San Diego in 2004 and has previously traveled to San Francisco, New York, Washington, and Montréal. Rhodes' vibrant costumes and sets, inspired by Indonesian textiles and architecture, border on the surreal and fill the stage with bright patterns and striking colours.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511375845073/2017-11-22---THE-PEARL-FISHERS_WS-3_c.Andrew-Cioffi.jpg.jpg)
<figcaption>*The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Andrew Cioffi.</figcaption>
</figure>

The plot may be banal, the title confusing, and the libretto outrageous, but the fine singers of the Lyric wrought every possible nuance from the story and embraced *The Pearl Fishers* for what it is. Sure, it's no *Carmen*, but why should it be? *The Pearl Fishers* is something else: an unapologetic bit of hazy escapist fantasy — a rumination on passion and friendship set against an alluring, (if problematically ill-defined), "oriental" backdrop. This is "Island Magic." *The Pearl Fishers* is French opera at its most lush and indulgent and though I may be harangued by the connoisseurs among you, I can't deny it: I loved every minute of it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511375871095/2017-11-22---Marina-Rebeka_Mariusz-Kwiecien%CC%81_THE-PEARL-FISHERS_LYR171115b_0483_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Marina Rebeka and Mariusz Kwiecień in *The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

The curtain opens on a sea-side village. Fishermen perform a ritual to ward away evil spirits. Zurga, performed by certified "barihunk" [Mariusz Kwiecień](/scene/people/mariusz-kwiecien/), arrives, reminding the villagers it is time to select a leader. Zurga is elected unanimously. The celebration of this event is cut short by the unexpected return of Zurga's long-lost friend Nadir, ([Matthew Polenzani](/talking-with-singers-matthew-polenzani/)) who had left on a hunting trip some months before. The two reunite and sing the most famous baritone-tenor duet in the repertoire, "Au fond du temple saint," wherein they remember the mysterious priestess they both adored and the vow they made to avoid her in order to preserve their friendship. To hear a taste of Polenzani and Kwiecień singing this epic duet, here is a short video from the Met's 2015-2016 [production of *The Pearl Fishers*](https://www.youtube.com/watch?v=ccGKhjEOEuE).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511375881359/2017-11-22---Mariusz-Kwiecien%CC%81_Marina-Rebeka_Matthew-Polenzani_THE-PEARL-FISHERS_CU-91_c.Andrew-Cioffi.jpg.jpg)
<figcaption>Mariusz Kwiecień, Marina Rebeka, and Matthew Polenzani in *The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Andrew Cioffi.</figcaption>
</figure>

Fresh off a hugely successful run as the Duke in LOC's *Rigoletto*, Matthew Polenzani dons yet another pair of rather flashy trousers as Nadir in this production. It was a pleasure to hear Polenzani singing this lyric French repertoire, for which his warm tenor voice is especially well-suited.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511375929556/2017-11-22---Mariusz-Kwiecien%CC%81_THE-PEARL-FISHERS__CU-27_c.Andrew-Cioffi.jpg.jpg)
<figcaption>Mariusz Kwiecień in *The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Andrew Cioffi.</figcaption>
</figure>

Kwiecień, another LOC house favorite, has rightfully made a specialty of Zurga in recent years. Despite feeling unwell, (an announcement came at the interval that he has a cold), his singing was powerful and filled the hall. While he seemed to be conserving his voice in the first to acts, Kwiecień came into the third act, (in which Zurga does much of the dramatic heavy-lifting), with an intensity that electrified the audience. As the woman seated behind me whispered, "What I would give to sound like that when I have a cold…"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511375981682/2017-11-22---Matthew-Polenzani_Marina-Rebeka_Mariusz-Kwiecien%CC%81_THE-PEARL-FISHERS_LYR171115b_1306_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Matthew Polenzani, Marina Rebeka, and Mariusz Kwiecień in *The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

The friends' reunion is interrupted by the news that a priestess has arrived from the city of Candi. She is there to live monastically in a secluded temple, to pray to Brahma on behalf of the villagers. Though her face is veiled, it is immediately apparent to Nadir that this woman is Leïla, the very woman whom he and Zurga pledged to avoid and with whom — unbeknownst to Zurga — Nadir ran off. This is all revealed in Nadir's first act aria "Je crois entendre encore," a dreamy aria in which he recalls his romance with Leïla. It is something to behold, to hear Polenzani's powerful voice soar through these melodies, softening to a pianissimo at the highest notes — Polenzani's performance throughout is a masterclass in grace and technical control.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511376009741/2017-11-22---Andrea-Silvestrelli_Marina-Rebeka_THE-PEARL-FISHERS_LYR171115b_0651_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Andrea Silvestrelli and Marina Rebeka in *The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

The lovers reunite in the cover of darkness but are soon seen by Nourebad, sung by LOC veteran Andrea Silvestrelli, whose booming voice lent an authoritarian edge to the foreboding pronouncements of the High Priest. The lovers are quickly sentenced to death by the villagers as a storm rages in the background.

Soprano [Marina Rebeka](/talking-with-singers-marina-rebeka/) makes the perfect Leïla, with a fresh, agile sound that is youthful and deeply charismatic. Her captivating stage presence and nuanced phrasing made up for occasional tuning issues. 

In the final act, Leïla makes a desperate plea to Zurga to spare Nadir's life. Enraged by jealousy, Zurga refuses. Their death imminent, Leïla removes a necklace, (which she previously divulged was given to her by a stranger after she gave him shelter). And here's what the whole plot suddenly turns on: the stranger was Zurga, and he's overheard Leïla talking about the necklace! Softened by the realization that it was Leïla who protected him so many years ago, Zurga engineers a way for the lovers to escape. In the version of the opera staged by the Lyric, (a confusing production history with several available endings means there's a choose-your-own-adventure element to producing this opera today), the lovers make their escape, but Zurga is killed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1511376040027/2017-11-22---THE-PEARL-FISHERS_WS-56_c.Andrew-Cioffi.jpg.jpg)
<figcaption>*The Pearl Fishers*, Lyric Opera of Chicago, 2017. Photo: Andrew Cioffi.</figcaption>
</figure>

When *The Pearl Fishers* was first premiered, Bizet faced hostility from the press over the outlandish plot as well as its musical construction but the score won early praise from Hector Berlioz, a composer as famous in his day for his ingenious orchestrations as for his sarcastic, aggressive music criticism. Bizet's evocative instrumentation and distinct gifts for melody were expertly brought to life by the conducting of LOC's long-time Music Director, Sir Andrew Davis. It is a busy time for Davis, who is also currently leading performances of [*Die Walküre*](https://www.schmopera.com/die-walkure/). 

While that might make for a more profound night of theater, for a dreamy indulgence, go for this gauzy, sun-soaked bit of Chinoiserie. See [*The Pearl Fishers* at the Lyric Opera of Chicago](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/the-pearl-fishers-opera-tickets) until December 10th.

>For details and tickets, follow our box office links below.
