+++
author = ["authors/blanche-isral.md"]
categories = "Op-ed"
date = "2016-11-28T20:10:00+00:00"
lastmod = "2016-11-30T14:52:00+00:00"
preamble = "This article is based on an email sent by contributor [Blanche Israël](/authors/blanche-israel/) to the creative team behind [*Chasse-Galerie*](https://www.soulpepper.ca/performances/chasse-galerie/2003), the musical by James Smith that's currently onstage at [Soulpepper Theatre](https://www.soulpepper.ca/). The company has responded positively to Blanche's tips, which are fascinating enough to warrant a special post on cursing *en français*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1480367067962/2016-11-28---Swear.jpg.jpg"
publishDate = "2016-11-29T17:36:00+00:00"
related_articles = ["articles/the-future-of-opera-is-indie.md","articles/opera-lyra-and-the-five-stages-of-grief.md"]
short_description = "Words like tabarnak, câlisse, criss, simonaque, ciboire, calvaire, viarge and esti are nouns, so they generally require a &quot;de&quot; after them when they are used to describe something. A few of them were used as adjectives on a few occasions, which sounds off to a native speaker. For example, you can&#039;t say &quot;that tabarnak chair&quot;. A connector word is missing: &quot;that tabarnak de chair&quot;, &quot;cette tabarnak de chaise&quot;. It&#039;s like saying &quot;that f*ck chair&quot;, it just doesn&#039;t work, it has to be &quot;f*cking&quot; for it to make grammatical sense."
slug = "a-diction-lesson-french-canadian-swearing"
title = "A diction lesson: French Canadian swearing"
+++

You had me at "tabarnak".

Think *Once* meets *The Nutcracker* meets *Lord of the Dance*. An instant secular holiday classic, *Chasse-Galerie* (a Kabìn and Storefront Theatre co-production on at Soulpepper Theatre in the Distillery), is a fun, original, and distinctly Canadian musical. My one suggestion? Find out if there is such a thing as a "French Canadian expletive diction coach".

Based on the eponymous legend of Québécois and Indigenous origins, [*Chasse-Galerie*](https://www.soulpepper.ca/performances/chasse-galerie/2003) is the story of four lonely 17th-century *coureuses des bois*. These self-employed lumberjacks, lonely and cold on New Year's Eve, strike an enticing deal with the devil to get themselves out of far-away Gatineau to be with their sweethearts. The devil agrees to bewitch a canoe to fly them to Montréal for one steamy night, on three conditions: be back by dawn, don't let the canoe touch any church steeples during flight, and oh, don't swear (as all French Canadian swears are related to the Catholic church). Full of twists and turns, *Chasse-Galerie* keeps you on the edge of your seat tapping your toes until the final scene.

This production takes an exciting and fresh approach to the classic tale. The gender swap, whereby female lumberjacks pine for their friends-with-benefits back home, is executed with commitment and opens the door seamlessly to homosexual and polyamorous relationships. The music, composed and conducted by James Smith, is a hoot, and the musical-style singing is good.

As a Québécoise fiddler/musical theatre fan who works in the arts in Toronto, this show resides at the cross-section of all my interests. It is a riot, full of dancing, drinking, audience participation, raucous musical interludes… and swearing. This got me thinking about the importance of diction and pronunciation: it was the first time I heard my own mother tongue attempted by anglophone singers, and it was suddenly crystal clear how important, say, Italian or German diction might be to a native speaker.

I am around opera singers *a lot*, having worked for the Canadian Opera Company and Tapestry Opera, and I am a proud Frog who moved to Toronto only a few years ago. In fact, I have my own business in the area of translation for the performing arts, called [Proscenium Translation.](http://www.prosceniumtr.com/) So I think about diction, arts management, and languages a ton, specifically Québécois French. Because I absolutely loved this show and because I suspect it will come back next holiday season, I thought I’d explore a few Québécois-related things that could do with some coaching, just like an opera singer would coach their Italian or German to get it perfect and convincing:


## Step 1: Know your Syntax


As the show captures well, swearing is embedded in French Canadian culture. Therefore, certain grammatical rules apply. (Pardon my literal and proverbial French, I am going to use the actual swear words here.) Words like tabarnak, câlisse, criss, simonaque, ciboire, calvaire, viarge and esti are nouns, so they generally require a "de" after them when they are used to describe something. A few of them were used as adjectives on a few occasions, which sounds off to a native speaker. For example, you can't say "that tabarnak chair". A connector word is missing: "that tabarnak de chair", "cette tabarnak de chaise". It's like saying "that f\*ck chair", it just doesn't work, it has to be "f\*cking" for it to make grammatical sense. 

Same goes for connecting multiple swear words together ("esti de tabarnak de câlisse de bout'viarge de chair!") which one particularly pious character does near the end to great humour - we need some more connector words in there. And in the cursing song, "Esti tabarnak tabarnak esti", there should be a little "de" between esti and tabarnak to make it make sense: "esti de tabarnak, tabarnak, esti". There is a [great scene from the movie *Bon Cop, Bad Cop*](https://www.youtube.com/watch?v=KUGW0jszPzo) where a Quebecer hilariously explains swearing syntax to an Ontarian.

## Step 2: "Tune" your Adjectives

There is a concept in French grammar called "l'accord", which literally means "tuning", which many of you musicians will like. You need to "tune" your adjectives and verbs to match their corresponding nouns. There were some adjectives in the show: "maudit/maudite" ("that maudite chair") and "bête". that needed to be tuned to match the "gender" of the word they go with. Many Quebecers switch back and forth between English and French all the time, and therefore it has its own grammatical rules, believe it or not. 

You would generally use the gender of the French word equivalent to determine the gender of your adjective. So you can't say "maudite canoe" because "maudite" is feminine and the French word for canoe (canot) is masculine. Therefore it would be "maudit canoe" (silent T so it sounds like "maudi"). "Bête" is the same for the feminine and masculine, so use it to your heart's content.

## Step 3: Pronounce with Conviction

There is some room within the 17th-century historical setting here for the pronunciation to be a little different from today's. That being said, "tabernacle" should be pronounced with all A's and cut off at the end: "tabarnak". "Esti" is used but "hostie" is more common (silent H), "simonaque" is not "sim**ô**naque" but more of an open "o", think "simonnaque". "Baptême" means "baptism", but is pronounced sans P.  We all know that swearing is all about the delivery, so diction coaching is perhaps more important here than anywhere else.

Okay, me, I need to go wash my mouth out with soap now. And you, ciboire, you need to see [*Chasse-Galerie* before it closes on December 1.](https://www.soulpepper.ca/performances/chasse-galerie/2003) 
