+++
author = ["authors/daniel-weisman.md"]
categories = "Review"
date = "2018-11-07T13:49:00-05:00"
lastmod = "2018-11-07T14:12:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541617756047/sq_D800796.jpg.jpg"
primary_image_credit = "Vanessa Becerra as Maria and Andrew Bidlack as Tony in West Side Story, The Atlanta Opera, 2018. Photo: Greg Mooney."
publishDate = "2018-11-07T14:12:00-05:00"
related_articles = ["articles/beloved-bernstein-hgos-west-side-story.md"]
related_companies = ["scene/companies/the-atlanta-opera.md","scene/companies/houston-grand-opera.md","scene/companies/lyric-opera-of-chicago.md"]
short_description = "West Side Story isn&#039;t an easy show and, particularly in current climates, a controversial one to cast. It is dance heavy and, while the Atlanta Opera Chorus shined during their choreographed number during last season&#039;s La fille du régiment, West Side Story requires specialized training, perfect timing, and active feats of physical intensity. After spending election night in the audience of the same production I was so nervous about, I can genuinely say that it is a production not to miss."
slug = "a-definitive-hit-west-side-story-in-atlanta"
title = "A definitive hit: West Side Story in Atlanta"
+++

There was a definite amount of worry when The Atlanta Opera announced that they were planning to produce Leonard Bernstein's mid-century adaptation of Shakespeare's classic tale for their 2018-2019 season. [*West Side Story*](https://www.atlantaopera.org/performance/west-side-story/) isn't an easy show and, particularly in current climates, a controversial one to cast. It is dance heavy and, while the Atlanta Opera Chorus shined during their choreographed number during last season's [*La fille du régiment*](/a-bel-canto-winner-atlantas-fille-du-régiment/), *West Side Story* requires specialized training, perfect timing, and active feats of physical intensity. After spending election night in the audience of the same production I was so nervous about, I can genuinely say that it is a production not to miss.

This year marks the 100th year of Leonard Bernstein's life and, as such, most companies and young artist programs have been celebrating with their own productions of *Candide*, *Trouble in Tahiti*, and, most notably, *West Side Story*. The musical premiered in 1957 with a book by Arthur Laurents, a libretto by Stephen Sondheim, and Leonard Bernstein's iconic score. The story follows the rivalry of teenaged New York City street gangs, the Sharks and the Jets, who parallel the feuding Montagues and Capulets of Shakespeare's *Romeo and Juliet* fame.

The Sharks, a group of Puerto Rican immigrants have faced notable conflict and discrimination at the hands of the American Jets and the local police. Things escalate as a former Jet, Tony, falls in love with the sister of the leader of the Sharks, Maria. Unfortunately, Maria is promised to Shark member Chino, only creating more division and conflict as the show climaxes with an accidental rumble between the Sharks and the Jets.

The Atlanta Opera's production is a co-production that was recently staged at The Glimmerglass Festival (evident by the number of singers who returned for this production), Houston Grand, and Lyric Opera of Chicago. As the curtain rises we see an extravagant and cinematic set, designed by Peter Davison, which functionally acts as the various streets and venues, perfectly unfolding the interior of Maria's room at various points. The set was strikingly decisive in setting the scene, allowing TAO's production to feel the period fully.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541617836550/_D8M2986.jpg.jpg)
<figcaption>Brian Vu as Riff (centre) in *West Side Story*, The Atlanta Opera, 2018. Photo: Greg Mooney.</figcaption>
</figure>

Francesca Zambello's direction, coupled with Julio Monge's reproduction of the original choreography provided an honest and inviting portrayal of the poignant story, combined with David Neely's excellently clear conducting of The Atlanta Opera Orchestra and Jessica Jahn's color segregated costuming provided the perfect technical and stage framework for *West Side Story*'s success.

Standing out in the cast was Vanessa Becerra, who I was able to work with when she was Johanna in The Atlanta Opera's *Sweeney Todd: The Demon Barber of Fleet Street*. I figured that I would know exactly what so expect from Vanessa: a pretty and accurate voice coupled with clean diction and comparable acting, though this was far from the case. Becerra's warm silver of a soprano was light, forgiving, and shimmered beautifully in both the duets and the solo numbers. Her "Somewhere" was one of the most beautiful and intimate moments in the show. Not to be typed as only a singer, Becerra's embodiment of Maria was complex, dynamic, and passionate. Her youthful vigor in this role seemed to cause the audience to want to sit Maria down and explain to her that she is a child, that she's only known Tony for two days, and that she's too good for him. Having heard Becerra in musical theatre twice, I would love to hear her singing more operatic repertoire at TAO in the future. She is one to watch.

Playing Maria's love interest was Andrew Bidlack, who held a beautiful lyric tenor voice struggled slightly stylistically. To be fair, Bernstein wasn’t exactly kind, asking Bidlack's Tony to sing in the extreme lows of his voice for prolonged periods of time. Overall, Bidlack's mezza di voce in the upper register was by far the strongest part of his performance. That being said, there was a sense of dishonesty to his portrayal of Tony that caused his acting to appear slightly affected and brought me out of the story slightly.

As Anita, Amanda Castro provided some of the most technically accurate and exhilarating dances of the production. Her technique is amazing and, while her dancing was definitely the strongest part of her portrayal, her acting was not very far behind. The more controversial part of Ms. Castro lies in her singing. She possesses a seemingly untrained voice with some definite technical flaws that Anita's high belt and low tessitura seemed to highlight. That being said, Castro does possess a strong and beautiful instrument with the potential to provide a stunning Anita, the voice was just not yet quite on the same level as her dancing and acting.

Brian Vu takes on the role of Riff, the leader of the Jets and Tony's best friend. I lost some of Vu’s voice in the dialogue potions, but his singing was a warm lyric baritone, straddling the lines between classical musical theatre and opera, sometimes leaning slightly too far towards opera, which wasn't surprising considering his operatic training. That said, he still managed to keep up well with the dancing.

The rest of the Jets were made up by Connor McRory, whose humorous and sometimes intimidating Action was a treat during "Gee, Officer Krupke", PJ Palmer (A-Rab), Tyler Whitaker (Baby John), Matthew Steriti (Big Deal), Schyler Vargas (Diesel), Taylor Simmons (Snowboy), and Spencer Britten (Gee-Tar). Additionally, Kelsey Gibbs' Anybodys provided another concept to the narrative of acceptance and helped round out the Jets alongside Melissa McCann (Graziella), Kaylee Guzowski (Velma), Ayana DuBose (Minnie), Rachel Shiffman (Clarice), and Priscilla Eugene Curtis (Pauline).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541617885690/_D800615.jpg.jpg)
<figcaption>Amanda Castro as Anita (centre) in *West Side Story*, The Atlanta Opera, 2018. Photo: Greg Mooney</figcaption>
</figure>

Leading the Sharks as Maria's protective and angry older brother, Bernardo, is DJ Petrosino, whose movement and acting provided a strong villain figure and a presentation that allowed his flaws to appear human enough to sympathize with. It's hard to picture anyone else being as successful in this role as Petrosino is.

Brian Wallin's Chino, betrothed to Maria, provided a fine sinister twist after the seemingly innocent and oblivious sidekick to Bernardo seemed to fade. He was joined by fellow sharks Jawan Cliff-Morris (Pepe), John Fiscian (Indio), Cansley McGhee (Luis), Nicholas Anthony (Anxious), Patrick Coleman (Nibbles), Eliza Bonet (Rosalia), Natalie Caruncho (Consuelo), Joanna Latini (Teresita), Olivia Barbieri (Francisca), and Carolina Villaraos (Estella), who all provided a vivacious sense of spirit, technical precision, and voice to their various roles.

Lastly, the outnumbered adult roles were mandatory to balance the youthful vigor of the Jets and Sharks. Rial Ellsworth, whose work as Doc provided an attempt at conscience to both the Jets and the Sharks, easily pointed out their hypocrisy with empathic excellence. Zachary Owen's snakelike Lieutenant Schrank was a villainous devil in disguise, allowing the audience to understand the distrust of the police from both sides. Schrank's sidekick, Officer Krupke, was portrayed expertly by Atlanta Opera Chorus veteran, C. Augustus Godbee, who brought a bumbling humor to his two short scenes. Finally, Brady Dunn's Glad Hand did his best to try and keep the Sharks and Jets from killing each other, his nervous energy bringing a positive humor to an otherwise tense scene.

The Atlanta Opera proves, once again, its versatility in a changing field. [*West Side Story*](https://www.atlantaopera.org/performance/west-side-story/) is a definitive hit in their season, with an amazing cast, a striking set and costumes, and an orchestra that I can't remember playing so well since *Silent Night*.

>The Atlanta Opera's production of *West Side Story* runs through November 11. For details and tickets, [click here.](https://www.atlantaopera.org/performance/west-side-story/)
