+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2018-10-15T20:24:00-04:00"
lastmod = "2018-10-15T20:27:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539648427302/sq180109_00206.jpg.jpg"
primary_image_credit = "Artist of Atelier Ballet Edward Tracz poses as the stag in Actéon. Photo by Bruce Zinger."
publishDate = "2018-10-15T20:27:00-04:00"
related_articles = ["articles/in-review-opera-ateliers-armide.md", "articles/he-saidshe-said-alcina-at-opera-atelier.md", "articles/feminism-confetti-ateliers-triplebill.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/colin-ainsworth.md"]
short_description = "Such longevity puts it among the upper echelon of Canadian opera companies in Canada - a feat more impressive when we consider that Atelier performs exclusively 17th- and 18th-century baroque opera. It&#039;s almost impossible to resist saying it: &quot;If it ain&#039;t baroque, don&#039;t fix it.&quot;"
slug = "a-daring-desirous-double-bill-at-opera-atelier"
title = "A daring &amp; desirous double-bill at Opera Atelier"

+++
Since 1985, Co-Artistic Directors Marshall Pynkoski and Jeannette Lajeunesse Zingg have grown [Opera Atelier](/scene/companies/opera-atelier/)'s presence like a slow burn, maintaining two productions a year based out of Toronto. In 33 seasons, Atelier has expanded internationally, touring as far as Japan, and becoming a regular import at the Royal Opera House of Versailles; this season the company makes its first trip to Chicago, at the Harris Theater for Music and Dance.

The company also employs the closest thing the Canadian opera scene has to a European-style house ensemble. Audience members who regularly attend Atelier's productions are familiar the work of their core creative team: stage director Marshall Pynkoski, choreographer Jeannette Lajeunesse Zingg, Resident Music Director David Fallis, and Resident Set Designer Gerard Gauci. Onstage are the returning faces of the Atelier Ballet, and a rotating ensemble of singers - including some refreshing debuts - who are well versed in the stylistic demands of baroque opera.

Opera Atelier's is one of the most recognizable styles in the Canadian opera scene, and clearly, they're doing something extremely right. Such longevity and stylistic commitment puts Atelier among the upper echelon of Canadian opera companies in Canada - a feat more impressive when we consider that they specialise exclusively 17th- and 18th-century baroque opera. It's almost impossible to resist saying it: "If it ain't baroque, don't fix it."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539648480704/170522_MASTER_21173.jpg.jpg)
<figcaption>Jeannette Lajeunesse Zingg and Marshall Pynkoski in the Palace of Versailles. Ms. Zingg is wearing a gown by Reem Acra, generously provided by The Room at Hudson's Bay. Photo by Bruce Zinger.</figcaption>
</figure>

Opera Atelier opens its current season with a double-bill, a production that seems to first get its footing from the company's established style and team of artists, and then leap confidently forward into something new. In their production history Atelier has put up both Charpentier's *Actéon* (first in 1987) and Rameau's *Pygmalion* (first in 1999); this month, the operas are presented for the first time as a double-bill. The two stories share a theme of transformation, and in more tangible terms, origins in Ovid's *Metamorphosis*.

The two operas tell of humans who transform into something non-human, and vice versa. First performed in 1683, *Actéon* begins as a story of love between the titular character and the goddess Diana. "It is passion, it is desire that forces him to look at her," says Pynkoski. Actéon is then turned into a stag, and devoured by his own hounds - a clear message of the time. "Desire is dangerous," Pynkoski concludes. "Sensual desire creates people who are bestial."

*Pygmalion*, premiered in 1748, reflects a near-opposite social attitude toward desire; it was a time when, as Pynkoski puts it, "Versailles is a perpetual house party." When the sculptor falls in love - and lust - with the statue he creates, the gods respond by turning the statue into a living woman.  "Passionate, sexual desire is rewarded," Pynkoski notes.

Perhaps it's on purpose, or maybe it's a fitting coincidence, but this metamorphosis-themed production also brings to Opera Atelier some stark novelty. For the first time, the company has named an Artist in Residence: tenor Colin Ainsworth, who sings the title roles in both *Actéon* and *Pygmalion*, as well as in Atelier's spring 2019 production of Mozart's *Idomeneo*. Ainsworth takes a centre-stage role this season, and he'll also work with masterclasses and outreach programs established by Atelier. "This is the time for Colin, to really hosw him off not just here, but internationally," says Pynkoski, looking ahead to Atelier's upcoming tours to Versailles and Chicago. "We have a real Canadian treasure here, and he's to be celebrated."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539648488598/OperaAtelier_ColinAinsworth.jpg.jpg)
<figcaption>Colin Ainsworth is Opera Atelier's 2018-2019 Artist in Residence. *Armide* photo by Bruce Zinger.</figcaption>
</figure>

Also new: Opera Atelier is presenting its very first new commission. *Inception*, by violinist/composer Edwin Huizinga and dancer/choreographer Tyler Gledhill, is a work for violin and dancer that will find its place within this double-bill. Placed between the two operas, *Inception* will prove a novel way to establish the environment that inevitably opens up into the story of *Pygmalion*. "Going into *Pygmalion* will be the fully realized, more mature version of this character," says Gledhill. 

Jeannette Lajeunesse Zingg calls it "the new with the old," a piece that encapsulates the fusion between baroque and contemporary styles.  "We certainly do not wish to be a museum," she says. "Even though [Tyler and Edwin's work] will look more contemporary than what I'm doing, they're also deeply rooted in the Classical style, and I don't think they could be doing what they're doing without that."

It's certainly refreshing to see concrete evidence of Opera Atelier's mission to have their work live in the contemporary world; *Inception*, and its role within this French baroque double-bill, will be a tangible way for audiences to hear the difference between preserving a style behind glass, and nodding to the baroque as a source of inspiration.

"[Audiences] can expect to see something new and different," says Lajeunesse Zingg, "but something that has been intelligently and tastefully integrated into what we do."

>Opera Atelier's production of [*Actéon* & *Pygmalion*](https://operaatelier.com/season/2018-2019-season/) runs October 25 to November 3 at the Elgin Theatre. For details and ticket information, [click here.](https://www.ticketmaster.ca/Opera-Atelier-tickets/artist/29535?tm_link=artist_artistvenue_module)