+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2022-11-13T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1668284417/media/2022/11/sqBosOpColab110922-7217_kbslp9.jpg"
primary_image_credit = "A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography."
related_articles = ["articles/recitals-that-stick-matthias-goerne-at-wigmore-hall.md", "articles/in-review-death-desire.md"]
related_companies = ["scene/companies/boston-opera-collaborative.md"]
related_people = ["scene/people/junhan-choi.md", "scene/people/omar-najmi.md"]
short_description = "Najmi’s tender, sensitive reading of Dichterliebe is worth the price of admission all on its own: I dare say that his Dichterliebe might easily rival the performances of some of the great Lieder singers of the 20th century."
slug = "a-contemplative-reflection-on-dichterliebe-in-love-in-the-time-of"
title = "A contemplative reflection on Dichterliebe in Love In The Time Of…"
youtube_url = ""

+++
There have been a number of times throughout the history of Western music of composers deciding to look back at an old masterwork and compose a response to it, and a similar trend does exist in poetry as well. Rarely, however, does an opera company back such a project, and rarely do they do so with more than one composer at a time. And yet, [Boston Opera Collaborative](/scene/companies/boston-opera-collaborative/) decided to make a response by contacting eight composers and ten poets to respond to specific poems within Robert Schumann's _Dichterliebe_. As their executive directors put it, as they received the songs a narrative seemed to emerge from what the poets and then composers responded with: what became a planned stream was instead saved for live performance, and it is with this result, which they have elected to title [_Love in the Time Of…_](https://www.bocopera.org/love), BOC has returned to live staged performance.

One might have reason to approach such an undertaking with a certain amount of trepidation: as the old saying goes, "too many cooks can spoil the broth", and any evening that centers around a massive variety of voices is always going to have some issues with quality across the whole. Additionally, I question how a narrative can form out of responses to _Dichterliebe_: for as great a song cycle as it is, it is a part of the vein of German Lieder where there is a very short amount of setup right in the first few songs, which is then followed by the main character angsting about lost love for the entire rest of the cycle, and any responses to that run the risk of treading the same ground for so long that it gets old.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668284479/media/2022/11/BosOpColab110922-7066_s52i8m.jpg){{% /md %}}

<figcaption>A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography.</figcaption>  
</figure>

I think it is a testament to the strength of the creative talent that was called in, however, that, barring one glaring exception, _Love in the Time Of…_ went with barely a noticeable hitch to show for it. For one thing, BOC did not restrict themselves to one singer to sing this whole undertaking, and lest you think this was a decision on BOC's part the composers also played with range in their songs to great effect. They were also allowed to explore other points of view that were not just the protagonist of the whole affair, and while most of it was staged like a Greek chorus deal where various "ancient spirits" went on a reflection it did have the desired effect of alleviating the focus on the protagonist's angst.

But most importantly of all with this is that there was a very lovely sense of flow that was attained with the performance order, mostly due to several interesting text parallels between the product the poets brought and the original Heinrich Heine text. A particular example that sticks in my mind is Karen Mandell's text for Ivan Rodriguez's song "Detritus", which here is responding to "Die alten, bösen Lieder" in _Dichterliebe_. Whereas "Die alten, bösen Lieder" refers to burying items in a large coffin, Detritus chooses to parallel it with the speaker (in this case, the person of _Dichterliebe_'s speaker's affections) pulling items out of a suitcase and casting them into a lake. There is also "Before the Pandemic I Yearned To Be Kissed", whose entire shtick of the speaker having a lover who kissed her everywhere except her lips served as a commentary on "Wenn ich in deine Augen seh'" ending on the protagonist weeping "bitterly" at too much affection. There are numerous examples of this throughout the song cycle, ranging from how the poets use Heine’s frequent flower and bird imagery as jumping off points to poems that mirror the protagonist's thoughts from other angles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668284493/media/2022/11/BosOpColab110922-7083_smreku.jpg){{% /md %}}

<figcaption>A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography.</figcaption>  
</figure>

Musically, the styles were much more varied, although this is to be expected when there are eight composers doing things. For sure, there were times where the styles felt a little out of place, but overall I was not too distracted by the intermixing of styles with _Dichterliebe_. After all, trying to ape too hard from _Dichterliebe_'s style runs the risk of coming off with a good amount of insincerity, and if there is something you do not want to respond artistically to German Lieder with it is insincerity.

I don’t know that I would call what _Love in the Time Of…_ a narrative in the conventional sense: while there is a play of point of view that results from this, it does end up becoming a morass of characters angsting about the situation, and there is not much concrete to hold it together. However, as a composer who has done a song cycle with a similar dramatic arc, not all narrative needs to be literal: it can also be internal, and what is a German Lieder cycle if not internal? _Love in the Time Of…_ understands this principle quite well, and there is a contemplative progression that occurs once the lovers break up about fifteen minutes in, from searing bitterness to leaving that bitterness behind to ultimate acceptance, and with all the peaks and valleys of emotion that follow. Overall, it did give a strange sense of character progression in its own way, and I can very much see why BOC felt they had something worth staging.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668284506/media/2022/11/BosOpColab110922-7127_rchdku.jpg){{% /md %}}

<figcaption>A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography.</figcaption>  
</figure>

To be sure, not all worked as intended, and I mentioned there was one glaring exception. That exception is in "Ancient Pathways"; poet Missy Whiteman's anthem to Native American rights unfortunately ended up being the one dud of the night. For sure, I cannot take away that it is a great art song text, and it does deserve a better setting than what Lillie McDonough gave it, but thematically it is about as much a response to _Dichterliebe_ as this review is a response to Schubert's _Winterreise_. I suspect it would have dragged me out completely had previously-mentioned song "Detritus" not done a good amount of legwork to get the cycle back on theme immediately afterwards, but for that, and its placement so close to the end of the show, I figured it warranted mentioning as the one part of the evening that did not work at all.

But the fact that there was only one dud is a good sign in my book, and for me, a good chunk of the songs stood out to me for commentary, and I wish I could comment on them all! My personal favorites begin with "Summer. You.", with poetry by Danielle Legros Georges and music by Tony Solitro: there was a lovely nostalgic quality to the music, and the text plays rather beautifully off the idea that Heine poses in saying "I used to love flowers and then you came along" in "Die Rose, die Lilie, die Taube, die Sonne". Solitro was also responsible for one of my other favorites with "In the Absence of a Moonlit Sky", with poetry by Enzo Surin: its rather slow, bittersweet rumination on the intensity of such short love served as a really nice contrast to "Das ist ein Flöten und Geigen", with how it leaves off on the references to music in that poem but also offset the frenetic dance-like nature of that setting. I was also quite partial to the value of a bird, with text by Madeline Lam and music by Akshaya Avril Tucker: it handles the texts’ turn right at the end rather beautifully, and its speaker comparing themselves to a songbird serves as a good introduction for "Und wüßten's die Blumen, die kleinen" and its way of saying songbirds and flowers would cry with him if they knew of his pain. There are many more songs I would like to comment on, but all I should say here is that I enjoyed a good chunk of the songs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668284519/media/2022/11/BosOpColab110922-7178_kuvvu4.jpg){{% /md %}}

<figcaption>A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography.</figcaption>  
</figure>

After this, there is the matter of performing these songs, and the performers that BOC opted to hire were for the most part quite excellent. Jean Anderson was quite excellent as the accompanist for all of these songs: there are a lot of different moods to navigate here, and she served as the perfect anchor to keep these singers grounded in whatever worlds they were inhabiting at the time. We have the wonderful Junhan Choi with us once again, and as always he brought a distinctly warm quality to the songs he sang. I also rather enjoyed Sarah Cooper here: she sang the least out of everyone in the evening, but her warm voice navigated the turns in the text beautifully, particularly in aforementioned the value of a bird. Alexis Peart's warm mezzo-soprano voice also stood out to me, and while I did think she had a weak entrance in her first song (though, in my estimation, this is more to the fact that she started singing it at a distance from the piano that I’d consider inadvisable than anything else) every other moment in the evening was sung with incredible clarity and attention to the turns in the text. I did think that Gabrielle Clutter was perhaps the only slight misstep here: her wonderful English diction was somewhat marred by a Gwyneth Jones-esque wobble that made her voice sound perhaps too matronly for what her songs suggested for her character, and unfortunately it also meant that she was strangely a hair too quiet for some of the heavier songs, in particular "Detritus", which had the most complex accompaniment of all the songs being sung that evening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668284532/media/2022/11/BosOpColab110922-7206_vpesn3.jpg){{% /md %}}

<figcaption>A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography.</figcaption>  
</figure>

And then there is Omar Najmi, who was given sole responsibility over singing all of _Dichterliebe_. Najmi’s tender, sensitive reading of _Dichterliebe_ is worth the price of admission all on its own: I dare say that his _Dichterliebe_ might easily rival the performances of some of the great Lieder singers of the 20th century. His voice wrang out pathos with how warm it was, its color was perfect for Schumann, and it was clear from how he inflected his voice around the text that he felt every word with an intensity you don't usually see in Lieder performances these days. Even if this was not a staged performance I had the feeling that it would carry through regardless, and that is the mark of any great performance of song cycles for me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1668284545/media/2022/11/BosOpColab110922-7223_swec70.jpg){{% /md %}}

<figcaption>A scene from Boston Opera Collaborative's production of Love in the Time Of..., 2022. Photo: Dan Busler Photography.</figcaption>  
</figure>

It ended up anchoring an evening that was interesting to experience in a good way. It is always a fraught enterprise to create a huge collaborative project when not all of the parts will talk to each other, but sometimes it yields rather good results, as it did with [_Love in the Time Of…_](https://www.bocopera.org/love) There are certainly things I would have reconsidered, but ultimately it was a rather interesting night, and it framed one of the great Lieder performances quite beautifully.