+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2023-10-10T00:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1696953155/sqDOPPELGANGER_05.jpg"
primary_image_credit = "Jonas Kaufmann as the soldier begins his journey in 'Doppelgänger', an adaptation of Schubert's Schwanengesang. Photo: Monika Rittershaus, Courtesy of Park Avenue Armory."
related_articles = ["articles/opera-laid-bare-for-better-or-for-worse-in-the-mets-fanciulla.md", "articles/vancouver-opera-sails-away-in-the-flying-dutchman.md"]
related_companies = []
related_people = ["/scene/people/jonas-kaufmann.md"]
short_description = "The tenor's wrenching interpretations of the cycle's 14 songs while performing strenuous physical movement left no doubt that he was as wholly committed to the rigors of Doppelgänger as he was to the rueful Schwanengesang."
slug = "a-clarifying-and-revelatory-evening-with-schubert-and-jonas-kaufmann"
title = "A clarifying and revelatory evening with Schubert and Jonas Kaufmann"
youtube_url = ""

+++
Franz Schubert's _Schwanengesang_ (_Swan Song_) may have anticipated the masterful staging of _Doppelganger_ that the adventurous director Claus Guth brought to the massive Wade Thompson Drill Hall at New York's Park Avenue Armory late last month. Art songs generally reside in a lonely, often isolated place, and this song cycle is no exception. But it traverses such an expansive emotional range, largely desolate and hallucinatory to be sure, but with glances of passion and joy, that the overlaid context Guth and his team have created feels both clarifying and revelatory.

Jonas Kaufmann, billed simply as _voice_ portrays a wounded solider on a journey to meet his "Doppelgänger", his identical self, that will signal the moment of his death. Kaufman and his long-time accompanist, pianist Helmut Deutsch shared the 55,000 square foot stage with a team of 22 soldiers and six nurses under the fluid and extremely energetic guidance of movement director Sommer Ulrickson. They occupy a somber World War I military hospital consisting of row after row of white metal beds occupied by restless and convulsive soldiers. Michael Levine's set design, elegantly static at the start, erupted with churning motion in service to the non-linear storyline.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1696953155/DOPPELGANGER_01.jpg){{% /md %}}
<figcaption>Jonas Kaufmann (right) as the soldier who meets his Doppelgänger. Photo: Monika Rittershaus, courtesy of Park Avenue Armory.</figcaption>
</figure>

What at the outset might seem a sacrilege, Schubert is supported, indeed complemented by the original music and sound composition of Mathis Nischke, whose electronic soundscape possesses its own enigmatic logic. Nischke's composition creates a dramatic flow doing its part in erasing any semblance of the traditional recital as it accompanies the non-stop action of the staging. Mark Grey's superb sound design melds the artistic and technical forces at hand while Urs Schönebaum's stark and dramatic lighting along with saturating video projections by Rockfilm further animate the psychological drama. Constance Hoffman's costumes for Kaufmann and the other soldiers are neutral and ragged suggesting the human ravages of war, but they move well and the starched uniforms worn by the nurses carry an air of inevitability about them. 

Perhaps another seeming sacrilege, the light — and natural sounding — amplification of Kaufmann was, again, not. Given the impossibly challenging acoustics of the drill hall, this was a necessary service to both singer and audience. The subtle sound boost, a better choice then say a megaphone, helped us keep track of the tenor who, as a result of effective slight-of-hand stage movement and the artful chaos of the production, had the ability to disappear from one spot only to reappear in another.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1696953155/DOPPELGANGER_07.jpg){{% /md %}}
<figcaption>Set designer Michael Levine's massive set for 'Doppelgänger' in the Wade Thompson Drill Hall at the Park Avenue Armory. Photo: Monika Rittershaus, courtesy of Park Avenue Armory.</figcaption>
</figure>

Remaining constant however was the burnished glow of Kaufmann's voice with clarion high notes, a lustrous middle voice and the heroic strength of his baritonal lower register. The tenor's wrenching interpretations of the cycle's 14 songs while performing strenuous physical movement left no doubt that he was as wholly committed to the rigors of _Doppelgänger_ as he was to the rueful _Schwanengesang_. And it's worth mentioning that at moments he sang lying flat and in several otherwise vocally disadvantageous positions.

"Ständchen", with lyrics by poet Ludwig Rellstab, remains the most familiar in the cycle. Kaufmann's reading felt newly energized albeit by melancholy and yearning. Of the remaining songs the nature driven irony of "Herbst", lyrics also by Rellstab, was perhaps the most poignant in which Kaufmann probed the simplicity of his character’s bleak acknowledgment of lost love. Poet Heinrich Heine provided lyrics for the final song, "Der Doppelgänger", in which Kaufmann's overwhelming anguish and resignation was palpable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1696953156/DOPPELGANGER_15.jpg){{% /md %}}
<figcaption>Jonas Kaufman (center) and Helmut Deutsch at the piano in 'Doppelgänger', an adaptation of Schubert's Schwanengesang. Photo: Monika Rittershaus, courtesy of Park Avenue Armory.</figcaption>
</figure>

Deutsch, accustomed to the formality of recitals by the world's most illustrious singers, here sat center stage and was often surrounded by waves of soldiers, nurses and even Kaufmann who never leaned into the piano as recitalists are wont to do but instead sought refuge by crouching down beside it. Deutsch receives his own solo moment with the addition of the _Andante sostenuto_ movement from Schubert's Piano Sonata No. 21in B-flat major. Placed between "Abschied" and "Ihr Bild", the movement's mournful mystery spoke without words to the inner workings of the solider's mind and spurs who knows what associations among the audience. This was a gorgeously sad sequence that, like the entire performance, was clarifying and revelatory.