+++
author = ["authors/alessia-naccarato.md"]
categories = "Review"
date = "2018-11-18T17:15:00-05:00"
lastmod = "2018-11-19T12:04:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542647057603/sqENOWarRequiemRoderickWilliamsDavidButtPhilipRichardHubertSmith.jpg.jpg"
primary_image_credit = "David Butt Philip and Roderick Williams in Benjamin Britten's War Requiem, English National Opera, 2018. Photo: Richard Hubert Smith."
publishDate = "2018-11-19T11:54:00-05:00"
related_articles = ["articles/catharsis-is-the-wrong-word-brittens-war-requiem.md"]
related_companies = ["scene/companies/english-national-opera.md"]
related_people = ["scene/people/roderick-williams.md","scene/people/david-butt-philip.md","scene/people/emma-bell.md"]
short_description = "It is a piece that could have been so unabashedly English but instead it was a nationless, chilling cry of warning. It was a perverted mockery of the dangerous, power hungry nature of war. It was one long, beautiful moment of extended prayer."
slug = "a-chilling-cry-of-warning-enos-war-requiem"
title = "A chilling cry of warning: ENO&#039;s War Requiem"
+++

November has always been a time for reflection as the days grow shorter and the old year fades. But this year, the Centenary of the First World War, is particularly poignant. And how refreshing it is to watch a tribute that does not glorify or romanticise war but is instead a biting criticism of it, dripping with sarcasm and anger. This beautiful, fully staged production of Britten's *War Requiem*, designed by Wolfgang Tillmans and directed by Daniel Kramer, perfectly captured the violence and the reverence that is at the heart of this piece. The work lends itself perfectly to the operatic stage, having so much  exciting potential for storytelling. Latin text from the requiem mass is blended seamlessly with English text by Wilfred Owen, one of the best known poets of the First World War. There could have been no better fit for the voice of this piece than Owen, who was tragically killed in action in 1918 but whose posthumously published poetry, is a scathing outlook on the destruction of war. Britten, of course, was a famous pacifist and conscientious objector during WWII and so it is a natural fit.
 
The design was expertly handled by Tillmans who used his Turner Prize-winning expertise in photography to project startling historical images of the war, often juxtaposed against elements from the natural world depicting decay, as well as images of the Cathedral in Coventry (the 1962 opening of which this piece was written for) on three enormous rotating panels that made up the entirety of the set.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542646083025/ENOWarRequiemEnsembleRichardHubertSmith.jpg.jpg)
<figcaption>ENO *War Requiem Ensemble*, English National Opera, 2018. Photo: </figcaption>
</figure>

The scant stage allowed for the chorus - which is really the core of this piece - to be the primary focus. It enabled the ENO Chorus along with children from the Finchley Children's Music Group to create the backdrop for the unwinding narrative provided by the soloists that was sometimes atmospheric, sometimes violent and enraged, but always nuanced and sensitive. A very physically engaged piece of theatre, the chorus interchanged between portraying brawling opposing forces, to the many dead, to those who mourned them. 

Though the costumes of the tenor and baritone soloists seemed to hint vaguely at a military nature, there was no sense of this with the chorus who were dressed in a monochrome palette of working class clothing which on close inspection, seemed to be from every era over the last century - perhaps a message from costume designer Nazir Mashar that war has, and continues to influence us all even today.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542646095767/ENOWarRequiemEnsembleRichardHubertSmith6.jpg.jpg)
<figcaption>ENO *War Requiem Ensemble*, English National Opera, 2018. Photo: Richard Hubert Smith.</figcaption>
</figure>

This seemed to be the overwhelming message throughout; that war should not be glorified. That the violence of war can only lead to the degradation of life. And most importantly, that war touches us all in many different ways. This last point in particular was brought to life through the storylines of the soloists. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542646146551/ENOWarRequiemEmmaBellandEnsembleRichardHubertSmith.jpg.jpg)
<figcaption>Emma Bell and Ensemble in Benjamin Britten's *War Requiem*, English National Opera, 2018. Photo: Richard Hubert Smith.</figcaption>
</figure>

Tenor [David Butt Philip](/scene/people/david-butt-philip/) gave an emotional performance particularly in his opening scene as the disillusioned, shell-shocked soldier singing "What passing-bells for these who die as cattle?" Baritone [Roderick Williams](/scene/people/roderick-williams/) was completely captivating, often taking on the role of the bitter general who had seen too much of death. His final solo before the finale of the piece in which he says "I am the enemy you killed, my friend" is a poignant and intimate moment between the tenor and baritone soloists who here represent two weary, and beat-down members of opposing forces, sharing a moment of understanding. Soprano soloist [Emma Bell](/scene/people/emma-bell/) shone especially strongly as the grieving widow in a scene depicting the funeral of a fallen soldier. There was so much strength and intention in her singing as she passed judgement on all for the terror and destruction caused.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542646125037/ENOWarRequiemDavidButtPhilipRoderickWilliamsRichardHubertSmith.jpg.jpg)
<figcaption>David Butt Philip and Roderick Williams in Benjamin Britten's *War Requiem*, English National Opera, 2018. Photo: Richard Hubert Smith.</figcaption>
</figure>

Where most Armistice ceremonies leave me with nothing but a feeling of nationalistic guilt I can't account for, the *War Requiem* was an experience of a different kind. It is a piece that could have been so unabashedly English but instead it was a nationless, chilling cry of warning. It was a perverted mockery of the dangerous, power hungry nature of war. It was one long, beautiful moment of extended prayer. It's 2018. The First World War ended a hundred years ago. This November, let's remember so that perhaps our world that has been constantly torn apart by violence the last century, can finally begin to heal.
