+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-11T22:18:00-04:00"
lastmod = "2015-07-20T11:32:00-04:00"
preamble = "This Friday, Opera By Request presents a semi-staged version of John Metcalf and Larry Tremblay's [*A Chair in Love*](http://operabyrequest.ca/wordpress/?p=323). The 2005 opera about a man who falls in love with a chair is intriguing and bizarre enough to pique my interest. I had the chance to ask composer [John Metcalf](/scene/people/john-metcalf/), music director William Shookhoff, and the show's cast about *A Chair in Love*, in the selfish hopes of figuring out what it's all about. The show is one night only, July 17th at 7:30pm at Array Music, 155 Walnut Avenue. Tickets are $20, and details and reservations can be made by calling 647-238-0064."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436670489530/Chairs.jpg.jpg"
publishDate = "2015-07-14T09:15:00-04:00"
related_articles = ["articles/in-review-lucia-di-lammermoor-at-opera-by-request.md","articles/new-recordings-the-man-who-mistook-his-wife-for-a-hat.md"]
related_companies = ["scene/companies/opera-by-request.md"]
related_people = ["scene/people/michael-robertbroder.md","scene/people/gregory-finney.md","scene/people/kim-sartor.md","scene/people/abigail-freeman.md"]
short_description = "This Friday, Opera By Request presents a semi-staged version of John Metcalf and Larry Tremblay&#039;s A Chair in Love. The 2005 opera about a man who falls in love with a chair is intriguing and bizarre enough to pique my interest. I had the chance to ask composer John Metcalf, music director William Shookhoff, and the show&#039;s cast about A Chair in Love, in the selfish hopes of figuring out what it&#039;s all about. "
slug = "a-chair-in-love-what-what"
title = "A Chair in Love. What, what?"
+++

### 1. This opera seems pretty bizarre; what's the best way you could sum up the story of *A Chair in Love*?

**Abigail Freeman**: *A Chair in Love* is a modern comedic opera that centres around a romantic tryst involving a film maker, a chair and his dog.

**Kim Sartor**: A contemporary Canadian comic opera about an “urban angst” filmmaker who falls in love with a chair, and his faithful (if slightly jealous) dog who tries to save him from heartbreak.

**Greg Finney**: Film director becomes subject of his own absurdist film about romantic love between inanimate objects. His dog gets jealous. They seek counselling.

**Michael Robert-Broder**: Man loves chair, chair is chair, dog is skeptical...oh and there's a Dog-tor

**William (Bill) Shookhoff**: Can an avant-garde film producer find happiness with a chair, with whom he falls in love?  When the chair returns his feelings, all seems well, but has no one considered the feelings of the faithful dog?  Can one maintain one's artistry when blinded by love?  Only Metcalfe & Tremblay know for sure.

### 2. Can you give us a brief history of the creation of A Chair in Love?

**John Metcalf**: It is normal for a composer to be consulted about the subject of an opera, to be involved in discussions about the shaping of the libretto. *A Chair in Love* came about in an unusual way: Larry Tremblay had written, without a composer in mind, a "complete" opera libretto. In Canada we have Keith Turnbull, one of the world’s leading authorities on new work in the opera genre. Larry Tremblay sent his libretto to Keith, who in turn sent it to me. Despite never having worked in that way before I agreed to compose the piece.

I was helped along the way by a series of workshops and by dramaturgical support from Keith Turnbull. And, of course, some changes were made in the shape of the libretto. In this process I found Larry Tremblay to be a wonderful collaborator.

Also involved in the genesis of the piece were the Wind Quintet Pentaedre. There aren’t many operas scored for that combination, and I hope hear that version will soon have another run.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436670118039/Headshot-Kim-Sartor-PDF-2014-1.jpg.jpg)
<figcaption>Mezzo-soprano Kim Sartor.</figcaption>
</figure>

### 3. What significance to do you see in your characters?

**Abigail**: I think that The Chair's being really just a chair, rather than as a representation of something else (an ideal or statement on society or what have you) is what makes the opera more comic. I do think that many of us have inanimate objects that we love and sometimes unabashedly worship over actual living beings (cars, shoes etc.). It's why shows like "Hoarders" have become so popular.

**Kim**: My interpretation is that my characters have the following three functions within the opera: 

- Social commentary: The character of the Doctor could be seen as a social comment on doctors who prescribe medication when it's not necessary (the intellectual interpretation).
- Character/Plot Development: The Dogtor helps to develop our sense of Dog's character by showing how paranoid he becomes about his health and his relationship with Truman, after a diagnosis of an "extremely rare" disease. The Doctor furthers the plot by injecting Truman with a tranquilizer guaranteed to "cure" his broken heart (the relatively intellectual interpretation).
- A certain type of comedy: My Dogtor/Doctor characters provide a once-in-a-lifetime opportunity to bring a little bathroom humour into an opera (least intellectual, but possibly most accurate, interpretation).

**Greg**: I play the Dog. I see it sort of as a parable to when a friend (Truman) suddenly finds himself in a new, engrossing relationship, and how the ones who've always been by your side can sometimes, suddenly and without realizing it, get shuffled off to the sidelines.

**Michael**: Truman seems to be the most realistic of the characters, I mean he's not a talking dog, or a talking chair, or a dog-tor who thinks they've invented mysterious remedies to somewhat suspect ailments. Ultimately he could have been the title character, but it would have been much less interesting than the name *A Chair in Love*.  The only bizarre thing about him really is that he's fallen in love with a chair and can speak to his dog.  But we've all managed to suspend our disbelief about talking dogs (think *Family Guy*), so it's really not THAT far of a stretch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436670174406/77o8Yc2bH3u5vPlpiQr953wMDf9e8UK4g0eopJuC5LqugVNblxGZID_P1HB3cda5UkDrahonDCiRH1-hQ1hocZm_eWkxIA%3Dw1360-h1360)
<figcaption>Baritone Gregory Finney.</figcaption>
</figure>

### 4. What do you find appealing about this story, and why does it make a good opera?

**John**: I think that when Larry Tremblay wrote his libretto, what he had in mind was a grand opera. So it’s quite amusing that he ended up with a Wind Quintet. It is above all a comic opera which presents a love triangle in surreal way. It’s not as The Times critic inferred a serious study about the objectification of sexuality!

### 5. Where did you get the idea to "request" *A Chair In Love*?

**Bill**: Kim Sartor, who seems to love the bizarre as much as the traditional, presented me with the idea. Having done numerous new works in the past, including premieres, I was happy to take this on; though, it's an unusual request in the OBR world.

**Kim**: The concept behind Opera by Request, for those who aren't familiar with the company, is that the participants get to choose the work they would like to perform. This is my first project with OBR, and before approaching William Shookhoff, the director, I basically asked myself what kind of opera I would want to go to this summer. The answer was, "Something funny, Canadian, and pretty-please could it be under two hours long?" 

I finally found *A Chair in Love* at the Canadian Music Centre. I read the score, and laughed. And sighed. And thought, "awww." And winced (just a little). And grinned. And then I knew it was The One. I sent it to Bill, and he was enthusiastic about trying something different. It was definitely not a typical "request!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1436670245801/Michael-Robert-Broder-1-7811.jpg.jpg)
<figcaption>Baritone Michael Robert-Broder.</figcaption>
</figure>

### 6. What can audiences expect from this semi-staged performance? Is it a good choice for first-time opera-goers?

**Bill**: A taste of the bizarre/absurd in a new but highly accessible format.  Lots of humour, and very compact.  A cross between theatre of the absurd, off-Broadway musical, chamber music and opera.  Definitely a good choice for the uninitiated.

**Abigail**: I think it could be a good choice for those new to opera, as it is set in English and has a contemporary theme. Musically, it is also quite accessible, as well as the length! That's always important, even to those familiar with opera. When you present something that isn't the traditional fare, it's important to be able to capture the attention and imagination of the audience the entire time and not have any lulls.

**Kim**: Audiences can expect captivating music, a witty libretto, memorable characters, talented artists, and a relaxed atmosphere. The semi-staged aspect of the performance allows the text and music to speak for themselves, while at the same time satisfying everyone's secret longing for a little slapstick. I think first-time opera-goers and seasoned veterans alike will have a great time.

**Greg**: It is a newly composed piece, from 2005. It won't make your brain explode, but it's not laid out like Mozart or Verdi. The text is important but so are the textures. I actually think this would be a great first opera to see, because it's not the same-old "I love you, let me kill you/him/them/us/everyone to prove it" storyline. There are no mistaken identities, nor letters not delivered properly. Just a lovely story about the pitfalls of taking yourself too seriously.

**Michael**: You're going to have to show up to find out...But yes, I think the musical language isn't going to be too intimidating for someone fresh to opera, the plot is hilarious (especially if you're someone who likes the French Surrealist school of crazy) and who doesn't love a love triangle with a dog and a chair??
