+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-03-26T21:17:00-04:00"
lastmod = "2018-04-16T16:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522113377638/sq---jkat_Amazonas_031418_376.jpg.jpg"
primary_image_credit = "Soprano Elaine Alvarez is Florencia Grimaldi in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson."
publishDate = "2018-03-26T21:17:00-04:00"
related_articles = ["articles/talking-with-singers-elizabeth-caballero.md","articles/interviewing-the-greats-virginia-zeani.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
short_description = "The riverboat set is a marvel of art and engineering by Mark Frederic Smith. Taking up nearly the entire width of the proscenium, it gracefully and quickly revolves to reveal the front, back, and both sides of the boat, giving Ms. Evans and her cast many options to play the various scenes."
slug = "a-butterfly-but-not-from-puccini"
title = "A Butterfly, but not from Puccini"
+++

Since its debut in 1996, [*Florencia En El Amazonas*](https://www.sdopera.org/season/2017-2018-season/florencia) has become the most performed Spanish-language opera in the world. And it's not because it's a modern masterpiece - it isn't - but it quenches the thirst that many have for the kind of work that ended with Puccini's death in 1924. For the rest of the 20th century, opera composers deliberately ran away from the tuneful and lush style of Puccini's real masterpieces such as *Madama Butterfly*. Even up to the present (and in this century), new works can be stirring, provocative and sometimes harmonic, but almost never melodious. Even *Florencia En El Amazonas* doesn't ever quite land on a melody, but the beautiful and familiar symphonic chords and note progressions chosen by composer Daniel Catan are as close to Puccini as anyone has gotten (so far). Much of his music unfolds like a first-rate and highly-listenable film score. No surprise, since the great film composers from the Golden Age of Hollywood were also influenced by Puccini. (Just imagine what a great film composer Puccini would have been if he had lived to see the advent of sound in the movies.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522112958570/jkat_Amazonas_031418_358.jpg.jpg)
<figcaption>The cast in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson.</figcaption>
</figure>

The action of *Florencia En El Amazonas* is confined to a riverboat. The libretto is mostly inner monologues expressed as songs of yearning. Florencia (Elaine Alvarez) is an opera singer who longs to be reunited with her lover Cristobal. Rosalba (Maria Fernanda Castillo) is a writer with a burning desire to write a book about Florencia. Arcadio (Daniel Montenegro), the son of the ship's captain, can't wait to get off the boat where his life is only "back and forth." Paula and Alvaro (Adriana Zabala and Levi Hernandez) are a middle-aged couple trying to rekindle their passion for one another.

The story is essentially about the past, present and future of love. Florencia lives in a world that's twenty years-old: that's the last time she saw Cristobal, a butterfly hunter who has disappeared into the Amazon jungle. Rosalba and Arcadio struggle with even beginning their relationship and wonder what their future holds. Alvaro & Paula, serve as a warning of what can happen.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522112980618/jkat_Amazonas_031418_155.jpg.jpg)
<figcaption>(l-r) Mezzo-soprano Adriana Zabala is Paula, tenor Daniel Montenegro is Arcadio, baritone Levi Hernandez is Alvaro and soprano Maria Fernanda Castillo is Rosalba in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson.</figcaption>
</figure>

The libretto is rather weak as it pushes and pulls between reality and magical-realism, rather than successfully blending the two. If two hours of this is to be compelling, it depends upon the cast. In the case of this [San Diego production](https://www.sdopera.org/season/2017-2018-season/florencia), the superlative principal singers were worth the trip.

Ms. Alvarez (in the title role), has three arias, the first of which is the longest and most difficult introductory aria in memory. In other words, "nice to meet you, Florencia…and…wow." Her final aria closes the show. Although the composer hasn't left any room for applause throughout the opera, the audience could not contain itself after Florencia's final note. The orchestra finished the show under a hail of "bravas" (one from this reviewer).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522112968949/jkat_Amazonas_031418_325.jpg.jpg)
<figcaption>(l-r) Soprano Elaine Alvarez is Florencia Grimaldi and soprano Maria Fernanda Castillo is Rosalba in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson.</figcaption>
</figure>

Ms. Castillo and Mr. Montenegro are nothing short of brilliant, both in their solo moments and in their long-awaited *Bohème*-like duet in Act II. In Act I, Mr. Montenegro sings of his longing to be an airplane pilot who can soar unhindered into the air - something his beautiful tenor voice does with ease. Ms. Castillo, who has played Mimì, is a soprano with a voice that has that rare quality of both a ringing and tinkling bell.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522113021414/jkat_Amazonas_031418_246.jpg.jpg)
<figcaption>Soprano Maria Fernanda Castillo is Rosalba and tenor Daniel Montenegro is Arcadio in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson.</figcaption>
</figure>

Ms. Zabala and Mr. Hernandez are often very funny as the Bickerson-like couple, but are such skilled actors that we can also see the sadness which lives beneath their cynical quips. "It's sweltering, I can't breathe," Paula says. "So stop breathing," Alvaro answers. A different kind of pain surfaces for Paula when she thinks her husband is dead. Her plaintive "Alvaro, Alvaro" is very moving. Ms. Zabala is quite compelling and we can't take our eyes off of her, even when she's not singing.

Rounding out the cast: Hector Vasquez, a wonderful baritone whose Capitan figuratively anchors the show, even when the boat or the plot is floundering; Luis Alejandro Orozco, also a talented baritone, masterfully pulls off the extremely difficult role of Riolobo - a character who changes shape and form. Sometimes he is a waiter on the riverboat - sometimes he's a magical creature, begging the Amazon gods to spare the passengers during an unexpected rainstorm. Not easy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522113036675/jkat_Amazonas_031418_202.jpg.jpg)
<figcaption>Baritone Luis Alejandro Orozco is Riolobo in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson.</figcaption>
</figure>

Credit director Candace Evans for insisting that the singers deliver realistic performances even during the most supernatural of circumstances. She gives them no help, however, with the concept that the chorus should periodically appear as jungle creatures. The chorus members, who sing to perfection under the direction of Bruce Stasyna, are called upon to wander in and out of the action dressed in costumes that are as silly as anything you'd see in a children's program. In the original concept of the opera, the chorus is offstage and Ms. Evans' choices here are not a good alternative. Only near the end of the show, when the chorus slowly walks in (in unison), representing cholera and its victims, is their presence effective rather than distracting. 
They're dressed all in black and lit only by eerie amber torches that they carry. The chorus would have been more welcome in the rest of the show if they had remained essentially hidden, with only hints that they are playing the ever-present monkeys, snakes and birds in the jungle.
Members of the chorus also acted the role of a dozen or so dancers who do their best to pull focus from the scripted action. They "swim" and twirl around the ship, all to their own beat, and the result doesn't look choreographed - it's sloppy, not magical.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522113010445/jkat_Amazonas_031518_205.jpg.jpg)
<figcaption>Members of the San Diego Opera Chorus in San Diego Opera's FLORENCIA EN EL AMAZONAS. March, 2018. Photo by J. Katarzyna Woronowicz Johnson.</figcaption>
</figure>

The riverboat set is a marvel of art and engineering by Mark Frederic Smith. Taking up nearly the entire width of the proscenium, it gracefully and quickly revolves to reveal the front, back, and both sides of the boat, giving Ms. Evans and her cast many options to play the various scenes. Some better rear projections would have helped some of the stage pictures - there's a beautiful moon at one point but the cyclorama remains mostly blank.

*Florencia En El Amazonas* is a flawed work but it doesn't wear out its welcome as long as you have glorious singing. The [San Diego Opera pulled this production off](https://www.sdopera.org/season/2017-2018-season/florencia) by casting a stellar septet.
