+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = 2021-07-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1626801869/media/2021/07/sqDMMO-Platee-JonasHacker-DuaneTinkey_rkxlnw.jpg"
primary_image_credit = "Jonas Hacker as Mercury in Des Moines Metro Opera's production of Platée, 2021. Photo: Duane Tinkey."
related_articles = []
related_companies = ["scene/companies/des-moines-metro-opera.md"]
related_people = ["scene/people/elizabeth-sutphen.md", "scene/people/taylor-stayton.md", "scene/people/sara-gartland.md", "scene/people/zoie-reams.md", "scene/people/john-holiday.md"]
short_description = "The pandemic may have put performances on hiatus, but audiences are back and eager to enjoy live theater with all the passion and perseverance of the human experience. Welcome back, opera. We've missed you!"
slug = "a-busy-weekend-at-des-moines-metro-opera"
title = "A busy weekend at Des Moines Metro Opera"
youtube_url = ""

+++
After more than a year without theatrical performances, [Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/)'s summer season was a welcome reunion with live opera. Walking into the theater felt like coming home after a long and lonely pandemic, and their COVID precautions made the experience both welcoming and safe. It was clear that every opera lover in the audience was more than happy to wear their masks and keep their distance, because each and every one of us was ready to dive back into our favorite art form and regain just a little bit of our lost community as we reveled in the beauty of music.

## _Sweeney Todd_

My first live opera of 2021 ironically came in the form of a musical, Stephen Sondheim's _Sweeney Todd_. This ghastly tale of a murderous barber felt like a theatrical gut punch, sucking me into the sordid streets of London as soon as the house lights dimmed.

The scenic design by R. Keith Brumley captured the industrial revolution, both efficient and complex. Rotating set pieces allowed the audience to view multiple interiors and exteriors without pause, and the players circle at the front of the stage showcased cobbled streets, piles of junk, and a sinister sewer grate. Kate Ashton's lighting design complimented the scenery, alternating between the bright comedic motifs and the dark shadows lurking behind the cheerful façade. Notably in the background of the stage was a massive forge, nameless blacksmiths toiling in the demonic glow as Sweeney Todd grappled with his need for revenge.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824150/media/2021/07/DMMO-Sweeney-ZacharyNelsonLucySchaufer_z6vvg3.jpg){{% /md %}}

<figcaption>Zachary Nelson (Sweeney Todd) and Lucy Schaufer (Mrs. Lovett) in Des Moines Metro Opera's production of Sweeney Todd, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Similarly the costumes, designed by Jonathan Knipscher, were an unconventional amalgamation of cheerful colors with hints of the grim and garish qualities of Fleet Street's residents. Sinister masks featured in flashbacks revealed the bestial nature of the villains in stark contrast to their victims. Sweeney Todd stood out in the crowd of flashy patterns, his color palette muted and dark against his surroundings. He is a man isolated both visually and emotionally, trapped by his unrelenting desire for vengeance.

The stage direction by Kristen McIntyre combined straightforward action and bustling crowd scenes. Fleet Street was a vibrant community, and this relatable depiction made Sweeney Todd's crimes all the more gruesome. However, some of the stage violence was a bit confusing, most notably the flashback rape scene and Pirelli's death. I admired that this production did not revel in the blood and sexual violence, but the balance between subtlety and clarity was off. I don't need buckets of blood, but I want to at least catch a glimpse of crimson when his victims plummet to their demise.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824228/media/2021/07/DMMO-Sweeney-ZacharyNelsonPeterScottDrackley_uxshbh.jpg){{% /md %}}

<figcaption>Zachary Nelson (Sweeney Todd) and Peter Scott Drackley (Pirelli) in Des Moines Metro Opera's production of Sweeney Todd, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Sondheim's music is captivating in its complexities, and the orchestra, under the direction of David Neeley, created the full spectrum of emotional atmospheres with precision and passion. There were a few moments when singers in the players circle seemed to have trouble syncing up with the orchestra's tempo, but the performers quickly recovered in most instances.

The standout performance of the evening was without question that of the chorus under the direction of Lisa Hasson. The ensemble provided much of the narration and emotional weight of the musical, and their commanding harmonies in the opening scene sent chills down my spine. Many of the chorus members had featured solo moments, and I was astounded by the voices and talent of each person onstage. The chorus is an often overlooked asset in other operas and musicals, but they were the heartbeat of Sondheim's masterpiece, a gripping force of vocal and dramatic power.

Each character in _Sweeney Todd_ is uniquely memorable, and Des Moines Metro Opera's cast captured this distinct variety to great effect. From the beginning of the opera, Ben Edquist embodied youthful optimism in the role of Anthony Hope. He contrasted Todd's brooding manner with exuberance and lyricism. Edquist's rendition of the beloved "Johanna" was charming and vulnerable. His tone was manlier than typically expected in this role, but I enjoyed the bolder delivery against Sondheim's brassy backdrop. It was easy to see why Anthony had fallen so quickly for the yellow haired Johanna as soon as Grace Kahl appeared onstage. Her performance of "Green Finch and Linnet Bird" was worthy of any songbird, her sweet soprano voice shimmered with both clarity and passion. The pair of lovers were a much needed beacon of hope in an otherwise gruesome tale.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824332/media/2021/07/DMMO-Sweeney-GraceKahl_u73xai.jpg){{% /md %}}

<figcaption>Grace Kahl (Johanna) in Des Moines Metro Opera's production of Sweeney Todd, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

The villains, Judge Turpin and Beadle Bamford, portrayed by Wayne Tigges and Corey Bix respectively, made my skin crawl. Bix was a shrill menace as the Beadle, his plaid outfit almost as busy as his schemings. Whether roughing up sailors or serenading an annoyed Mrs. Lovett, Bix brought a healthy mixture of humor and malevolence to the character. Tigges on the other hand presented more of a subtle maliciousness in the role of Judge Turpin. He leered and lurked, a true ode to lechery. In stark contrast to Turpin's ugly deeds, Tigges delivered some of the most lyrical moments in "Pretty Women." On the surface Turpin's duet with Sweeney Todd is a lovely song about the beauty of the female form, but the audience's enjoyment is undercut by Turpin's sexual violence and Todd's anticipated attack. The experience was wonderfully tense and musically lush. And in his death scene, I finally got the perfect amount of blood I desired.

Christian Sanders immediately won the hearts of the audience with his infectiously funny and energetic performance of "Pirelli's Miracle Elixir." Sanders portrayed Tobias Ragg as a clever young man, quick with the sales patter but desperately hungry for affection. His relationship with Mrs. Lovett was adorable, making it all the more heartbreaking when he discovered the truth.

Toby’s first employer, Adolfo Pirelli, was sung by Peter Scott Drackley. Pirelli is a sham and a showman, and Drackley captured the comedic caricature with the vocal virtuosity to back it up.

[Zoie Reams](/scene/people/zoie-reams/) gave a compelling performance in the role of the Beggar Woman. She shifted between crass comedy and haunting heartbreak, popping up throughout the story and appearing in flashbacks as Benjamin Barker's wife. Reams displayed both physical and vocal versatility in the role, and her tragic demise delivered a cruel climax to Todd's tale.

The chemistry between everyone’s favorite murderous duo was palpable. [Zachary Nelson](/talking-with-singers-zachary-nelson/) was a foreboding presence in the role of Sweeney Todd, and [Lucy Schaufer](/scene/people/lucy-schaufer/) was a humorous counterpoint as Mrs. Nellie Lovett. Nelson’s brooding baritone voice delivered the unrelenting focus and dark malice of the demon barber of Fleet Street. His performance of "My Friends" was smooth and sinister albeit somewhat stiff physically. Surrounded by lively characters, Nelson's Todd was an eerily calm and ominous presence.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824353/media/2021/07/DMMO-Sweeney-LucySchauferZacharyNelson_zm9ich.jpg){{% /md %}}

<figcaption>Lucy Schaufer (Mrs. Lovett) and Zachary Nelson (Sweeney Todd) in Des Moines Metro Opera's production of Sweeney Todd, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Todd’s stoic nature was complimented perfectly by Schaufer's chipper Mrs. Lovett. Even when she was plotting a cannibalistic culinary venture, Mrs. Lovett did it all with charm. Her efforts were often lost on her companion, but the audience adored Schaufer's performance. Her opening number had some awkward transitions between vocal registers, but her humorous delivery overshadowed any concerns. At the end of the first act, Schaufer hit a comedic sweet spot in the duet "A Little Priest."  Schaufer and Nelson had the crowd chuckling as they quipped about cannibalism, a true testament that even the most depraved characters can be likable if Sondheim is writing for them.

By the end of the musical, the audience is both rooting for and against Todd and his accomplice, Mrs. Lovett. They deserve their tragic demise, but the collateral damage is almost unbearable. Todd’s myopic fixation on vengeance made him blind to the world around him, ignorant of his true chance at happiness. Even if you serve it in a pie, revenge is hardly a fulfilling dish.

## _Platée_

The plot of Rameau’s _Platée_ is bizarre at best and potentially problematic. Des Moines Metro Opera cleverly navigated both of these issues with their unique interpretation of the baroque comedy. The general storyline is that in order to temper the jealousy of his wife, Juno, the god Jupiter agrees to a sham seduction and marriage ceremony with a vain, swamp dwelling water nymph named Platée. (Why anyone would think this tactic would work is beyond me, but for some reason, it does.) Often in past productions of the opera, Platée's appearance is the butt of the joke. She is so hideous that of course it would be absurd for Jupiter to cheat on his wife with her. Des Moines Metro Opera's production team wisely took a different approach. It is the nymph's intense vanity and cruelty towards others that are her major flaws. Her appearance is beautiful, but her behavior is ugly. This refreshing take on a potentially shallow premise was a welcome update, and the audience reveled in the frivolous fun.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824390/media/2021/07/DMMOPlatee-chorus-DuaneTinkey_obekmx.jpg){{% /md %}}

<figcaption>The chorus of Des Moines Metro Opera's production of Platée, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

The costume and scenic designs by Jacob A. Climer had an immediate impact upon entering the theatre, a striking celebration of the color pink. The opening party scene featured a wild variety of outrageous costumes, including everything from fetish gear to Mickey Mouse hats. Each character was distinctly fascinating in a way that drew the audience in, and gender norms? No thank you.

Once we transitioned to Platée's home, the color pink further intensified. The nymph's swamp looked like Barbie's dream house had crash landed in a bog. Hints of green peeked through the bubblegum aesthetic, enduring despite the nymph's best efforts to create her ideal home. Platée's pink palace was also bedecked with an absurd amount of mirrors, a true shrine to vanity. The design was deliciously decadent but full of funny details that revealed the nymph's flaws despite her superficial façade. All of her underlings donned her signature color from head to toe, and the wig game was strong thanks to make up/hair designs by Sondra Nottingham. Even Platée's pet poodle had to fit into the color scheme! (Living people and animals can be accessories if you bully them into it apparently.)

Nate Wheatley's lighting design complimented the colorful and chaotic world of Climer's scenery, bringing even more flair for the dramatic with stormy effects and divine sparks at crucial moments. Juno's wrath was felt throughout the show, even when she wasn't onstage.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824435/media/2021/07/DMMO-Platee-ScottConner-DuaneTinkey_iorho5.jpg){{% /md %}}

<figcaption>Scott Conner (Jupiter) in Des Moines Metro Opera's production of Platée, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Every costume was more delightful than the next. Jupiter and June donned outfits that were a mashup of gladiator and Vegas showgirl, dripping with gold and donning huge headdresses. (Even Jupiter's nipples were gold and pierced!) Mercury wore a more traditionally inspired ensemble with a short white toga and winged helmet, but his thick rimmed glasses brought a humorous modern touch to the character. Platée herself wore a variety of gorgeous costumes. (Most of them pink obviously.) The nymph loved a glamorous look, figure hugging corsets and decadent jewels. She knew how to highlight her assets, and while her fabulous gowns couldn't overcome her terrible personality, she looked damn good in her green wig and thigh high boots.

> All five singers clearly took pleasure in their over the top characters, and their vocal performances were playful yet skilled.

Conductor Gary Thor Wedow led the orchestra in a polished and energetic performance of Rameau's music. The ensemble created a bubbly atmosphere for the characters to inhabit, intermixing the frivolity with tempestuous bouts to illustrate Juno's wrath. Wedow's steady hand kept the orchestra and singers attuned to each other throughout the performance despite the frequent use of the players circle, and his interactions with some of the characters themselves added to the humor.

The chorus under the direction of Lisa Hasson gave a delightful performance as both drunken partiers and Platée's long abused entourage. Each individual brought a unique character to life while maintaining a solid vocal ensemble, often making cheeky comments to the audience at their mistress’ expense. Their interactions with the main characters made for some of the most hilarious moments of the opera, and their energy carried the story no matter how absurd some of the plot points.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824463/media/2021/07/DMMO-Platee-ScottConner-ZoieReams-DuaneTinkey_brzx7s.jpg){{% /md %}}

<figcaption>Scott Conner (Jupiter) and Zoie Reams (Juno) in Des Moines Metro Opera's production of Platée, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

As with many French operas, Rameau's _Platée_ is a celebration of dance as well as music. The six company dancers brought beauty and grace to the stage, balanced with a healthy dose of humor. Often dance interludes can feel like unnecessary interruptions, but Isaac Martin Lerner's choreography evolved to suit every situation. Whether tipsy party guests, prancing dyads, or frenzied orderlies, the dancers captured the passion and comedy necessary for every situation, even when Platée was throwing a tantrum in the middle of their routine.

The cast of _Platée_ delivered virtuosic vocals and humorous hijinks from start to finish. The opera began with the drunken party prologue featuring Benjamin Taylor as Un Satyr, James Stevens as Thespis, Camille Sherman as Thalie, Alexander Birch Elliott as Momus, and Véronique Filloux as Amour. These mischievous gods conspire to teach a lesson to mortals and their fellow deities, calling upon their specialities (drama, ridicule, comedy, and love) to serve up Platée's tale. All five singers clearly took pleasure in their over the top characters, and their vocal performances were playful yet skilled.

Elliott was a constant presence throughout the opera since Momus seemed to be one of the primary masterminds behind Platée's prank nuptials. His rich baritone was surprisingly agile in the baroque style, and his physical embodiment of the role held just the right amount of snark. It takes true comedic bravado to don a skimpy cupid costume, heart shaped arrows and all, with confidence, and Elliot embraced every ridiculous moment with natural ease.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824530/media/2021/07/DMMOPlatee-TaylorStaytonCadieJBryanNormanthePoodleDuaneTinkey_off1wn.jpg){{% /md %}}

<figcaption>Taylor Stayton (Platée), Cadie J. Bryan (Clarine) and Norman the Poodle Des Moines Metro Opera's production of Platée, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Alex Rosen sang the role of Cithéron, the local king plagued both by Juno’s natural disasters and Platée’s advances. Rosen portrayed the character with an earnest passion and energy and was often paired with the messenger deity, Mercury, sung by Jonas Hacker. The beleaguered god was clearly an audience favorite, garnering many of the laughs as he struggled to work up the nerve to perform his duties. Hacker played Mercury as a frustrated immortal whose patience was almost as short as his toga, and Hacker’s vocal performance in stark contrast to his neurotic character was solid and commanding, ideal for delivering divine proclamations.

Cadie J. Bryan was charming in the role of Platée's long suffering maidservant. Her sunny soprano voice was well suited to Rameau’s music, and her brief solo was luminous and sweet.

Platée's wedding was also graced by La Folie, the goddess of insanity, sung by [Elizabeth Sutphen](/scene/people/elizabeth-sutphen/). Folie's elaborate solo was a crowd pleaser, and Sutphen delivered both vocal fireworks and impeccable comedic delivery as she took the spotlight. Her ability to sing flawlessly while being carted around in a straight jacket was impressive and hilarious, and while her character was chaotic, Sutphen's vocals soared to the heights with dexterity and finesse.

Scott Conner sang the role of Jupiter, Platée's groom and king of the gods. Conner’s bold bass filled the theater like a true monarch, and while his character seemed to just stand around looking shiny and important for much of the opera, his seduction of Platée sent the poor nymph swooning from his manly presence and eye-catching ensemble. (Did I mention the gold nipples already?) Jupiter's jealous wife, Juno, was portrayed by [Zoie Reams](/scene/people/zoie-reams/). While anyone who knows their mythology will tell you Juno has every right to be suspicious of her spouse, in Rameau’s rendition of their story, her fears are supposed to come across as unfounded. Reams only appeared on stage for two short occasions, but she was captivating for every second of them. When she descended from the heavens, full of fury and shooting sparks, it was easy to see how a mortal would tremble at her wrath.

> Des Moines Metro Opera's unique spin on an old opera was a breath of fresh air and a welcome comedic reprieve.

Platée is traditionally a role sung by a male tenor, and this production was no exception. [Taylor Stayton](/scene/people/taylor-stayton/) is well known for his bel canto repertoire, but he proved himself an equally skilled interpreter of baroque coloratura. Slayton embodied Platée's feminine physicality with effortless grace one moment and explosive emotion the next. Platée on the surface is a visually desirable woman, but underneath her gilded exterior, she’s a petty, petulant prima donna. On the one hand, we can sense that she is a lonely soul who desires love, and Stayton gave us enough peeks into her vulnerable side to save the vain nymph from being completely irredeemable. However, once Platée gets what she thinks she wants and deserves (the affection of the king of gods himself), she doesn’t seem to appreciate it. She gets so impatient during her wedding that she throws multiple tantrums. Finally when the prank ceremony blows up in her face, Platée lashes out in embarrassment and rage. Only at the last moment do we get a brief glimpse of her possible redemption, a chance at love with a lowly admirer from her entourage that she has been overlooking all along. This was a nice touch added to the opera by director Chas Rader-Shieber that ended Platée's story with a positive note.

Rameau’s _Platée_ is one of many baroque pieces that have fallen out of favor over the years, but Des Moines Metro Opera's unique spin on an old opera was a breath of fresh air and a welcome comedic reprieve from an otherwise gloomy weekend of tragic tales and rainy skies.

## _The Queen of Spades_

The third installment of my opera marathon was Tchaikovsky's _The Queen of Spades_, a demented tale of death and obsession based on a short story by Pushkin.

The designs for this production were decadent and refined, a tribute to eighteenth century aesthetics. The costumes designed by Jonathan Knipscher fell into two categories, military men and noble women. The men wore crisp red and blue uniforms. Only the lead tenor Gheman stood out in his more muted burgundy, making his status as an outsider instantly apparent. The women wore more delicate fabrics, typically in pale creams or bold reds. Lisa, the lead soprano, was also set apart visually in the crowd scenes, often wearing softer pinks against the bright scarlets. The Countess similarly was dressed in less vibrant colors, and her afterlife ensemble was the height of luxury. Even as a ghost, the Countess was the most stylish soul in the room.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824677/media/2021/07/DMMO-Queen-Chorus_tmssvq.jpg){{% /md %}}

<figcaption>The chorus of Des Moines Metro Opera's production of The Queen of Spades, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Andrew Boyce's scenic designs celebrated beauty and art in combination with minimalist color schemes. Strategic use of framed paintings provided context for specific locations, most notably in the Winter Canal scene. As the opera progressed, the Countess’s portrait from her youth became an increasingly dominant presence. Gherman first encounters the painting in her bedroom, and he remarks on her famed beauty. Then after his confrontation with the old woman that leads to her death, her image continues to haunt the stage. The bare walls are turned around to reveal enlarged portions of the portrait, and by the final scene, the Countess's face looms from every corner.

The stage direction by Matthew Ozawa felt natural without being stagnant. Some of the death scenes came across as anticlimatic, in particular Lisa's suicide which seemed to be a symbolic depiction of her throwing herself into the icy water but lacked the desperation to make that clear. The emotions behind all three major deaths were powerful, and I just didn't get the visual impact hit to match Tchaikovsky’s music.

David Neely led the orchestra in a robust performance of Tchaikovksy's lush musical realm. From the silky melodies to the sinister undercurrents, the ensemble illustrated the tumultuous emotions of Gherman's descent into love and madness with equal skill, and I often found myself basking in the plush orchestration, no words needed to express the drama.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824726/media/2021/07/DMMO-Queen-CadieJBryanTaylorRaven_s0mi1g.jpg){{% /md %}}

<figcaption>Cadie J. Bryan (Prilepa) and Taylor Raven (Milovzor) in Des Moines Metro Opera's production of The Queen of Spades, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Once again the chorus and dancers delivered glorious performances, providing a fully realized and complex world for the story to unfold within. Todd Rhoades' choreography was the highlight of the royal ball scene, and the dancers brought an elegant charm to the pastoral ballet.

While _The Queen of Spades_ primarily focuses on four main characters, the cast was rounded out with a number of supporting roles that provided beautiful musical moments and comedic relief. Peter Scott Drackley and Andrew Gilstrap sang the roles of Tchekalinsky and Sourin respectively, the soldiers that enjoy teasing Gherman for his strange gambling obsession. Both Drackley and Gilstrap performed the roles with lyricism and a much needed touch of humor in an otherwise heavy story.

Gherman's only friend seemed to be Count Tomsky, sung by Benjamin Taylor. Tomsky was often the voice of reason in the opera, and Taylor brought dignity and warmth to the role. Taylor shined in his two arias, most notably in the first act where he tells the tale of the Countess and the infamous three cards. His voice captured the ominous nature of the legend, and he had the audience riveted.

Within the feminine sphere of the opera, Taylor Raven was absolutely charming in the role of Pauline, Lisa's closest friend. Raven's rich mezzo voice was well suited to Tchaikovsky’s lush lyrical melodies, and her performance of the mournful romance in the first act was hauntingly beautiful.

> The Countess was a regal presence on the stage, and Joyce Castle captured her aristocratic air effortlessly. 

Alexander Birch Elliott sang the role of Prince Yeletsky, Gherman's romantic rival. Elliott's resounding baritone voice was everything Tchaikovsky could desire, and his performance of his act two aria "Ya vas lyublyu" was velvety and rich. (How anyone could choose Gherman after hearing the Prince's heartfelt confession I’ll never understand!)

The Countess was a regal presence on the stage, and Joyce Castle captured her aristocratic air effortlessly. Castle sang the role with a touch of bitterness, fitting for a woman haunted by her past. All the main characters have their own unhealthy obsessions, and the Countess is a faded beauty longing to return to her glory days. Even after her sudden death, she continues to influence the story, and Castle brought a simmering intensity to the ghostly apparition out for revenge.

[Sara Gartland](/scene/people/sara-gartland/) graced the stage in the role of Lisa, the Countess's granddaughter and Gherman’s beloved. Gartland sang with passion and finesse, displaying Lisa's progression from innocent infatuation to desperate obsession. I found it hard to connect with the character of Lisa through no fault of the performance itself. The young noblewoman is madly in love with Gherman, but it was difficult to figure out why. Was it love at first sight? Had they corresponded in the past? The two lovers didn’t seem to really know each other, but the audience was supposed to accept their romance without much emotional or musical build up to it. Gartland's vocal delivery in Lisa's tragic third act aria was heartbreaking and beautiful, but the death scene's impact was undercut by a lack of compelling romantic interactions leading up to her demise.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626824810/media/2021/07/DMMOQueen-TaylorRavenKseniiaPolstiankinaBarradAmandaSheriff_xm8gcb.jpg){{% /md %}}

<figcaption>Taylor Raven as (Pauline, centre), Kseniia Polstiankina Barrad (on-stage pianist),  and Amanda Sheriff (left) in Des Moines Metro Opera's production of The Queen of Spades, 2021. Photo: Duane Tinkey.</figcaption>

</figure>

Tenor Jonathan Burton has a heroic vocal quality that is ideal for Tchaikovsky, and he depicted Gherman's varying levels of anguish to great effect. I didn't find Gherman's passion for Lisa particularly convincing, but perhaps that was a dramatic choice. Is he truly after the girl or her grandma's gambling secret? In the end, his obsession with the three cards triumphs over love. Burton captured the manic energy of Gherman in the last scene with vigor, and while his suicide was a bit clumsy, he managed to deliver a tender musical exit even while strewn across a card table littered with cash.

Tchaikovsky's _The Queen of Spades_ checks all the favorite melodrama tropes--a love triangle, a curse, and numerous tragic deaths--and what more could an opera lover ask for? Beautiful music and over the top emotions are the key to the art form, and Des Moines Metro Opera supplied both crucial ingredients in abundance.

## _The John Holiday Experience_

I wrapped up my weekend of opera with a touching performance by countertenor [John Holiday](/talking-with-singers-john-holiday/). The first half of the recital focused on classical selections, ranging from ethereal chansons to earthy spirituals. Holiday chose to showcase songs by black composers, and I wholeheartedly agree with his assertion that their works deserve the same recognition as their white contemporaries. Holiday brought passion and flawless vocals to every piece, and his personal relationship to the texts was evident in his delivery.

The musical fireworks were complimented by colorful lighting. The backdrop would subtly shift hues to match the emotions of the songs, like a massive mood ring that was tuned to the audience.

John Holiday collaborated with two pianists for the performance, Kevin J. Miller and Neeki Bey, each accompanying Holiday for one half of the performance. The mutual respect between all three men was evident in their connections onstage. Holiday would playfully quip with the pianists between songs, and both Miller and Bey displayed tender musicality and technical skill upon their instrument as Holiday soared above.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1626825043/media/2021/07/JohnHoliday_etdgct.jpg){{% /md %}}

<figcaption>Countertenor John Holiday.</figcaption>

</figure>

The second half of the recital featured pop favorites and jazz standards, and Holiday's genuine connection with the audience made for a relaxed and intimate experience. He encouraged the crowd to clap and sing along to certain numbers, and he expressed sincere gratitude that they were joining him for the performance. After an isolating year, the camaraderie of gathering together in the name of music was palpable.

Holiday's vocal skill was astounding as he tackled everything from George Gershwin to Norah Jones. His transitions between vocal registers were absolutely seamless, gliding from chest voice into falsetto with ease. His versatility was only outmatched by his obvious love for every genre he performed. It was truly a joy to watch him sharing his passion and talent onstage.

This past weekend was an immersive reintroduction to all things opera. From musical comedy to tragic melodrama, Des Moines Metro Opera's 49th season had it all. The pandemic may have put performances on hiatus, but audiences are back and eager to enjoy live theater with all the passion and perseverance of the human experience. Welcome back, opera. We've missed you!