+++
author = ["authors/daniel-weisman.md"]
categories = "Review"
date = "2018-02-26T13:50:00-05:00"
lastmod = "2018-02-26T19:41:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670939672/sq---JB4A0761.jpg.jpg"
primary_image_credit = "Stefano de Peppo (Sulpice), Andriana Chuchman (Marie), and Santiago Ballerini (Tonio) in La fille du régiment, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera."
publishDate = "2018-02-26T14:36:00-05:00"
related_articles = ["articles/talking-with-singers-stephanie-blythe.md"]
related_companies = ["scene/companies/the-atlanta-opera.md"]
related_people = ["scene/people/andriana-chuchman.md"]
short_description = "The entire cast had impeccable comic timing, but the crowd favorite was Stephanie Blythe&#039;s role and company debut as the Marquise of Berkenfield. Ms. Blythe, who is one of the most frequently sought after mezzo-sopranos of the day, moved with exceptional comic timing, managing to make her grace and composure a source of hilarity."
slug = "a-bel-canto-winner-atlantas-fille-du-régiment"
title = "A bel canto winner: Atlanta&#039;s Fille du régiment"

+++
E. Loren Meeker's production of Gaetano Donizetti's [*The Daughter of the Regiment*](https://www.atlantaopera.org/performance/the-daughter-of-the-regiment/) (or *La fille du régiment*) was like a finely tuned cuckoo clock, the well-oiled moving gears seamlessly presenting Atlanta Opera's setting at the Cobb Energy and Performing Arts Center with minimal distractions.

The production itself was reminiscent of a movie from the Golden Age of Disney. Beautiful painted sets filled with warm colors, skillfully crafted props and costumes that created a uniform characterization of the characters. The story itself is comparable to a traditional Cinderella or Snow White, in that it follows a young, seemingly orphaned girl named Marie, adopted by a regiment of French soldiers whom she considers her father(s). Marie serves as the canteen girl for the troops during a conflict between the French and the Tyrols. Offstage, Marie seemingly slips off a cliff only to be rescued by a Tyrolean man named Tonio. They fall in love and, upon learning this, Marie's regimental fathers (led by Sergeant Sulpice) forbid her to love him as she is only allowed to marry a soldier from their regiment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670482698/JB4A9786.jpg.jpg)
<figcaption>Andriana Chuchman (Marie) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

Simultaneously, we are also introduced to the Tyrolean Marquise of Berkenfield, a somewhat snooty noblewoman who asks the regiment to help escort her safely back to her home at the end of the French-Tyrolean conflict. Meanwhile, Tonio decides to join the regiment in hopes of winning the favor of the soldiers on his quest to be with Marie. The soldiers accept him into the regiment and even agree to allow him to marry Marie just as the Marquise arrives, claiming to be Marie's aunt by birth, and telling them that Marie must come live with her to gain a sense of culture, grace, and manners, as well as in expectation that Marie will marry the nephew of the unbelievably wealthy Duchess of Krakenthorp. Like many a bel canto opera, chaos naturally ensues.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670694755/JB4A0488.jpg.jpg)
<figcaption>Andriana Chuchman (Marie) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

Atlanta Opera's production was presented with the music sung in French and the dialogue adapted to English. While this decision was initially jarring, it was easy to overlook frustrations this could have caused after the initial scene, once the audience had gotten used to it. The translation of the spoken dialogue was charmingly efficient, clever, and made use of many comedic moments that could have easily been lost in translation from the original French. The choreography was clean, crisp, and fitting of a comic opera. Choreographer Meg Gillentine, who previously collaborated with Atlanta Opera in their *Seven Deadly Sins* as Anna II and again as the choreographer for *The Flying Dutchman*, managed to find a beautiful sense of uniformity while also allowing the individual characters to shine, even with the men's chorus who seemed to complete the analogy by representing Snow White's seven dwarfs.

The men's chorus was spotlighted beautifully, expertly prepared by chorus master Rolando Salazar, who created a clean even sound while the staging and choreography allowed them to shine and take on a principle role throughout the course of the opera. Even though the women's chorus only sang in the opening of the first act and the finale of the second, they too were precise, clear, and well rehearsed.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670716831/JB4A0507.jpg.jpg)
<figcaption>Stephanie Blythe (Marquise of Berkenfield) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

The entire cast had impeccable comic timing, but the crowd favorite was Stephanie Blythe's role and company debut as the Marquise of Berkenfield. Ms. Blythe, who is one of the most frequently sought after mezzo-sopranos of the day, moved with exceptional comic timing, managing to make her grace and composure a source of hilarity. Ms. Blythe's voice was world-class, a rich, even color throughout her entire range. Marie's music scene, in which Ms. Blythe's character tries to train Marie in the art of singing was one of my favorite scenes of the night. Soprano [Andriana Chuchman](/scene/people/andriana-chuchman/)'s interpretation of Marie was sung with a sweet, crystal clear sound and a control that was made all the more interesting by her purposefully unmannered acting and execution of choreography.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670745337/JB4A0614.jpg.jpg)
<figcaption>Andriana Chuchman (Marie) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

What is a bel canto opera without an element of true love? Ms. Chuchman's excellent Marie played perfectly to [Santiago Ballerini](/scene/people/santiago-ballerini/)'s fitting Tonio. Mr. Ballerini, who sang with the company previously and served as an inaugural member of the Atlanta Opera's Studio Program during their 2016-2017 season where he jumped unexpectadly into the role of Ernesto in the company's *Don Pasquale*. Mr. Ballerini's voice is the exact vocal color, size, and beauty of a bel canto tenor. Tonio fit Mr. Ballerini well. His famed act one aria "Ah! mes amis" was a rousing number full of pristine high C's that caused the audience to erupt in applause, stopping the action onstage for nearly a minute. However, as much as the famous showstopper-aria amazed, it was Mr. Ballerini's interpretation of Tonio's second act aria, "Pour me rapprocher de Marie", in which Tonio begs the Marquise for Marie's hand in marriage, that I found to be one of the most artistically and musically satisfying moments of the evening.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670752744/JB4A9900.jpg.jpg)
<figcaption>Santiago Ballerini (Tonio) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

Stefano de Peppo's Sergeant Sulpice was delivered with honesty and a golden baritone. Sulpice’s meddling, which helps bring himself, Marie, and Tonio together for a rousing trio during the middle of the final act, was presented masterfully, with de Peppo's amazing sense of comedy helping him stand his own alongside the two love-birds for whom the story is told.

The role of Hortensius, the Marquise de Berkenfield's butler, was sung by Tyler Simpson, who brought a wonderful sense of stern attentiveness to the lackadaisical ensemble of supernumeraries and the whimsical soldiers parading around in feathered hats while also promising a carmely, well practiced bass-baritone.

The smaller roles are not to be ignored. Atlanta Opera Studio Artist Christopher Dunham's Corporal was an excellent standout, both vocally and comedically. Tenor Sung Bao, who has been a frequent performer with the Atlanta Opera chorus, stepped into the role of the Peasant in the first scene, pleasantly representing that Atlanta Opera chorus. In the non-singing role as the Duchess of Krakenthorp, Shannon Eubanks delivered an excellent performance as a seemingly bitter rich woman who seemed to draw the air from the room with every word.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519670769952/JB4A0975.jpg.jpg)
<figcaption>Andriana Chuchman (Marie) and Santiago Ballerini (Tonio) in *La fille du régiment*, The Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

The production was set for success with E. Loren Meeker's directing, Meg Gillentine's excellent choreography, James Noone's picturesque scenery depicting the Tyrolean mountaintops, coupled with the rest of the phenomenal production and technical scene on top of a wonderful cast, well rehearsed chorus, and an orchestra led by [Christopher Allen](/talking-with-conductors-christopher-allen/)'s consistent and clean conducting. This production is perfect for families, opera lovers, and even as a "first opera" experience for new opera-goers.