+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2018-11-18T17:15:00-05:00"
lastmod = "2018-11-19T22:10:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542642885497/sq181112_juilliard_1160.jpg.jpg"
primary_image_credit = "Anneliese Klenetsky (The Governess), Britt Hewitt (Miles), Charles Sy (Peter Quint) in The Turn of the Screw, The Juilliard School, 2018. Photo: Rosalie O'Connor."
publishDate = "2018-11-19T10:57:00-05:00"
related_articles = ["articles/standout-performances-in-ava-doublebill.md"]
related_companies = ["scene/companies/the-juilliard-school.md"]
related_people = ["scene/people/charles-sy.md"]
short_description = "The singers are works-in-excellent-progress, with the exception of Mr. Sy who is already &quot;ready for the big time.&quot; Mr. Sy possesses an extraordinary tenor instrument that switches easily and constantly from forte to pianissimo, and from full voice to falsetto."
slug = "Julliards-turn"
title = "Juilliard&#039;s Turn"
+++

A few steps from the Met at Lincoln Center you will find a second opera company – this one at The Juilliard School. There you will find graduate voice students working on their craft and some of them, no doubt, will one day graduate to the opera house across the courtyard. It's an unusual proximity. It's as if there was a AAA baseball team a few steps from Yankee Stadium. 

Benjamin Britten's *The Turn of the Screw* is the latest production from Juilliard and the sum of the hits and misses add up to a worthwhile evening.

Britten's work is a ghost story with a libretto by Myfanwy Piper that is faithful to the novella by Henry James. It's a chamber opera - the theatrical equivalent of a novella; short and to the point. It’s perhaps the most accessible and most-performed of Britten's works.

This is the perfect choice for a school. It requires a small cast, small orchestra and no elaborate set changes. The excellent set here, by Alexis Distler, is a section of an old estate – perhaps a ballroom? - and it's as eerie as the phantoms who live there. The wallpaper is rotting away from the walls and the roof is so rotten that there is a large section open to the sky. A place where only the dead could live. 

An unnamed Governess (Anneliese Klenetsky) arrives at the estate where she has been put in charge of a boy (Miles, played by Britt Hewitt) and a girl (Flora, played by Joan Hofmeyr.) Little does the Governess know that her job is about to go way beyond what Mary Poppins had to deal with – part of her duties include saving the lives of her charges and keeping them away from the evil spirits who dwell among them. (The ghosts are played by Charles Sy as Peter Quint, and Rebecca Pedersen as Miss Jessel.) There is a servant who also lives at the house (Mrs. Grose, played by Katerina Burton,) but she proves to be of no help since she can’t see the ghosts; they're only visible to the Governess and, we learn later, one of the children.

It's a great premise for a theatre piece and Mr. Britten is the perfect composer for it.  His signature atonal style makes everything even spookier.  He constantly mitigates the suspenseful strings and percussion with the lightness of a harp and celesta that musically remind us that this is also a story about the vulnerability of children. There are some beautiful quartets and duets which need virtually no instrumental accompaniment at all. In particular, the duet "What a clever boy," between the Governess and Mrs. Grose features a breathtaking harmony.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542642897191/181112_juilliard_0612.jpg.jpg)
<figcaption>Anneliese Klenetsky (The Governess), Charles Sy (Peter Quint) in *The Turn of the Screw*, The Juilliard School, 2018. Photo: Rosalie O'Connor.</figcaption>
</figure>

The singers are works-in-excellent-progress, with the exception of Mr. Sy who is already "ready for the big time." Mr. Sy possesses an extraordinary tenor instrument that switches easily and constantly from forte to pianissimo, and from full voice to falsetto. Mr. Britten has written numerous disturbing and creepy melismas for the ghost, all variations of the one-syllable name "Miles," and Mr. Sy proves to be a real fright.

Ms. Hewitt, as the boy Miles, also accomplishes a difficult task. A well-trained soprano, Ms. Hewitt is called upon to sing with straight tones, devoid of any vibrato, and occasionally ever-so-slightly off-pitch – what an "untrained boy" might sound like. Not easy. Brava.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542642927223/181112_juilliard_1169.jpg.jpg)
<figcaption>Chance Jonas-O’Toole (The Prologue), Anneliese Klenetsky (The Governess), Charles Sy (Peter Quint) in *The Turn of the Screw*, The Juilliard School, 2018. Photo: Rosalie O'Connor.</figcaption>
</figure>

The rest of the cast is solid and believable. Ms. Klenetsky is an effectively terrified Governess. Ms. Hofmeyr and Ms. Burton are pitch-perfect as the little girl Flora and the servant Mrs. Grose, respectively. As the ghost of poor Miss Jessel, Ms. Pedersen hits all the high notes and has a promising future.

Though the singers are all still "in training", not so with the phenomenal thirteen-piece chamber orchestra of Juilliard students under the baton of Steven Osgood. There's nowhere to hide in this score. With the exception of combinations from the five-piece string section, the score is intentionally non-orchestral and is essentially a series of solos from the other instruments with piano, celesta, flute, harp, piccolo, oboe, etc. Each of the musicians took turns providing multiple stellar moments. Percussionist Harrison Honor was particularly masterful when he played the timpani and the "church bells" which are the focus of an entire scene in the second act.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542642905930/181112_juilliard_0747.jpg.jpg)
<figcaption>Joan Hofmeyr (Flora), Britt Hewitt (Miles), Charles Sy (Peter Quint), Rebecca Pedersen (Miss Jessel) in *The Turn of the Screw*, The Juilliard School, 2018. Photo: Rosalie O'Connor.</figcaption>
</figure>

The lighting from Kate Ashton really sets the mood – she has transformed stage lights into the light of "flickering candles" (and yet we never miss a moment).

While director John Giampietro shares in all of the praise written so far, he ultimately gets in the way of his own production. There were a number of head-scratching choices he made that served as monumental distractions. The character of The Prologue (Chance Jonas-O'Toole) is supposed to be just that – a prologue that is present before the action of the play. Instead, Mr. Giampietro has Mr. Jonas-O'Toole wander in and out of many scenes (sometimes simply for practical reasons as he brings in important props and set pieces.) Dressed in a white wig and long white coat, however, he's never able to disappear into the scenery. This really kills the climax of the play when the Governess is chilled by the prospect of being all alone on the enormous estate with only Miles and the evil ghost of Peter Quint. What is the Prologue doing in that scene upstaging her? And what's with the flying piano during the opera's most stirring duet?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542642914065/181112_juilliard_0896.jpg.jpg)
<figcaption>Anneliese Klenetsky (The Governess), Rebecca Pedersen (Miss Jessel) in *The Turn of the Screw*, The Juilliard School, 2018. Photo: Rosalie O'Connor.</figcaption>
</figure>

Mr. Giampietro also has added some running metaphors – a mock wedding, butterflies, etc. – that are simply confusing and steal the focus from the vital moments created by the composer and librettist. The singers and orchestra have worked hard on this complex and haunting work and they deserve our attention.
