+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-01-09T21:48:00-05:00"
lastmod = "2016-01-10T16:21:00-05:00"
preamble = "Singers have always been quick to notice a great role in an opera, and put it on their to-do list, be it for the near or distance future. 20th-century operatic roles like Carlisle Floyd's Susannah and Corigliano's Marie Antoinette have found their way into the mainstream repertoire; as a result, arias from these operas appear on singers' audition packages, the true test of an opera that has caught on with the public. \n\nAs we creep further into the 2010s, there exists enough new opera to take stock of the 21st-century roles deserving of our attention. Who are the Anne Trueloves, the Captain Veres, the Chiang Ch'ings of today? To help answer those great questions, we offer up 8 delicious roles from operas of this generation."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452459165385/2016-01-09---LunaAriel---Ken-Howard_Met.jpg.jpg"
primary_image_credit = "Audrey Luna as Ariel in Thomas Adès' The Tempest, The Metropolitan Opera, 2012. Photo: Ken Howard/Metropolitan Opera"
publishDate = "2016-01-10T16:17:00-05:00"
related_articles = ["articles/cecilia-bartoli-atonal-music-creates-a-barrier-between-composer-and-singer.md","articles/michael-christie-new-opera-that-the-box-office-loves.md","articles/4-arias-their-common-misconceptions.md","articles/5-opera-mothers-from-hell.md","articles/seasonal-opera-done-right-at-hgo.md","articles/4-reasons-to-get-excited-about-opera-in-2018.md","articles/4-singers-you-might-not-know-but-should.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/opera-philadelphia.md","scene/companies/the-dallas-opera.md","scene/companies/bayerische-staatsoper.md"]
related_people = ["scene/people/david-daniels.md","scene/people/barbara-hannigan.md","scene/people/robert-lepage.md","scene/people/michael-christie.md","scene/people/royce-vavrek.md"]
short_description = "As we creep further into the 2010s, there exists enough new opera to take stock of the 21st-century roles deserving of our attention. Who are the Anne Trueloves, the Captain Veres, the Chiang Ch&#039;ings of today? To help answer those great questions, we offer up 8 delicious roles from operas of this generation."
slug = "8-contemporary-roles-to-covet"
title = "8 contemporary roles to covet"
+++

## Ariel in *The Tempest*

Coloratura sopranos, you've got another Everest role on your hands. Thomas Adès' operatic take on Shakespeare makes perfect use of the spirit Ariel, bound to serve the magician Prospero. Ariel's is one of my top three opera character entrances (up there with Klytemnästra in *Elektra* and Musetta in *La bohème*), starting off at a psychotic pace of head-spinningly high, unnatural shrieking, as any non-human sprite would do. Audrey Luna is my pick for singers of this mental role, and if you have a subscription to the Metropolitan Opera's On Demand service, you can watch Robert Lepage's production with mouth agape. If you don't (by the way, the free trial is worth signing up for just for *The Tempest*), check out this little preview of what Ariel gets to do, sung by Luna herself.

<figure data-type="video">
<iframe width="1280" height="720" src="https://www.youtube.com/embed/U3x6t0qb3as" frameborder="0" allowfullscreen></iframe>
</figure>

## Oscar Wilde in *Oscar*

Not only is there a leading role based on one of history's most colourful and tragic people, but the role is written for a countertenor. Theodore Morrison's opera, *Oscar*, based on the life of Oscar Wilde (with libretto by John Cox) was a co-commission and co-production with Opera Philadelphia and the Santa Fe Opera, and the 2013 premiere cast includes David Daniels as Oscar, Dwayne Croft as Walt Whitman, and Heidi Stober and William Burden as Wilde's friends, Ada Leverson and Frank Harris. I'll admit that I haven't yet seen it, and I hope it gets more plays in future seasons so I can remedy that. Yet, in listening to small excerpts like the one below, *Oscar* has a feeling of "it's-about-time-we-made-an-opera-about-this". What a role, what a person for any countertenor to sink his teeth into.

<figure data-type="video">
<iframe width="1280" height="720" src="https://www.youtube.com/embed/F0mdxFJZ5XA" frameborder="0" allowfullscreen></iframe>
</figure>

## Agnès in *Written on Skin*

A young woman, illiterate and married at 14, "liberates herself" from her womanly and societal confines by having an affair with a younger man. Agnès in George Benjamin's *Written on Skin*, which premiered at Festival d'Aix-en-Provence in 2012, is a role that stretches the singer, and polarises the audience. I was lucky to catch an in-concert performance of the opera with the Toronto Symphony Orchestra, and I found the writing for Agnès to be the most compelling. I'm sure much of that was helped by Barbara Hannigan's singing, but Agnès is a new sort of dangerous woman in opera, with an organic and black mix of immaturity and adult wanting. For a taste, check out this trailer for *Written on Skin* at the Royal Opera House.

<figure data-type="video">
<iframe width="1080" height="608" src="https://www.youtube.com/embed/onYj_-6yFw4" frameborder="0" allowfullscreen></iframe>
</figure>

## Starbuck in *Moby-Dick*

Jake Heggie's successful 2010 opera based on Herman Melville's novel has gone up on the stages of The Dallas Opera, San Francisco Opera, San Diego Opera, the State Opera of South Australia, and Calgary opera. Not bad for a 21st-century opera, and perhaps it's an example of how lyric writing for the voice can go a really long way for audience reception. While Captain Ahab is a heroic, Heldentenor-like role of this century, the story of Starbuck, his first mate, is powerfully written in Heggie's long lines. Starbuck isn't swept up in the mythology of Ahab, and looks on, baffled, as a shipful of men risk their lives for the captain's mad vengeance on the white whale that took his leg. Have a listen to Starbuck's awesome, Puccini-reminiscent aria, sung by baritone David Pershall at the Dallas Opera Family Concert in 2012.

<figure data-type="video">
<iframe width="1280" height="720" src="https://www.youtube.com/embed/VBa_U5q0P4I" frameborder="0" allowfullscreen></iframe>
</figure>

## Anna Nicole Smith in *Anna Nicole*

Whether you like Mark-Anthony Turnage's 2010 opera, *Anna Nicole*, it's hard to deny that Ms. Smith herself is an extraordinary character for an opera. She had a kind heart and she dreamed big, and her personal demons were very, very public. People mocked her, undervalued her, and when she lived up to their expectations, it felt like catharsis. It takes a very special soprano indeed to pull off this role, where the singing of it is just the tip of the iceberg. Dutch soprano Eva-Maria Westbroek sang the title role in the Royal Opera House's premiere production, but have a listen to this trailer for *Anna Nicole* at Oper Dortmund, starring Emily Newton in the title role.

<figure data-type="video">
<iframe width="1280" height="720" src="https://www.youtube.com/embed/c7EWAQbfp00" frameborder="0" allowfullscreen></iframe>
</figure>

## Gertrude Stein in *27*

Ricky Ian Gordon's opera, with librettist Royce Vavrek, is the story of Gertrude Stein and her partner Alice B. Toklas, and the salon evenings they hosted at their home in Paris, at 27 rue de Fleurus. *27* premiered in 2014, a commission for Opera Theater of St. Louis, and the role of Gertrude Stein being written for mezzo-soprano [Stephanie Blythe](/scene/people/stephanie-blythe/). Playing Gertrude Stein is a meaty task for any singer, and from what's available for listening, the role isn't for any old mezzo-soprano. Yet, *27* may offer a leading mezzo role of the 21st century - the music has an easy organicism in it, and Ms. Stein's biography leaves much to chew on. Have a look at this behind-the-scenes video of the making of *27*, and try not to get caught up in how much Stephanie Blythe loves her character. (To hear more, there's [this audio clip](https://www.youtube.com/watch?v=8UxmYWLvMsM&index=1&list=PL3yrlvmdaUwhdwJ7X6zzU22q44SG-jt-Z) available on YouTube.)

<figure data-type="video">
<iframe width="685" height="385" src="https://www.youtube.com/embed/DjbUAJjYexs" frameborder="0" allowfullscreen></iframe>
</figure>

## Prospero in *The Tempest*

Circling back to Adès' *The Tempest*, a beautiful leading baritone role comes in the form of Prospero, the magician from Shakespeare's 1611 play. The vengeful magician gets some heroic lines from Adès, and every baritone likes to teeter on the edge between benevolence and malevolence. Have a listen to this clip from the Metropolitan Opera's 2012 production, starring Simon Keenlyside as Prospero.

<figure data-type="video"><iframe width="1280" height="720" src="https://www.youtube.com/embed/lblXrXJN9-k" frameborder="0" allowfullscreen></iframe>
</figure>

## The Cheshire Cat in *Alice in Wonderland*

This is more of a curiosity piece than a true suggestion; the role of the Cheshire Cat is probably not too portable for a contemporary opera, but this production of Korean composer Unsuk Chin's 2007 opera *Alice and Wonderland* is a spectacle indeed. The opera is an adaptation of both Lewis Carroll's *Alice's Adventures in Wonderland* and *Through the Looking Glass*, and it premiered at the Bavarian State Opera under Kent Nagano I feel like I know a few singers myself who would play a wicked Cheshire Cat; you can enjoy the bizarreness of Piia Komsi's Cat right here. (Actually, you can watch the whole opera, but we've timed it up for you here.)

<figure data-type="video">
<iframe width="1280" height="720" src="https://www.youtube.com/embed/_hXt-BPhRKA?start=3085" frameborder="0" allowfullscreen></iframe>
</figure>

>What are some contemporary roles that have you excited? Let us know in the comments below!
